/*
 * Decompiled with CFR 0.152.
 */
package io.intino.slackapi;

import io.intino.slackapi.SlackUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SlackChannel {
    private final boolean direct;
    private String id;
    private String name;
    private Set<SlackUser> members = new HashSet<SlackUser>();
    private String topic;
    private String purpose;
    private boolean isMember;
    private boolean isArchived;

    public SlackChannel(String id, String name, String topic, String purpose, boolean direct, boolean isMember, boolean isArchived) {
        this.id = id;
        this.name = name;
        this.topic = topic;
        this.purpose = purpose;
        this.direct = direct;
        this.isMember = isMember;
        this.isArchived = isArchived;
    }

    public void addUser(SlackUser user) {
        this.members.add(user);
    }

    void removeUser(SlackUser user) {
        this.members.remove(user);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Collection<SlackUser> getMembers() {
        return new ArrayList<SlackUser>(this.members);
    }

    public String getTopic() {
        return this.topic;
    }

    public String toString() {
        return "SlackChannel{topic='" + this.topic + "', purpose='" + this.purpose + "', id='" + this.id + "', name='" + this.name + "'}";
    }

    public String getPurpose() {
        return this.purpose;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public SlackChannelType getType() {
        if (this.isDirect()) {
            return SlackChannelType.INSTANT_MESSAGING;
        }
        if (this.id.startsWith("G")) {
            return SlackChannelType.PRIVATE_GROUP;
        }
        return SlackChannelType.PUBLIC_CHANNEL;
    }

    public static enum SlackChannelType {
        PUBLIC_CHANNEL,
        PRIVATE_GROUP,
        INSTANT_MESSAGING;

    }
}

