/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.session;

import io.intino.sezzet.operators.SetStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SessionFileReader {
    private static final int LONG_SIZE = 8;
    private static final int INT_SIZE = 4;
    private final File file;
    private final List<Chunk> chunks = new ArrayList<Chunk>();
    private Instant instant;

    public SessionFileReader(File file) throws IOException {
        this.file = file;
        this.readStructure(file);
    }

    public Instant instant() {
        return this.instant;
    }

    private void readStructure(File file) throws IOException {
        try {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Throwable throwable = null;
            try {
                try {
                    long pos = 8L;
                    this.instant = Instant.ofEpochMilli(stream.readLong());
                    while (true) {
                        String tank = this.readString(stream);
                        String set = this.readString(stream);
                        int idSize = stream.readInt();
                        stream.skipBytes(idSize * 8);
                        this.chunks.add(new Chunk(tank, set, idSize, pos += (long)(4 + tank.length() + 4 + set.length() + 4)));
                        pos += (long)(idSize * 8);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        stream.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private String readString(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        byte[] bytes = new byte[size];
        stream.read(bytes);
        return new String(bytes, "UTF-8");
    }

    public List<Chunk> chunks() {
        return this.chunks;
    }

    public List<Chunk> chunks(String tank, String set) {
        return this.chunks.stream().filter(c -> c.tank.equals(tank) && c.set.equals(set)).collect(Collectors.toList());
    }

    public class Chunk {
        String tank;
        String set;
        long position;
        private int idSize;

        Chunk(String tank, String set, int idSize, long position) {
            this.tank = tank;
            this.set = set;
            this.idSize = idSize;
            this.position = position;
        }

        public String tank() {
            return this.tank;
        }

        public String set() {
            return this.set;
        }

        public SetStream stream() {
            try {
                final RandomAccessFile access = new RandomAccessFile(SessionFileReader.this.file, "r");
                access.seek(this.position);
                final DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(access.getFD())));
                return new SetStream(){
                    int count = 0;
                    long current = -1L;

                    public long current() {
                        return this.current;
                    }

                    public long next() {
                        try {
                            if (!this.hasNext()) {
                                access.close();
                                stream.close();
                                this.current = -1L;
                                return -1L;
                            }
                            ++this.count;
                            this.current = stream.readLong();
                            return this.current;
                        }
                        catch (EOFException e) {
                            return -1L;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return -1L;
                        }
                    }

                    public boolean hasNext() {
                        return this.count < Chunk.this.idSize;
                    }
                };
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

