/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet;

import io.intino.sezzet.SetStore;
import io.intino.sezzet.model.graph.InstantIterator;
import io.intino.sezzet.model.graph.rules.Scale;
import io.intino.sezzet.operators.FileReader;
import io.intino.sezzet.operators.LongStream;
import io.intino.sezzet.operators.SetStream;
import io.intino.sezzet.operators.Union;
import io.intino.sezzet.session.SessionFileWriter;
import io.intino.sezzet.session.SessionSealer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class SezzetStore
implements SetStore {
    public static final String SessionExt = ".session";
    public static final String SegmentExt = ".segment";
    public static final String SetExt = ".sezzet";
    public static final String TempExt = ".temp";
    public static final String PartExt = ".part";
    private final File store;
    private Scale scale;

    public SezzetStore(File store, Scale scale) {
        this.store = store;
        this.scale = scale;
    }

    public static void write(SetStream stream, File file) throws IOException {
        file.getParentFile().mkdirs();
        DataOutputStream dataStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        while (stream.hasNext()) {
            dataStream.writeLong(stream.next());
        }
        dataStream.close();
    }

    @Override
    public Scale scale() {
        return this.scale;
    }

    @Override
    public SessionFileWriter createSession(Instant instant) {
        return new SessionFileWriter(this.sessionFile(instant), instant, false);
    }

    @Override
    public void seal() {
        SessionSealer.seal(this.stageFolder());
    }

    @Override
    public File storeSegment(Instant instant, String segment, SetStream stream) {
        try {
            String instantTag = Instant.now().toString().substring(0, 19).replace(":", "").replace("-", "");
            File file = new File(this.segmentFolder(), instantTag + "/" + segment + SegmentExt);
            SezzetStore.write(stream, file);
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void append(String tank, String set, Instant instant, long ... ids) {
        try {
            File file = this.fileOf(tank, set, instant);
            Union toWrite = file.exists() ? new Union(Arrays.asList(new FileReader(file), new LongStream(ids))) : new LongStream(ids);
            File tempFile = new File(file + TempExt);
            SezzetStore.write((SetStream)toWrite, tempFile);
            Files.move(tempFile.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> tanks() {
        String[] tanks = this.store.list((dir, name) -> !name.equals("stage"));
        return tanks != null ? Arrays.asList(tanks) : Collections.emptyList();
    }

    @Override
    public List<String> setsOf(String tank, Instant instant) {
        String[] files = this.folderOf(tank, instant).list((f, n) -> n.endsWith(SetExt));
        return files != null ? Arrays.stream(files).sorted().map(f -> f.replace(SetExt, "")).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<String> setsOf(String tank, Instant from, Instant to) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (Instant instant : new InstantIterator(from, to, this.scale)) {
            sets.addAll(this.setsOf(tank, instant));
        }
        return new ArrayList<String>(sets);
    }

    @Override
    public List<String> setsOf(String tank, String regex, Instant instant) {
        return this.setsOf(tank, instant).stream().filter(v -> this.matches((String)v, regex)).collect(Collectors.toList());
    }

    @Override
    public List<String> setsOf(String tank, String regex, Instant from, Instant to) {
        return this.setsOf(tank, from, to).stream().filter(v -> this.matches((String)v, regex)).collect(Collectors.toList());
    }

    @Override
    public List<String> setsOf(String tank, double lowBound, double highBound, Instant instant) {
        return this.setsOf(tank, instant).stream().filter(v -> this.isInRange((String)v, lowBound, highBound)).collect(Collectors.toList());
    }

    @Override
    public List<String> setsOf(String tank, double lowBound, double highBound, Instant from, Instant to) {
        return this.setsOf(tank, from, to).stream().filter(v -> this.isInRange((String)v, lowBound, highBound)).collect(Collectors.toList());
    }

    @Override
    public File folderOf(String tank, Instant instant) {
        return new File(this.store, tank + "/" + this.scale.tag(instant));
    }

    @Override
    public List<File> foldersOf(String tank, Instant from, Instant to) {
        ArrayList<File> folders = new ArrayList<File>();
        for (Instant instant : new InstantIterator(from, to, this.scale)) {
            folders.add(this.folderOf(tank, instant));
        }
        return folders;
    }

    @Override
    public File fileOf(String tank, String set, Instant instant) {
        return new File(this.folderOf(tank, instant), set + SetExt);
    }

    @Override
    public List<File> filesOf(String tank, String set, Instant from, Instant to) {
        ArrayList<File> files = new ArrayList<File>();
        for (Instant instant : new InstantIterator(from, to, this.scale)) {
            files.add(this.fileOf(tank, set, instant));
        }
        return files;
    }

    private File sessionFile(Instant instant) {
        File result;
        int count = -1;
        while (new File((result = new File(this.stageFolder(), this.scale.tag(instant) + PartExt + ++count)) + TempExt).exists() || new File(result + SessionExt).exists()) {
        }
        return new File(result + TempExt);
    }

    private boolean isInRange(String set, double lowBound, double highBound) {
        try {
            double aDouble = Double.parseDouble(set);
            return aDouble >= lowBound && aDouble <= highBound;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matches(String set, String regex) {
        return set.matches(regex.replace("*", ".*"));
    }

    private File segmentFolder() {
        return new File(this.store, "segments/");
    }

    private File stageFolder() {
        return new File(this.store, "stage/");
    }
}

