/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.session;

import io.intino.sezzet.SezzetStore;
import io.intino.sezzet.operators.FileReader;
import io.intino.sezzet.operators.SetStream;
import io.intino.sezzet.operators.Union;
import io.intino.sezzet.session.SessionFileReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SessionSealer {
    private final List<File> files;
    private File storeFolder;

    private SessionSealer(List<File> files, File storeFolder) {
        this.files = files;
        this.storeFolder = storeFolder;
    }

    public static void seal(File stageFolder) {
        File[] sessions = stageFolder.listFiles(f -> f.getName().endsWith(".session"));
        if (sessions == null) {
            return;
        }
        Map<String, List<File>> sessionsMap = SessionSealer.groupSessions(sessions);
        sessionsMap.values().forEach(v -> new SessionSealer((List<File>)v, stageFolder.getParentFile()).seal());
        SessionSealer.markAsProcessed(stageFolder, sessionsMap);
    }

    private static void markAsProcessed(File stageFolder, Map<String, List<File>> filesMap) {
        String instant = Instant.now().toString().substring(0, 19).replace(":", "").replace("-", "");
        File processedFolder = new File(stageFolder, "processed/" + instant);
        processedFolder.mkdirs();
        filesMap.values().forEach(v -> v.forEach(f -> {
            try {
                Files.move(f.toPath(), new File(processedFolder, f.getName()).toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }

    private static Map<String, List<File>> groupSessions(File[] sessions) {
        HashMap<String, List<File>> filesMap = new HashMap<String, List<File>>();
        for (File session : sessions) {
            String sealId = session.getName().substring(0, session.getName().indexOf(".part"));
            if (!filesMap.containsKey(sealId)) {
                filesMap.put(sealId, new ArrayList());
            }
            ((List)filesMap.get(sealId)).add(session);
        }
        return filesMap;
    }

    private void seal() {
        List<SessionFileReader> readers = this.loadReaders();
        Set<String> distinctChunks = this.distinctChunks(readers);
        Logger.getGlobal().info("Sets to seal " + distinctChunks.size());
        distinctChunks.parallelStream().forEach(distinctChunk -> {
            try {
                List<SetStream> streams = this.chunksOf(readers, (String)distinctChunk);
                File setFile = this.filepath((String)distinctChunk);
                File tempFile = new File(this.filepath((String)distinctChunk) + ".temp");
                if (setFile.exists()) {
                    streams.add((SetStream)new FileReader(setFile));
                }
                SezzetStore.write((SetStream)new Union(streams), tempFile);
                Files.move(tempFile.toPath(), setFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private List<SessionFileReader> loadReaders() {
        return this.files.parallelStream().map(f -> {
            try {
                return new SessionFileReader((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    private File filepath(String distinctChunk) {
        File output = new File(this.storeFolder, this.timeTag() + "/" + this.type(distinctChunk) + "/" + this.argument(distinctChunk) + ".sezzet");
        output.getParentFile().mkdirs();
        return output;
    }

    private String timeTag() {
        return this.files.get(0).getName().substring(0, this.files.get(0).getName().indexOf(".part"));
    }

    private List<SetStream> chunksOf(List<SessionFileReader> readers, String distinctChunk) {
        return readers.stream().map(r -> r.chunks(this.type(distinctChunk), this.argument(distinctChunk))).flatMap(Collection::stream).map(SessionFileReader.Chunk::stream).collect(Collectors.toList());
    }

    private String argument(String distinctChunk) {
        return distinctChunk.split("@@")[1];
    }

    private String type(String distinctChunk) {
        return distinctChunk.split("@@")[0];
    }

    private Set<String> distinctChunks(List<SessionFileReader> readers) {
        return readers.stream().map(SessionFileReader::chunks).flatMap(Collection::stream).map(c -> c.feature() + "@@" + c.value()).collect(Collectors.toSet());
    }
}

