/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.session;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SessionFileWriter {
    private Map<String, List<Long>> chunks = new LinkedHashMap<String, List<Long>>();
    private File file;
    private DataOutputStream stream;

    public SessionFileWriter(File file, Instant instant, boolean append) {
        try {
            file.getParentFile().mkdirs();
            this.file = file;
            this.stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, append)));
            this.stream.writeLong(instant.toEpochMilli());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stream = null;
        }
    }

    public void add(String feature, String value, long id) {
        String chunkId = this.chunkId(feature, value);
        if (!this.chunks.containsKey(chunkId)) {
            this.chunks.put(chunkId, new ArrayList());
        }
        this.chunks.get(chunkId).add(id);
    }

    private String chunkId(String feature, String value) {
        return feature + "@" + value;
    }

    public void flush() throws IOException {
        this.chunks.forEach(this::write);
        this.chunks.clear();
        this.stream.flush();
    }

    private void write(String chunkId, List<Long> ids) {
        try {
            String feature = chunkId.split("@")[0];
            String value = chunkId.split("@")[1];
            Collections.sort(ids);
            this.stream.writeInt(feature.length());
            this.stream.writeBytes(feature);
            this.stream.writeInt(value.length());
            this.stream.writeBytes(value);
            this.stream.writeInt(ids.size());
            for (long id : ids) {
                this.stream.writeLong(id);
            }
            this.stream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.chunks.forEach(this::write);
        this.chunks.clear();
        this.stream.close();
        Files.move(this.file.toPath(), new File(this.file.getAbsolutePath().replace(".temp", ".session")).toPath(), new CopyOption[0]);
    }
}

