/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.session;

import io.intino.sezzet.operators.SetStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SessionFileReader {
    private static final int LONG_SIZE = 8;
    private static final int INT_SIZE = 4;
    private final File file;
    private final List<Chunk> chunks = new ArrayList<Chunk>();
    private Instant instant;

    public SessionFileReader(File file) throws IOException {
        this.file = file;
        this.readStructure(file);
    }

    public Instant instant() {
        return this.instant;
    }

    private void readStructure(File file) throws IOException {
        try {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Throwable throwable = null;
            try {
                try {
                    long pos = 8L;
                    this.instant = Instant.ofEpochMilli(stream.readLong());
                    while (true) {
                        String feature = this.readString(stream);
                        String value = this.readString(stream);
                        int idSize = stream.readInt();
                        stream.skipBytes(idSize * 8);
                        this.chunks.add(new Chunk(feature, value, idSize, pos += (long)(4 + feature.length() + 4 + value.length() + 4)));
                        pos += (long)(idSize * 8);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        stream.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private String readString(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        byte[] bytes = new byte[size];
        stream.read(bytes);
        return new String(bytes, "UTF-8");
    }

    public List<Chunk> chunks() {
        return this.chunks;
    }

    public List<Chunk> chunks(String feature, String value) {
        return this.chunks.stream().filter(c -> c.feature.equals(feature) && c.value.equals(value)).collect(Collectors.toList());
    }

    public class Chunk {
        String feature;
        String value;
        long position;
        private int idSize;

        Chunk(String feature, String value, int idSize, long position) {
            this.feature = feature;
            this.value = value;
            this.idSize = idSize;
            this.position = position;
        }

        public String feature() {
            return this.feature;
        }

        public String value() {
            return this.value;
        }

        public SetStream stream() {
            try {
                final RandomAccessFile access = new RandomAccessFile(SessionFileReader.this.file, "r");
                access.seek(this.position);
                return new SetStream(){
                    int count = 0;
                    long current = -1L;

                    public long current() {
                        return this.current;
                    }

                    public long next() {
                        try {
                            if (!this.hasNext()) {
                                this.current = -1L;
                                return -1L;
                            }
                            ++this.count;
                            this.current = access.readLong();
                            return this.current;
                        }
                        catch (EOFException e) {
                            return -1L;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return -1L;
                        }
                    }

                    public boolean hasNext() {
                        return this.count < Chunk.this.idSize;
                    }
                };
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

