/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet;

import io.intino.sezzet.SetStore;
import io.intino.sezzet.model.graph.InstantIterator;
import io.intino.sezzet.model.graph.rules.Scale;
import io.intino.sezzet.operators.FileReader;
import io.intino.sezzet.operators.LongStream;
import io.intino.sezzet.operators.SetStream;
import io.intino.sezzet.operators.Union;
import io.intino.sezzet.session.SessionFileWriter;
import io.intino.sezzet.session.SessionSealer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class SezzetStore
implements SetStore {
    public static final String SessionExt = ".session";
    public static final String SegmentExt = ".segment";
    public static final String SetExt = ".sezzet";
    public static final String TempExt = ".temp";
    public static final String PartExt = ".part";
    private final File store;
    private Scale scale;

    public SezzetStore(File store, Scale scale) {
        this.store = store;
        this.scale = scale;
    }

    public static void write(SetStream stream, File file) throws IOException {
        DataOutputStream dataStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        while (stream.hasNext()) {
            dataStream.writeLong(stream.next());
        }
        dataStream.close();
    }

    @Override
    public Scale scale() {
        return this.scale;
    }

    @Override
    public SessionFileWriter createSession(Instant instant) {
        return new SessionFileWriter(this.sessionFile(instant), instant, false);
    }

    @Override
    public void seal() {
        SessionSealer.seal(this.stageFolder());
    }

    @Override
    public File storeSegment(Instant instant, String segment, SetStream stream) {
        try {
            File file = new File(this.segmentFolder(), this.scale.tag(instant) + "/" + segment + SegmentExt);
            SezzetStore.write(stream, file);
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void append(String feature, String value, Instant instant, long ... ids) {
        try {
            File file = this.fileOf(feature, value, instant);
            Union toWrite = file.exists() ? new Union(Arrays.asList(new FileReader(file), new LongStream(ids))) : new LongStream(ids);
            File tempFile = new File(file + TempExt);
            SezzetStore.write((SetStream)toWrite, tempFile);
            Files.move(tempFile.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> valuesOf(String feature, Instant instant) {
        String[] files = this.folderOf(feature, instant).list((f, n) -> n.endsWith(SetExt));
        return files != null ? Arrays.stream(files).map(f -> f.replace(SetExt, "")).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<String> valuesOf(String feature, Instant from, Instant to) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (Instant instant : new InstantIterator(from, to, this.scale)) {
            values.addAll(this.valuesOf(feature, instant));
        }
        return new ArrayList<String>(values);
    }

    @Override
    public List<String> valuesOf(String feature, String regex, Instant instant) {
        return this.valuesOf(feature, instant).stream().filter(v -> this.matches((String)v, regex)).collect(Collectors.toList());
    }

    @Override
    public List<String> valuesOf(String feature, String regex, Instant from, Instant to) {
        return this.valuesOf(feature, from, to).stream().filter(v -> this.matches((String)v, regex)).collect(Collectors.toList());
    }

    @Override
    public List<String> valuesOf(String feature, double lowBound, double highBound, Instant instant) {
        return this.valuesOf(feature, instant).stream().filter(v -> this.isInRange((String)v, lowBound, highBound)).collect(Collectors.toList());
    }

    @Override
    public List<String> valuesOf(String feature, double lowBound, double highBound, Instant from, Instant to) {
        return this.valuesOf(feature, from, to).stream().filter(v -> this.isInRange((String)v, lowBound, highBound)).collect(Collectors.toList());
    }

    @Override
    public File folderOf(String feature, Instant instant) {
        return new File(this.store, this.scale.tag(instant) + "/" + feature);
    }

    @Override
    public List<File> foldersOf(String feature, Instant from, Instant to) {
        ArrayList<File> folders = new ArrayList<File>();
        for (Instant instant : new InstantIterator(from, to, this.scale)) {
            folders.add(this.folderOf(feature, instant));
        }
        return folders;
    }

    @Override
    public File fileOf(String feature, String value, Instant instant) {
        return new File(this.folderOf(feature, instant), value + SetExt);
    }

    @Override
    public List<File> filesOf(String feature, String value, Instant from, Instant to) {
        ArrayList<File> files = new ArrayList<File>();
        for (Instant instant : new InstantIterator(from, to, this.scale)) {
            files.add(this.fileOf(feature, value, instant));
        }
        return files;
    }

    private File sessionFile(Instant instant) {
        File result;
        int count = -1;
        while (new File((result = new File(this.stageFolder(), this.scale.tag(instant) + PartExt + ++count)) + TempExt).exists() || new File(result + SessionExt).exists()) {
        }
        return new File(result + TempExt);
    }

    private boolean isInRange(String value, double lowBound, double highBound) {
        try {
            double aDouble = Double.parseDouble(value);
            return aDouble >= lowBound && aDouble <= highBound;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matches(String value, String regex) {
        return value.matches(regex.replace("*", ".*"));
    }

    private File segmentFolder() {
        return new File(this.store, "segments/");
    }

    private File stageFolder() {
        return new File(this.store, "stage/");
    }
}

