/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql.graph.rules;

import io.intino.magritte.lang.model.Rule;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public enum Scale implements Rule<Enum>
{
    Year{

        @Override
        public String tag(Instant instant) {
            return "" + Scale.toUtc(instant).getYear();
        }

        @Override
        public String label(Instant instant) {
            return this.tag(instant);
        }

        @Override
        public int toLowerScale(int i) {
            return i * 12;
        }

        @Override
        public String toLowerScaleEnding(String label) {
            return label + "-12";
        }

        @Override
        public Instant plus(Instant instant) {
            return Scale.toUtc(instant).plusYears(1L).toInstant(ZoneOffset.UTC);
        }

        @Override
        public Instant minus(Instant instant) {
            return Scale.toUtc(instant).minusYears(1L).toInstant(ZoneOffset.UTC);
        }
    }
    ,
    Month{

        @Override
        public String tag(Instant instant) {
            return Year.tag(instant) + String.format("%02d", Scale.toUtc(instant).getMonth().getValue());
        }

        @Override
        public String label(Instant instant) {
            return Year.label(instant) + "-" + String.format("%02d", Scale.toUtc(instant).getMonth().getValue());
        }

        @Override
        public int toLowerScale(int i) {
            return i * 30;
        }

        @Override
        public String toLowerScaleEnding(String label) {
            return label + "-30";
        }

        @Override
        public Instant plus(Instant instant) {
            return Scale.toUtc(instant).plusMonths(1L).toInstant(ZoneOffset.UTC);
        }

        @Override
        public Instant minus(Instant instant) {
            return Scale.toUtc(instant).minusMonths(1L).toInstant(ZoneOffset.UTC);
        }
    }
    ,
    Day{

        @Override
        public String tag(Instant instant) {
            return Month.tag(instant) + String.format("%02d", Scale.toUtc(instant).getDayOfMonth());
        }

        @Override
        public String label(Instant instant) {
            return Month.label(instant) + "-" + String.format("%02d", Scale.toUtc(instant).getDayOfMonth());
        }

        @Override
        public int toLowerScale(int i) {
            return i * 24;
        }

        @Override
        public String toLowerScaleEnding(String label) {
            return label + "-24";
        }

        @Override
        public Instant plus(Instant instant) {
            return Scale.toUtc(instant).plusDays(1L).toInstant(ZoneOffset.UTC);
        }

        @Override
        public Instant minus(Instant instant) {
            return Scale.toUtc(instant).minusDays(1L).toInstant(ZoneOffset.UTC);
        }
    }
    ,
    Hour{

        @Override
        public String tag(Instant instant) {
            return Day.tag(instant) + String.format("%02d", Scale.toUtc(instant).getHour());
        }

        @Override
        public String label(Instant instant) {
            return Day.label(instant) + "-" + String.format("%02d", Scale.toUtc(instant).getHour());
        }

        @Override
        public int toLowerScale(int i) {
            return i;
        }

        @Override
        public String toLowerScaleEnding(String label) {
            return label + "-60";
        }

        @Override
        public Instant plus(Instant instant) {
            return Scale.toUtc(instant).plusHours(1L).toInstant(ZoneOffset.UTC);
        }

        @Override
        public Instant minus(Instant instant) {
            return Scale.toUtc(instant).minusHours(1L).toInstant(ZoneOffset.UTC);
        }
    };


    private static LocalDateTime toUtc(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
    }

    public abstract String tag(Instant var1);

    public abstract String label(Instant var1);

    public abstract int toLowerScale(int var1);

    public abstract String toLowerScaleEnding(String var1);

    public String toLowerScaleStart(String label) {
        return label + "-01";
    }

    public boolean accept(Enum value) {
        return value instanceof io.intino.sezzet.model.graph.rules.Scale;
    }

    public Instant plus(Instant instant) {
        return null;
    }

    public Instant minus(Instant instant) {
        return null;
    }
}

