/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql.graph;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import io.intino.sezzet.setql.graph.Expression;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private Expression expression;
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("setql");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("setql");
        this.expression = wrapper.expression;
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Expression expression() {
        return this.expression;
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Expression", new Indexer(node -> {
            this.expression = (Expression)node.as(Expression.class);
        }, node -> {
            this.expression = null;
        }, () -> {
            this.expression = null;
        }));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Expression expression(String raw) {
            Expression newElement = (Expression)((Expression)AbstractGraph.this.graph.createRoot(Expression.class, this.stash, this.name)).a$(Expression.class);
            newElement.core$().set((Layer)newElement, "raw", Collections.singletonList(raw));
            return newElement;
        }
    }
}

