/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql.graph;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.functions.Description;
import io.intino.sezzet.setql.graph.functions.ToString;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractExpression
extends Layer
implements Terminal {
    protected String raw;
    protected List<Expression.Operand> operandList = new ArrayList<Expression.Operand>();
    protected List<Expression.InnerExpression> innerExpressionList = new ArrayList<Expression.InnerExpression>();
    protected List<Expression.Predicate> predicateList = new ArrayList<Expression.Predicate>();

    public AbstractExpression(Node node) {
        super(node);
    }

    public String raw() {
        return this.raw;
    }

    public Expression raw(String value) {
        this.raw = value;
        return (Expression)this;
    }

    public List<Expression.Operand> operandList() {
        return Collections.unmodifiableList(this.operandList);
    }

    public Expression.Operand operand(int index) {
        return this.operandList.get(index);
    }

    public List<Expression.Operand> operandList(Predicate<Expression.Operand> predicate) {
        return this.operandList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Expression.InnerExpression> innerExpressionList() {
        return Collections.unmodifiableList(this.innerExpressionList);
    }

    public Expression.InnerExpression innerExpression(int index) {
        return this.innerExpressionList.get(index);
    }

    public List<Expression.InnerExpression> innerExpressionList(Predicate<Expression.InnerExpression> predicate) {
        return this.innerExpressionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Expression.Predicate> predicateList() {
        return Collections.unmodifiableList(this.predicateList);
    }

    public Expression.Predicate predicate(int index) {
        return this.predicateList.get(index);
    }

    public List<Expression.Predicate> predicateList(Predicate<Expression.Predicate> predicate) {
        return this.predicateList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Expression.Operand>(this.operandList).forEach(c -> components.add(c.core$()));
        new ArrayList<Expression.InnerExpression>(this.innerExpressionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Expression.Predicate>(this.predicateList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("raw", new ArrayList<String>(Collections.singletonList(this.raw)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Expression$Operand")) {
            this.operandList.add((Expression.Operand)node.as(Expression.Operand.class));
        }
        if (node.is("Expression$InnerExpression")) {
            this.innerExpressionList.add((Expression.InnerExpression)node.as(Expression.InnerExpression.class));
        }
        if (node.is("Expression$Predicate")) {
            this.predicateList.add((Expression.Predicate)node.as(Expression.Predicate.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Expression$Operand")) {
            this.operandList.remove(node.as(Expression.Operand.class));
        }
        if (node.is("Expression$InnerExpression")) {
            this.innerExpressionList.remove(node.as(Expression.InnerExpression.class));
        }
        if (node.is("Expression$Predicate")) {
            this.predicateList.remove(node.as(Expression.Predicate.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("raw")) {
            this.raw = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("raw")) {
            this.raw = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SetqlGraph graph() {
        return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
    }

    public static abstract class AbstractPredicate
    extends Expression.Operand
    implements Terminal {
        protected String property;
        protected ToString toString;
        protected Description description;
        protected Operator argumentOperator;
        protected Modifier modifier;
        protected List<Expression.Predicate.Argument> argumentList = new ArrayList<Expression.Predicate.Argument>();
        protected List<Expression.Predicate.Range> rangeList = new ArrayList<Expression.Predicate.Range>();
        protected List<Expression.Predicate.SingleValue> singleValueList = new ArrayList<Expression.Predicate.SingleValue>();
        protected List<Expression.Predicate.Numeric> numericList = new ArrayList<Expression.Predicate.Numeric>();
        protected List<Expression.Predicate.Text> textList = new ArrayList<Expression.Predicate.Text>();
        protected List<Expression.Predicate.Enum> enumList = new ArrayList<Expression.Predicate.Enum>();
        protected List<Expression.Predicate.VariableOperation> variableOperationList = new ArrayList<Expression.Predicate.VariableOperation>();
        protected Expression.Predicate.Period period;
        protected Expression.Predicate.FromNow fromNow;
        protected Expression.Predicate.TimeRange timeRange;
        protected Expression.Predicate.Frequency frequency;
        protected Expression.Predicate.Recency recency;

        public AbstractPredicate(Node node) {
            super(node);
        }

        public String property() {
            return this.property;
        }

        public String toString(Locale locale) {
            return this.toString.toString(locale);
        }

        public String description(Locale locale, String subject) {
            return this.description.toString(locale, subject);
        }

        public Operator argumentOperator() {
            return this.argumentOperator;
        }

        public Modifier modifier() {
            return this.modifier;
        }

        public Expression.Predicate property(String value) {
            this.property = value;
            return (Expression.Predicate)this;
        }

        public Expression.Predicate toString(ToString value) {
            this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
            return (Expression.Predicate)this;
        }

        public Expression.Predicate description(Description value) {
            this.description = (Description)FunctionLoader.load((Object)this.description, (Layer)this, Description.class);
            return (Expression.Predicate)this;
        }

        public Expression.Predicate argumentOperator(Operator value) {
            this.argumentOperator = value;
            return (Expression.Predicate)this;
        }

        public Expression.Predicate modifier(Modifier value) {
            this.modifier = value;
            return (Expression.Predicate)this;
        }

        public List<Expression.Predicate.Argument> argumentList() {
            return Collections.unmodifiableList(this.argumentList);
        }

        public Expression.Predicate.Argument argument(int index) {
            return this.argumentList.get(index);
        }

        public List<Expression.Predicate.Argument> argumentList(Predicate<Expression.Predicate.Argument> predicate) {
            return this.argumentList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Expression.Predicate.Range> rangeList() {
            return Collections.unmodifiableList(this.rangeList);
        }

        public Expression.Predicate.Range range(int index) {
            return this.rangeList.get(index);
        }

        public List<Expression.Predicate.Range> rangeList(Predicate<Expression.Predicate.Range> predicate) {
            return this.rangeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Expression.Predicate.SingleValue> singleValueList() {
            return Collections.unmodifiableList(this.singleValueList);
        }

        public Expression.Predicate.SingleValue singleValue(int index) {
            return this.singleValueList.get(index);
        }

        public List<Expression.Predicate.SingleValue> singleValueList(Predicate<Expression.Predicate.SingleValue> predicate) {
            return this.singleValueList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Expression.Predicate.Numeric> numericList() {
            return Collections.unmodifiableList(this.numericList);
        }

        public Expression.Predicate.Numeric numeric(int index) {
            return this.numericList.get(index);
        }

        public List<Expression.Predicate.Numeric> numericList(Predicate<Expression.Predicate.Numeric> predicate) {
            return this.numericList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Expression.Predicate.Text> textList() {
            return Collections.unmodifiableList(this.textList);
        }

        public Expression.Predicate.Text text(int index) {
            return this.textList.get(index);
        }

        public List<Expression.Predicate.Text> textList(Predicate<Expression.Predicate.Text> predicate) {
            return this.textList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Expression.Predicate.Enum> enumList() {
            return Collections.unmodifiableList(this.enumList);
        }

        public Expression.Predicate.Enum enum$(int index) {
            return this.enumList.get(index);
        }

        public List<Expression.Predicate.Enum> enumList(Predicate<Expression.Predicate.Enum> predicate) {
            return this.enumList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Expression.Predicate.VariableOperation> variableOperationList() {
            return Collections.unmodifiableList(this.variableOperationList);
        }

        public Expression.Predicate.VariableOperation variableOperation(int index) {
            return this.variableOperationList.get(index);
        }

        public List<Expression.Predicate.VariableOperation> variableOperationList(Predicate<Expression.Predicate.VariableOperation> predicate) {
            return this.variableOperationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Expression.Predicate.Period period() {
            return this.period;
        }

        public Expression.Predicate.FromNow fromNow() {
            return this.fromNow;
        }

        public Expression.Predicate.TimeRange timeRange() {
            return this.timeRange;
        }

        public Expression.Predicate.Frequency frequency() {
            return this.frequency;
        }

        public Expression.Predicate.Recency recency() {
            return this.recency;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Expression.Predicate.Argument>(this.argumentList).forEach(c -> components.add(c.core$()));
            new ArrayList<Expression.Predicate.Range>(this.rangeList).forEach(c -> components.add(c.core$()));
            new ArrayList<Expression.Predicate.SingleValue>(this.singleValueList).forEach(c -> components.add(c.core$()));
            new ArrayList<Expression.Predicate.Numeric>(this.numericList).forEach(c -> components.add(c.core$()));
            new ArrayList<Expression.Predicate.Text>(this.textList).forEach(c -> components.add(c.core$()));
            new ArrayList<Expression.Predicate.Enum>(this.enumList).forEach(c -> components.add(c.core$()));
            new ArrayList<Expression.Predicate.VariableOperation>(this.variableOperationList).forEach(c -> components.add(c.core$()));
            if (this.period != null) {
                components.add(this.period.core$());
            }
            if (this.fromNow != null) {
                components.add(this.fromNow.core$());
            }
            if (this.timeRange != null) {
                components.add(this.timeRange.core$());
            }
            if (this.frequency != null) {
                components.add(this.frequency.core$());
            }
            if (this.recency != null) {
                components.add(this.recency.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("property", new ArrayList<String>(Collections.singletonList(this.property)));
            map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
            map.put("description", this.description != null ? new ArrayList<Description>(Collections.singletonList(this.description)) : Collections.emptyList());
            map.put("argumentOperator", new ArrayList<Operator>(Collections.singletonList(this.argumentOperator)));
            map.put("modifier", new ArrayList<Modifier>(Collections.singletonList(this.modifier)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Expression$Predicate$Argument")) {
                this.argumentList.add((Expression.Predicate.Argument)node.as(Expression.Predicate.Argument.class));
            }
            if (node.is("Expression$Predicate$Range")) {
                this.rangeList.add((Expression.Predicate.Range)node.as(Expression.Predicate.Range.class));
            }
            if (node.is("Expression$Predicate$SingleValue")) {
                this.singleValueList.add((Expression.Predicate.SingleValue)node.as(Expression.Predicate.SingleValue.class));
            }
            if (node.is("Expression$Predicate$Numeric")) {
                this.numericList.add((Expression.Predicate.Numeric)node.as(Expression.Predicate.Numeric.class));
            }
            if (node.is("Expression$Predicate$Text")) {
                this.textList.add((Expression.Predicate.Text)node.as(Expression.Predicate.Text.class));
            }
            if (node.is("Expression$Predicate$Enum")) {
                this.enumList.add((Expression.Predicate.Enum)node.as(Expression.Predicate.Enum.class));
            }
            if (node.is("Expression$Predicate$VariableOperation")) {
                this.variableOperationList.add((Expression.Predicate.VariableOperation)node.as(Expression.Predicate.VariableOperation.class));
            }
            if (node.is("Expression$Predicate$Period")) {
                this.period = (Expression.Predicate.Period)node.as(Expression.Predicate.Period.class);
            }
            if (node.is("Expression$Predicate$FromNow")) {
                this.fromNow = (Expression.Predicate.FromNow)node.as(Expression.Predicate.FromNow.class);
            }
            if (node.is("Expression$Predicate$TimeRange")) {
                this.timeRange = (Expression.Predicate.TimeRange)node.as(Expression.Predicate.TimeRange.class);
            }
            if (node.is("Expression$Predicate$Frequency")) {
                this.frequency = (Expression.Predicate.Frequency)node.as(Expression.Predicate.Frequency.class);
            }
            if (node.is("Expression$Predicate$Recency")) {
                this.recency = (Expression.Predicate.Recency)node.as(Expression.Predicate.Recency.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Expression$Predicate$Argument")) {
                this.argumentList.remove(node.as(Expression.Predicate.Argument.class));
            }
            if (node.is("Expression$Predicate$Range")) {
                this.rangeList.remove(node.as(Expression.Predicate.Range.class));
            }
            if (node.is("Expression$Predicate$SingleValue")) {
                this.singleValueList.remove(node.as(Expression.Predicate.SingleValue.class));
            }
            if (node.is("Expression$Predicate$Numeric")) {
                this.numericList.remove(node.as(Expression.Predicate.Numeric.class));
            }
            if (node.is("Expression$Predicate$Text")) {
                this.textList.remove(node.as(Expression.Predicate.Text.class));
            }
            if (node.is("Expression$Predicate$Enum")) {
                this.enumList.remove(node.as(Expression.Predicate.Enum.class));
            }
            if (node.is("Expression$Predicate$VariableOperation")) {
                this.variableOperationList.remove(node.as(Expression.Predicate.VariableOperation.class));
            }
            if (node.is("Expression$Predicate$Period")) {
                this.period = null;
            }
            if (node.is("Expression$Predicate$FromNow")) {
                this.fromNow = null;
            }
            if (node.is("Expression$Predicate$TimeRange")) {
                this.timeRange = null;
            }
            if (node.is("Expression$Predicate$Frequency")) {
                this.frequency = null;
            }
            if (node.is("Expression$Predicate$Recency")) {
                this.recency = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("property")) {
                this.property = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("toString")) {
                this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = (Description)FunctionLoader.load(values, (Layer)this, Description.class).get(0);
            } else if (name.equalsIgnoreCase("argumentOperator")) {
                this.argumentOperator = (Operator)((Object)WordLoader.load(values, Operator.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("modifier")) {
                this.modifier = (Modifier)((Object)WordLoader.load(values, Modifier.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("property")) {
                this.property = (String)values.get(0);
            } else if (name.equalsIgnoreCase("toString")) {
                this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = (Description)FunctionLoader.load(values.get(0), (Layer)this, Description.class);
            } else if (name.equalsIgnoreCase("argumentOperator")) {
                this.argumentOperator = (Operator)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("modifier")) {
                this.modifier = (Modifier)((Object)values.get(0));
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public SetqlGraph graph() {
            return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
        }

        public static abstract class AbstractRecency
        extends Layer
        implements Terminal {
            protected ToString toString;
            protected int amount;
            protected Scale scale;
            protected Range range;

            public AbstractRecency(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public int amount() {
                return this.amount;
            }

            public Scale scale() {
                return this.scale;
            }

            public Range range() {
                return this.range;
            }

            public Expression.Predicate.Recency toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return (Expression.Predicate.Recency)this;
            }

            public Expression.Predicate.Recency amount(int value) {
                this.amount = value;
                return (Expression.Predicate.Recency)this;
            }

            public Expression.Predicate.Recency scale(Scale value) {
                this.scale = value;
                return (Expression.Predicate.Recency)this;
            }

            public Expression.Predicate.Recency range(Range value) {
                this.range = value;
                return (Expression.Predicate.Recency)this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                map.put("amount", new ArrayList<Integer>(Collections.singletonList(this.amount)));
                map.put("scale", new ArrayList<Scale>(Collections.singletonList(this.scale)));
                map.put("range", new ArrayList<Range>(Collections.singletonList(this.range)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)WordLoader.load(values, Scale.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("range")) {
                    this.range = (Range)((Object)WordLoader.load(values, Range.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("range")) {
                    this.range = (Range)((Object)values.get(0));
                }
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public static enum Range {
                Old,
                New;

            }
        }

        public static abstract class AbstractFrequency
        extends Layer
        implements Terminal {
            protected ToString toString;
            protected ToString description;
            protected int lowBound;
            protected int highBound;
            protected boolean relative;
            protected boolean consecutives;

            public AbstractFrequency(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public String description(Locale locale) {
                return this.description.toString(locale);
            }

            public int lowBound() {
                return this.lowBound;
            }

            public int highBound() {
                return this.highBound;
            }

            public boolean relative() {
                return this.relative;
            }

            public boolean consecutives() {
                return this.consecutives;
            }

            public Expression.Predicate.Frequency toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return (Expression.Predicate.Frequency)this;
            }

            public Expression.Predicate.Frequency description(ToString value) {
                this.description = (ToString)FunctionLoader.load((Object)this.description, (Layer)this, ToString.class);
                return (Expression.Predicate.Frequency)this;
            }

            public Expression.Predicate.Frequency lowBound(int value) {
                this.lowBound = value;
                return (Expression.Predicate.Frequency)this;
            }

            public Expression.Predicate.Frequency highBound(int value) {
                this.highBound = value;
                return (Expression.Predicate.Frequency)this;
            }

            public Expression.Predicate.Frequency relative(boolean value) {
                this.relative = value;
                return (Expression.Predicate.Frequency)this;
            }

            public Expression.Predicate.Frequency consecutives(boolean value) {
                this.consecutives = value;
                return (Expression.Predicate.Frequency)this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                map.put("description", this.description != null ? new ArrayList<ToString>(Collections.singletonList(this.description)) : Collections.emptyList());
                map.put("lowBound", new ArrayList<Integer>(Collections.singletonList(this.lowBound)));
                map.put("highBound", new ArrayList<Integer>(Collections.singletonList(this.highBound)));
                map.put("relative", new ArrayList<Boolean>(Collections.singletonList(this.relative)));
                map.put("consecutives", new ArrayList<Boolean>(Collections.singletonList(this.consecutives)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("relative")) {
                    this.relative = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("consecutives")) {
                    this.consecutives = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("relative")) {
                    this.relative = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("consecutives")) {
                    this.consecutives = (Boolean)values.get(0);
                }
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractTimeRange
        extends Expression.Predicate.Period
        implements Terminal {
            protected String from;
            protected String to;
            protected io.intino.magritte.framework.Expression<Instant> fromInstant;
            protected io.intino.magritte.framework.Expression<Instant> toInstant;

            public AbstractTimeRange(Node node) {
                super(node);
            }

            public String from() {
                return this.from;
            }

            public String to() {
                return this.to;
            }

            public Instant fromInstant() {
                return (Instant)this.fromInstant.value();
            }

            public Instant toInstant() {
                return (Instant)this.toInstant.value();
            }

            public Expression.Predicate.TimeRange from(String value) {
                this.from = value;
                return (Expression.Predicate.TimeRange)this;
            }

            public Expression.Predicate.TimeRange to(String value) {
                this.to = value;
                return (Expression.Predicate.TimeRange)this;
            }

            public Expression.Predicate.TimeRange fromInstant(io.intino.magritte.framework.Expression<Instant> value) {
                this.fromInstant = (io.intino.magritte.framework.Expression)FunctionLoader.load(value, (Layer)this, io.intino.magritte.framework.Expression.class);
                return (Expression.Predicate.TimeRange)this;
            }

            public Expression.Predicate.TimeRange toInstant(io.intino.magritte.framework.Expression<Instant> value) {
                this.toInstant = (io.intino.magritte.framework.Expression)FunctionLoader.load(value, (Layer)this, io.intino.magritte.framework.Expression.class);
                return (Expression.Predicate.TimeRange)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("from", new ArrayList<String>(Collections.singletonList(this.from)));
                map.put("to", new ArrayList<String>(Collections.singletonList(this.to)));
                map.put("fromInstant", new ArrayList<io.intino.magritte.framework.Expression<Instant>>(Collections.singletonList(this.fromInstant)));
                map.put("toInstant", new ArrayList<io.intino.magritte.framework.Expression<Instant>>(Collections.singletonList(this.toInstant)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("from")) {
                    this.from = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("fromInstant")) {
                    this.fromInstant = (io.intino.magritte.framework.Expression)FunctionLoader.load(values, (Layer)this, io.intino.magritte.framework.Expression.class).get(0);
                } else if (name.equalsIgnoreCase("toInstant")) {
                    this.toInstant = (io.intino.magritte.framework.Expression)FunctionLoader.load(values, (Layer)this, io.intino.magritte.framework.Expression.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("from")) {
                    this.from = (String)values.get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (String)values.get(0);
                } else if (name.equalsIgnoreCase("fromInstant")) {
                    this.fromInstant = (io.intino.magritte.framework.Expression)FunctionLoader.load(values.get(0), (Layer)this, io.intino.magritte.framework.Expression.class);
                } else if (name.equalsIgnoreCase("toInstant")) {
                    this.toInstant = (io.intino.magritte.framework.Expression)FunctionLoader.load(values.get(0), (Layer)this, io.intino.magritte.framework.Expression.class);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractFromNow
        extends Expression.Predicate.Period
        implements Terminal {
            protected int amount;
            protected Scale scale;

            public AbstractFromNow(Node node) {
                super(node);
            }

            public int amount() {
                return this.amount;
            }

            public Scale scale() {
                return this.scale;
            }

            public Expression.Predicate.FromNow amount(int value) {
                this.amount = value;
                return (Expression.Predicate.FromNow)this;
            }

            public Expression.Predicate.FromNow scale(Scale value) {
                this.scale = value;
                return (Expression.Predicate.FromNow)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("amount", new ArrayList<Integer>(Collections.singletonList(this.amount)));
                map.put("scale", new ArrayList<Scale>(Collections.singletonList(this.scale)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)WordLoader.load(values, Scale.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)values.get(0));
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractPeriod
        extends Layer
        implements Terminal {
            protected ToString toString;
            protected ToString description;

            public AbstractPeriod(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public String description(Locale locale) {
                return this.description.toString(locale);
            }

            public Expression.Predicate.Period toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return (Expression.Predicate.Period)this;
            }

            public Expression.Predicate.Period description(ToString value) {
                this.description = (ToString)FunctionLoader.load((Object)this.description, (Layer)this, ToString.class);
                return (Expression.Predicate.Period)this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                map.put("description", this.description != null ? new ArrayList<ToString>(Collections.singletonList(this.description)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static abstract class AbstractVariableOperation
        extends Expression.Predicate.SingleValue
        implements Terminal {
            protected List<Operator> operators = new ArrayList<Operator>();
            protected List<Expression.Predicate.VariableOperation.Comparison> comparisonList = new ArrayList<Expression.Predicate.VariableOperation.Comparison>();

            public AbstractVariableOperation(Node node) {
                super(node);
            }

            public List<Operator> operators() {
                return this.operators;
            }

            public Expression.Predicate.VariableOperation operators(List<Operator> values) {
                this.operators = values;
                return (Expression.Predicate.VariableOperation)this;
            }

            public List<Expression.Predicate.VariableOperation.Comparison> comparisonList() {
                return Collections.unmodifiableList(this.comparisonList);
            }

            public Expression.Predicate.VariableOperation.Comparison comparison(int index) {
                return this.comparisonList.get(index);
            }

            public List<Expression.Predicate.VariableOperation.Comparison> comparisonList(Predicate<Expression.Predicate.VariableOperation.Comparison> predicate) {
                return this.comparisonList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Expression.Predicate.VariableOperation.Comparison>(this.comparisonList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("operators", this.operators);
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Expression$Predicate$VariableOperation$Comparison")) {
                    this.comparisonList.add((Expression.Predicate.VariableOperation.Comparison)node.as(Expression.Predicate.VariableOperation.Comparison.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Expression$Predicate$VariableOperation$Comparison")) {
                    this.comparisonList.remove(node.as(Expression.Predicate.VariableOperation.Comparison.class));
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("operators")) {
                    this.operators = WordLoader.load(values, Operator.class, (Layer)this);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("operators")) {
                    this.operators = new ArrayList(values);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public static abstract class AbstractComparison
            extends Layer
            implements Terminal {
                protected String variable;
                protected String comparator;
                protected String value;

                public AbstractComparison(Node node) {
                    super(node);
                }

                public String variable() {
                    return this.variable;
                }

                public String comparator() {
                    return this.comparator;
                }

                public String value() {
                    return this.value;
                }

                public Expression.Predicate.VariableOperation.Comparison variable(String value) {
                    this.variable = value;
                    return (Expression.Predicate.VariableOperation.Comparison)this;
                }

                public Expression.Predicate.VariableOperation.Comparison comparator(String value) {
                    this.comparator = value;
                    return (Expression.Predicate.VariableOperation.Comparison)this;
                }

                public Expression.Predicate.VariableOperation.Comparison value(String value) {
                    this.value = value;
                    return (Expression.Predicate.VariableOperation.Comparison)this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("variable", new ArrayList<String>(Collections.singletonList(this.variable)));
                    map.put("comparator", new ArrayList<String>(Collections.singletonList(this.comparator)));
                    map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("variable")) {
                        this.variable = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("comparator")) {
                        this.comparator = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("value")) {
                        this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("variable")) {
                        this.variable = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("comparator")) {
                        this.comparator = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("value")) {
                        this.value = (String)values.get(0);
                    }
                }

                public SetqlGraph graph() {
                    return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
                }
            }

            public class Clear {
                public void comparison(Predicate<Expression.Predicate.VariableOperation.Comparison> filter) {
                    new ArrayList<Expression.Predicate.VariableOperation.Comparison>(AbstractVariableOperation.this.comparisonList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends AbstractArgument.Create {
                public Create(String name) {
                    super(name);
                }

                public Expression.Predicate.VariableOperation.Comparison comparison(String variable, String comparator, String value) {
                    Expression.Predicate.VariableOperation.Comparison newElement = (Expression.Predicate.VariableOperation.Comparison)AbstractVariableOperation.this.core$().graph().concept(Expression.Predicate.VariableOperation.Comparison.class).createNode(this.name, AbstractVariableOperation.this.core$()).as(Expression.Predicate.VariableOperation.Comparison.class);
                    newElement.core$().set((Layer)newElement, "variable", Collections.singletonList(variable));
                    newElement.core$().set((Layer)newElement, "comparator", Collections.singletonList(comparator));
                    newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                    return newElement;
                }
            }
        }

        public static abstract class AbstractEnum
        extends Expression.Predicate.SingleValue
        implements Terminal {
            protected boolean isComposedCategory;

            public AbstractEnum(Node node) {
                super(node);
            }

            public boolean isComposedCategory() {
                return this.isComposedCategory;
            }

            public Expression.Predicate.Enum isComposedCategory(boolean value) {
                this.isComposedCategory = value;
                return (Expression.Predicate.Enum)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("isComposedCategory", new ArrayList<Boolean>(Collections.singletonList(this.isComposedCategory)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("isComposedCategory")) {
                    this.isComposedCategory = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("isComposedCategory")) {
                    this.isComposedCategory = (Boolean)values.get(0);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractText
        extends Expression.Predicate.SingleValue
        implements Terminal {
            public AbstractText(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractNumeric
        extends Expression.Predicate.SingleValue
        implements Terminal {
            protected String unit;
            protected int decimals;

            public AbstractNumeric(Node node) {
                super(node);
            }

            public String unit() {
                return this.unit;
            }

            public int decimals() {
                return this.decimals;
            }

            public Expression.Predicate.Numeric unit(String value) {
                this.unit = value;
                return (Expression.Predicate.Numeric)this;
            }

            public Expression.Predicate.Numeric decimals(int value) {
                this.decimals = value;
                return (Expression.Predicate.Numeric)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("unit", new ArrayList<String>(Collections.singletonList(this.unit)));
                map.put("decimals", new ArrayList<Integer>(Collections.singletonList(this.decimals)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("unit")) {
                    this.unit = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("decimals")) {
                    this.decimals = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("unit")) {
                    this.unit = (String)values.get(0);
                } else if (name.equalsIgnoreCase("decimals")) {
                    this.decimals = (Integer)values.get(0);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractSingleValue
        extends Expression.Predicate.Argument
        implements Terminal {
            protected String value;

            public AbstractSingleValue(Node node) {
                super(node);
            }

            public String value() {
                return this.value;
            }

            public Expression.Predicate.SingleValue value(String value) {
                this.value = value;
                return (Expression.Predicate.SingleValue)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractRange
        extends Expression.Predicate.Argument
        implements Terminal {
            protected double lowBound;
            protected double highBound;
            protected String unit;
            protected int decimals;
            protected boolean closedLowBound;
            protected boolean closedHighBound;

            public AbstractRange(Node node) {
                super(node);
            }

            public double lowBound() {
                return this.lowBound;
            }

            public double highBound() {
                return this.highBound;
            }

            public String unit() {
                return this.unit;
            }

            public int decimals() {
                return this.decimals;
            }

            public boolean closedLowBound() {
                return this.closedLowBound;
            }

            public boolean closedHighBound() {
                return this.closedHighBound;
            }

            public Expression.Predicate.Range lowBound(double value) {
                this.lowBound = value;
                return (Expression.Predicate.Range)this;
            }

            public Expression.Predicate.Range highBound(double value) {
                this.highBound = value;
                return (Expression.Predicate.Range)this;
            }

            public Expression.Predicate.Range unit(String value) {
                this.unit = value;
                return (Expression.Predicate.Range)this;
            }

            public Expression.Predicate.Range decimals(int value) {
                this.decimals = value;
                return (Expression.Predicate.Range)this;
            }

            public Expression.Predicate.Range closedLowBound(boolean value) {
                this.closedLowBound = value;
                return (Expression.Predicate.Range)this;
            }

            public Expression.Predicate.Range closedHighBound(boolean value) {
                this.closedHighBound = value;
                return (Expression.Predicate.Range)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("lowBound", new ArrayList<Double>(Collections.singletonList(this.lowBound)));
                map.put("highBound", new ArrayList<Double>(Collections.singletonList(this.highBound)));
                map.put("unit", new ArrayList<String>(Collections.singletonList(this.unit)));
                map.put("decimals", new ArrayList<Integer>(Collections.singletonList(this.decimals)));
                map.put("closedLowBound", new ArrayList<Boolean>(Collections.singletonList(this.closedLowBound)));
                map.put("closedHighBound", new ArrayList<Boolean>(Collections.singletonList(this.closedHighBound)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("unit")) {
                    this.unit = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("decimals")) {
                    this.decimals = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("closedLowBound")) {
                    this.closedLowBound = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("closedHighBound")) {
                    this.closedHighBound = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("unit")) {
                    this.unit = (String)values.get(0);
                } else if (name.equalsIgnoreCase("decimals")) {
                    this.decimals = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("closedLowBound")) {
                    this.closedLowBound = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("closedHighBound")) {
                    this.closedHighBound = (Boolean)values.get(0);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class AbstractArgument
        extends Layer
        implements Terminal {
            protected ToString description;
            protected ToString toString;

            public AbstractArgument(Node node) {
                super(node);
            }

            public String description(Locale locale) {
                return this.description.toString(locale);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public Expression.Predicate.Argument description(ToString value) {
                this.description = (ToString)FunctionLoader.load((Object)this.description, (Layer)this, ToString.class);
                return (Expression.Predicate.Argument)this;
            }

            public Expression.Predicate.Argument toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return (Expression.Predicate.Argument)this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("description", this.description != null ? new ArrayList<ToString>(Collections.singletonList(this.description)) : Collections.emptyList());
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Clear {
            public void range(Predicate<Expression.Predicate.Range> filter) {
                new ArrayList<Expression.Predicate.Range>(AbstractPredicate.this.rangeList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void numeric(Predicate<Expression.Predicate.Numeric> filter) {
                new ArrayList<Expression.Predicate.Numeric>(AbstractPredicate.this.numericList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void text(Predicate<Expression.Predicate.Text> filter) {
                new ArrayList<Expression.Predicate.Text>(AbstractPredicate.this.textList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void enum$(Predicate<Expression.Predicate.Enum> filter) {
                new ArrayList<Expression.Predicate.Enum>(AbstractPredicate.this.enumList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void variableOperation(Predicate<Expression.Predicate.VariableOperation> filter) {
                new ArrayList<Expression.Predicate.VariableOperation>(AbstractPredicate.this.variableOperationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends AbstractOperand.Create {
            public Create(String name) {
                super(name);
            }

            public Expression.Predicate.Range range(double lowBound, double highBound) {
                Expression.Predicate.Range newElement = (Expression.Predicate.Range)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.Range.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.Range.class);
                newElement.core$().set((Layer)newElement, "lowBound", Collections.singletonList(lowBound));
                newElement.core$().set((Layer)newElement, "highBound", Collections.singletonList(highBound));
                return newElement;
            }

            public Expression.Predicate.Numeric numeric(String value) {
                Expression.Predicate.Numeric newElement = (Expression.Predicate.Numeric)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.Numeric.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.Numeric.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }

            public Expression.Predicate.Text text(String value) {
                Expression.Predicate.Text newElement = (Expression.Predicate.Text)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.Text.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.Text.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }

            public Expression.Predicate.Enum enum$(String value) {
                Expression.Predicate.Enum newElement = (Expression.Predicate.Enum)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.Enum.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.Enum.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }

            public Expression.Predicate.VariableOperation variableOperation() {
                Expression.Predicate.VariableOperation newElement = (Expression.Predicate.VariableOperation)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.VariableOperation.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.VariableOperation.class);
                return newElement;
            }

            public Expression.Predicate.FromNow fromNow(int amount, Scale scale) {
                Expression.Predicate.FromNow newElement = (Expression.Predicate.FromNow)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.FromNow.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.FromNow.class);
                newElement.core$().set((Layer)newElement, "amount", Collections.singletonList(amount));
                newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
                return newElement;
            }

            public Expression.Predicate.TimeRange timeRange(String from, String to) {
                Expression.Predicate.TimeRange newElement = (Expression.Predicate.TimeRange)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.TimeRange.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.TimeRange.class);
                newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
                newElement.core$().set((Layer)newElement, "to", Collections.singletonList(to));
                return newElement;
            }

            public Expression.Predicate.Frequency frequency(int lowBound, int highBound) {
                Expression.Predicate.Frequency newElement = (Expression.Predicate.Frequency)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.Frequency.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.Frequency.class);
                newElement.core$().set((Layer)newElement, "lowBound", Collections.singletonList(lowBound));
                newElement.core$().set((Layer)newElement, "highBound", Collections.singletonList(highBound));
                return newElement;
            }

            public Expression.Predicate.Recency recency(int amount, Scale scale, AbstractRecency.Range range) {
                Expression.Predicate.Recency newElement = (Expression.Predicate.Recency)AbstractPredicate.this.core$().graph().concept(Expression.Predicate.Recency.class).createNode(this.name, AbstractPredicate.this.core$()).as(Expression.Predicate.Recency.class);
                newElement.core$().set((Layer)newElement, "amount", Collections.singletonList(amount));
                newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
                newElement.core$().set((Layer)newElement, "range", Collections.singletonList(range));
                return newElement;
            }
        }

        public static enum Modifier {
            All,
            Commons,
            Uncommons;

        }
    }

    public static abstract class AbstractInnerExpression
    extends Expression.Operand
    implements Terminal {
        protected Expression expression;

        public AbstractInnerExpression(Node node) {
            super(node);
        }

        public Expression expression() {
            return this.expression;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.expression != null) {
                components.add(this.expression.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Expression")) {
                this.expression = (Expression)node.as(Expression.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Expression")) {
                this.expression = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public SetqlGraph graph() {
            return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
        }

        public class Create
        extends AbstractOperand.Create {
            public Create(String name) {
                super(name);
            }

            public Expression expression(String raw) {
                Expression newElement = (Expression)AbstractInnerExpression.this.core$().graph().concept(Expression.class).createNode(this.name, AbstractInnerExpression.this.core$()).as(Expression.class);
                newElement.core$().set((Layer)newElement, "raw", Collections.singletonList(raw));
                return newElement;
            }
        }
    }

    public static abstract class AbstractOperand
    extends Layer
    implements Terminal {
        protected int line;
        protected Operator operator;

        public AbstractOperand(Node node) {
            super(node);
        }

        public int line() {
            return this.line;
        }

        public Operator operator() {
            return this.operator;
        }

        public Expression.Operand line(int value) {
            this.line = value;
            return (Expression.Operand)this;
        }

        public Expression.Operand operator(Operator value) {
            this.operator = value;
            return (Expression.Operand)this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("line", new ArrayList<Integer>(Collections.singletonList(this.line)));
            map.put("operator", new ArrayList<Operator>(Collections.singletonList(this.operator)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("line")) {
                this.line = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("operator")) {
                this.operator = (Operator)((Object)WordLoader.load(values, Operator.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("line")) {
                this.line = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("operator")) {
                this.operator = (Operator)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public SetqlGraph graph() {
            return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void innerExpression(Predicate<Expression.InnerExpression> filter) {
            new ArrayList<Expression.InnerExpression>(AbstractExpression.this.innerExpressionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void predicate(Predicate<Expression.Predicate> filter) {
            new ArrayList<Expression.Predicate>(AbstractExpression.this.predicateList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Expression.InnerExpression innerExpression(int line) {
            Expression.InnerExpression newElement = (Expression.InnerExpression)AbstractExpression.this.core$().graph().concept(Expression.InnerExpression.class).createNode(this.name, AbstractExpression.this.core$()).as(Expression.InnerExpression.class);
            newElement.core$().set((Layer)newElement, "line", Collections.singletonList(line));
            return newElement;
        }

        public Expression.Predicate predicate(int line, String property) {
            Expression.Predicate newElement = (Expression.Predicate)AbstractExpression.this.core$().graph().concept(Expression.Predicate.class).createNode(this.name, AbstractExpression.this.core$()).as(Expression.Predicate.class);
            newElement.core$().set((Layer)newElement, "line", Collections.singletonList(line));
            newElement.core$().set((Layer)newElement, "property", Collections.singletonList(property));
            return newElement;
        }
    }
}

