/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql.exceptions;

import io.intino.sezzet.setql.exceptions.SetqlError;
import io.intino.sezzet.setql.exceptions.SetqlException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class SyntaxException
extends SetqlException {
    public SyntaxException add(SyntaxError error) {
        this.errors.add(error);
        return this;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        for (SetqlError error : this.errors) {
            builder.append(error.message()).append("\n");
        }
        return builder.toString();
    }

    public static class SyntaxError
    extends SetqlError {
        private final ResourceBundle errorMessages;
        private final String currentToken;
        private final String expectedTokens;

        public SyntaxError(ResourceBundle errorMessages, int line, int column, String currentToken, String expectedTokens) {
            super(line, column, "Syntax error" + (String)(!expectedTokens.isEmpty() ? ". Expected " + expectedTokens : "") + " on line " + line + " and column " + column);
            this.errorMessages = errorMessages;
            this.currentToken = currentToken.equalsIgnoreCase("<EOF>") ? this.message("ending", new Object[0]) : currentToken;
            this.expectedTokens = expectedTokens;
        }

        public String lineMessage() {
            return this.expectedTokens.isEmpty() ? this.message("syntax.error", this.currentToken, this.column) : this.message("syntax.error.with.expected", this.currentToken, this.expectedTokens, this.column);
        }

        private String message(String key, Object ... parameters) {
            return MessageFormat.format(new String(this.errorMessages.getString(key).getBytes(), StandardCharsets.UTF_8), parameters);
        }
    }
}

