/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.model.graph.Category;
import io.intino.sezzet.model.graph.Feature;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class SetqlSugarFree {
    private SezzetGraph sezzet;

    SetqlSugarFree(SezzetGraph sezzet) {
        this.sezzet = sezzet;
    }

    public void free(SetqlGraph graph) {
        this.free(graph.expression());
    }

    private void free(Expression expression) {
        for (Expression.InnerExpression e : expression.innerExpressionList()) {
            this.free(e.expression());
        }
        for (Expression.Predicate predicate : new ArrayList<Expression.Predicate>(expression.predicateList())) {
            this.free(predicate);
        }
    }

    private void free(Expression.Predicate predicate) {
        Feature feature = this.sezzet.find(predicate.property());
        ArrayList<Expression.Predicate.Enum> list = new ArrayList<Expression.Predicate.Enum>(predicate.enumList());
        for (Expression.Predicate.Enum argument : list) {
            if (!argument.isComposedCategory()) continue;
            this.freeComposedValue(argument, this.categoryFrom(feature, argument));
        }
        for (Expression.Predicate.Enum argument : list) {
            if (!argument.isComposedCategory()) continue;
            argument.delete$();
        }
        if (!predicate.modifier().equals((Object)AbstractExpression.AbstractPredicate.Modifier.All)) {
            this.freeModifier(predicate);
        }
        if (predicate.recency() != null) {
            this.freeRecency(predicate);
        }
    }

    private void freeComposedValue(Expression.Predicate.Argument argument, Category value) {
        List categories = this.sezzet.leafCategoriesOf(Collections.singletonList(value));
        Expression.Predicate predicate = (Expression.Predicate)argument.core$().ownerAs(Expression.Predicate.class);
        for (Category c : categories) {
            predicate.create().enum$(c.label());
        }
    }

    private void freeModifier(Expression.Predicate predicate) {
        AbstractExpression.AbstractPredicate.Modifier modifier = predicate.modifier();
        if (modifier.equals((Object)AbstractExpression.AbstractPredicate.Modifier.Commons)) {
            predicate.argumentOperator(Operator.AND);
        } else if (modifier.equals((Object)AbstractExpression.AbstractPredicate.Modifier.Uncommons)) {
            predicate.argumentOperator(Operator.NAND);
        }
        predicate.modifier(AbstractExpression.AbstractPredicate.Modifier.All);
    }

    private void freeRecency(Expression.Predicate predicate) {
        this.substitute((Expression)predicate.core$().ownerAs(Expression.class), predicate, this.createInnerExpression(predicate, (Expression)predicate.core$().ownerAs(Expression.class)));
    }

    private void substitute(Expression expression, Expression.Operand predicate, Expression.Operand newExpression) {
        expression.replace(predicate, newExpression);
    }

    private Expression.InnerExpression createInnerExpression(Expression.Predicate predicate, Expression expression) {
        Expression.Predicate.Recency recency = predicate.recency();
        Expression.InnerExpression innerExpression = expression.create().innerExpression(predicate.line());
        Expression wrappedExpression = innerExpression.create().expression("");
        Expression.Predicate p1 = wrappedExpression.create().predicate(predicate.line(), predicate.property());
        Expression.Predicate p2 = wrappedExpression.create().predicate(predicate.line(), predicate.property());
        this.copyArguments(predicate, p1, p2);
        Scale scale = Scale.valueOf(this.sezzet.storeScale().scale().name());
        if (predicate.period().i$(Expression.Predicate.FromNow.class)) {
            Expression.Predicate.FromNow fromNow = (Expression.Predicate.FromNow)predicate.period().a$(Expression.Predicate.FromNow.class);
            p1.create().timeRange(scale.label(this.bound(fromNow.amount() - 1, scale)), scale.label(scale.minus(Instant.now())));
            if (recency.range().equals((Object)AbstractExpression.AbstractPredicate.AbstractRecency.Range.Old)) {
                p2.create().fromNow(recency.amount(), scale);
            } else {
                p2.create().timeRange(scale.label(this.bound(recency.amount(), scale)), scale.label(this.bound(1, scale)));
            }
        } else {
            Expression.Predicate.TimeRange timeRange = (Expression.Predicate.TimeRange)predicate.period().a$(Expression.Predicate.TimeRange.class);
            p1.create().timeRange(timeRange.from(), timeRange.to());
            if (recency.range().equals((Object)AbstractExpression.AbstractPredicate.AbstractRecency.Range.Old)) {
                p2.create().timeRange(scale.label(this.bound(recency.amount(), scale, timeRange.toInstant())), timeRange.to());
            } else {
                p2.create().timeRange(timeRange.from(), scale.label(this.bound(recency.amount(), scale, timeRange.toInstant())));
            }
        }
        p1.operator(predicate.operator());
        p2.operator(Operator.DIFF);
        return innerExpression;
    }

    private Instant bound(int amount, Scale scale) {
        Instant now = Instant.now();
        for (int i = 0; i <= amount; ++i) {
            now = scale.minus(now);
        }
        return now;
    }

    private Instant bound(int amount, Scale scale, Instant reference) {
        Instant instant = reference;
        for (int i = 0; i <= amount; ++i) {
            instant = scale.minus(instant);
        }
        return instant;
    }

    private void copyArguments(Expression.Predicate predicate, Expression.Predicate p1, Expression.Predicate p2) {
        for (Expression.Predicate.Argument argument : predicate.argumentList()) {
            this.copyArgument(argument, Arrays.asList(p1, p2));
        }
    }

    private void copyArgument(Expression.Predicate.Argument argument, List<Expression.Predicate> destinations) {
        if (argument.i$(Expression.Predicate.Numeric.class)) {
            destinations.forEach(d -> d.create().numeric(((Expression.Predicate.Numeric)argument.a$(Expression.Predicate.Numeric.class)).value()));
        } else if (argument.i$(Expression.Predicate.Text.class)) {
            destinations.forEach(d -> d.create().text(((Expression.Predicate.Text)argument.a$(Expression.Predicate.Text.class)).value()));
        } else if (argument.i$(Expression.Predicate.Enum.class)) {
            destinations.forEach(d -> d.create().enum$(((Expression.Predicate.Enum)argument.a$(Expression.Predicate.Enum.class)).value()));
        } else if (argument.i$(Expression.Predicate.Range.class)) {
            destinations.forEach(d -> d.create().range(((Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class)).lowBound(), ((Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class)).highBound()));
        }
    }

    private Category categoryFrom(Feature feature, Expression.Predicate.Enum argument) {
        return this.sezzet.compositeCategoriesOf(feature).stream().filter(v -> v.label().equalsIgnoreCase(argument.value())).findFirst().orElse(null);
    }
}

