/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.setql.SetqlGrammar;
import io.intino.sezzet.setql.SetqlGrammarBaseListener;
import io.intino.sezzet.setql.exceptions.SetqlError;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class SetqlModelGenerator
extends SetqlGrammarBaseListener {
    private final SetqlGraph graph;
    private List<SetqlError> errors = new ArrayList<SetqlError>();
    private Expression expression;
    private Stack<Expression> criterionStack = new Stack();
    private Expression.Predicate currentPredicate;

    SetqlModelGenerator(SetqlGraph graph) {
        this.graph = graph;
    }

    List<SetqlError> errors() {
        return this.errors;
    }

    Expression expression() {
        return this.expression;
    }

    @Override
    public void enterCriterion(SetqlGrammar.CriterionContext ctx) {
        if (this.criterionStack.isEmpty()) {
            this.expression = this.graph.create().expression(ctx.getText());
            this.criterionStack.push(this.expression);
        } else {
            Expression.InnerExpression innerExpression = this.criterionStack.peek().create().innerExpression(ctx.STAR().getSymbol().getLine());
            this.addOperator(ctx.parent, innerExpression);
            this.criterionStack.push(innerExpression.create().expression(ctx.getText()));
        }
    }

    private void addOperator(RuleContext parent, Expression.InnerExpression expression) {
        expression.operator(this.operatorFrom(parent));
    }

    @Override
    public void exitCriterion(SetqlGrammar.CriterionContext ctx) {
        this.criterionStack.pop();
    }

    @Override
    public void enterPredicate(SetqlGrammar.PredicateContext ctx) {
        Expression expression = this.criterionStack.peek();
        String feature = ctx.restriction().feature().getText();
        this.currentPredicate = expression.create().predicate(ctx.getStart().getLine(), feature);
        if (ctx.parent instanceof SetqlGrammar.InlinePredicateContext) {
            this.addOperator(ctx.parent);
        }
        this.enterArgument(ctx, this.currentPredicate);
    }

    private void addOperator(RuleContext parent) {
        this.currentPredicate.operator(this.operatorFrom(parent));
    }

    private void enterArgument(SetqlGrammar.PredicateContext ctx, Expression.Predicate predicate) {
        for (SetqlGrammar.ArgumentContext arg : ctx.restriction().argument()) {
            if (arg.range() != null) {
                this.processRange(predicate, arg);
                continue;
            }
            if (arg.comparator() != null) {
                this.processRelativeRange(predicate, arg);
                continue;
            }
            if (arg.STRING() != null) {
                String text = arg.STRING().getText();
                predicate.create().text(text.substring(1, text.length() - 1));
                continue;
            }
            if (arg.number() != null) {
                predicate.create().numeric(arg.number().getText());
                continue;
            }
            if (arg.enumerate() != null && !arg.enumerate().isEmpty()) {
                predicate.create().enum$(String.join((CharSequence)" ", this.textOf(arg.enumerate())));
                continue;
            }
            if (arg.expression() == null) continue;
            this.processVariableOperation(predicate, arg);
        }
    }

    private String textOf(SetqlGrammar.EnumerateContext arg) {
        StringBuilder enumerate = new StringBuilder();
        boolean lastWasDot = false;
        for (ParseTree child : arg.children) {
            if (child.getText().equalsIgnoreCase(".")) {
                enumerate.append(child.getText());
                lastWasDot = true;
                continue;
            }
            enumerate.append(lastWasDot || enumerate.length() == 0 ? "" : " ").append(child.getText());
            lastWasDot = false;
        }
        return enumerate.toString();
    }

    private void processVariableOperation(Expression.Predicate predicate, SetqlGrammar.ArgumentContext arg) {
        SetqlGrammar.ComputeContext expression = arg.expression().compute();
        Expression.Predicate.VariableOperation operation = predicate.create().variableOperation();
        if (expression instanceof SetqlGrammar.ComparatorExpressionContext) {
            this.parseComparision((SetqlGrammar.ComparatorExpressionContext)expression, operation);
        } else if (expression instanceof SetqlGrammar.BinaryExpressionContext) {
            SetqlGrammar.BinaryExpressionContext binary = (SetqlGrammar.BinaryExpressionContext)expression;
            operation.operators().add(Operator.fromText(binary.op.getText()));
            this.parseBinary(binary, operation);
        }
    }

    private void parseComparision(SetqlGrammar.ComparatorExpressionContext comparision, Expression.Predicate.VariableOperation operation) {
        if (comparision.left instanceof SetqlGrammar.IdentifierExpressionContext || comparision.right instanceof SetqlGrammar.IdentifierExpressionContext) {
            operation.create().comparison(this.variableFrom(comparision), comparision.op.getText(), this.number(comparision));
        }
    }

    private void parseBinary(SetqlGrammar.BinaryExpressionContext binary, Expression.Predicate.VariableOperation operation) {
        this.parseComparision((SetqlGrammar.ComparatorExpressionContext)binary.left, operation);
        this.parseComparision((SetqlGrammar.ComparatorExpressionContext)binary.right, operation);
    }

    private String variableFrom(SetqlGrammar.ComparatorExpressionContext comparision) {
        return comparision.left instanceof SetqlGrammar.IdentifierExpressionContext ? ((SetqlGrammar.IdentifierExpressionContext)comparision.left).IDENTIFIER().getText() : ((SetqlGrammar.IdentifierExpressionContext)comparision.right).IDENTIFIER().getText();
    }

    private String number(SetqlGrammar.ComparatorExpressionContext comparision) {
        return comparision.left instanceof SetqlGrammar.DecimalExpressionContext ? ((SetqlGrammar.DecimalExpressionContext)comparision.left).number().getText() : ((SetqlGrammar.DecimalExpressionContext)comparision.right).number().getText();
    }

    private void processRelativeRange(Expression.Predicate predicate, SetqlGrammar.ArgumentContext arg) {
        String comparator = arg.comparator().getText();
        Expression.Predicate.Range range = predicate.create().range(this.rangeLowBound(arg.number().getText(), comparator), this.rangeHighBound(arg.number().getText(), comparator));
        if (!comparator.contains("=")) {
            if (comparator.contains("<")) {
                range.closedHighBound(false);
            } else {
                range.closedLowBound(false);
            }
        }
    }

    private double rangeLowBound(String number, String comparator) {
        return comparator.contains("<") ? Double.MIN_VALUE : Double.parseDouble(number);
    }

    private double rangeHighBound(String number, String comparator) {
        return comparator.contains(">") ? Double.MAX_VALUE : Double.parseDouble(number);
    }

    private void processRange(Expression.Predicate predicate, SetqlGrammar.ArgumentContext arg) {
        predicate.create().range(Double.parseDouble(arg.range().rangeValue(0).getText()), Double.parseDouble(arg.range().rangeValue(1).getText()));
    }

    @Override
    public void enterPeriod(SetqlGrammar.PeriodContext ctx) {
        if (ctx.scale() != null) {
            this.currentPredicate.create().fromNow(Integer.parseInt(ctx.NATURAL_VALUE().getText()), this.scale(ctx.scale()));
        } else {
            this.currentPredicate.create().timeRange(ctx.dateRange().dateValue().get(0).getText(), ctx.dateRange().dateValue().get(1).getText());
        }
    }

    @Override
    public void enterModifier(SetqlGrammar.ModifierContext ctx) {
        if (ctx.COMMONS() != null) {
            this.currentPredicate.modifier(AbstractExpression.AbstractPredicate.Modifier.Commons);
        } else if (ctx.UNCOMMONS() != null) {
            this.currentPredicate.modifier(AbstractExpression.AbstractPredicate.Modifier.Uncommons);
        }
    }

    @Override
    public void enterFrequency(SetqlGrammar.FrequencyContext ctx) {
        Expression.Predicate.Frequency frequency;
        if (ctx.range() != null) {
            frequency = this.currentPredicate.create().frequency(Integer.parseInt(ctx.range() != null ? ctx.range().rangeValue(0).getText() : ctx.NATURAL_VALUE().getText()), ctx.range() != null ? Integer.parseInt(ctx.range().rangeValue(1).getText()) : Integer.MAX_VALUE);
        } else {
            double lowBound = this.lowBound(ctx.NATURAL_VALUE().getText(), ctx.comparator().getText());
            frequency = this.currentPredicate.create().frequency(lowBound < 0.0 ? 0 : (int)lowBound, (int)this.highBound(ctx.NATURAL_VALUE().getText(), ctx.comparator().getText()));
        }
        if (ctx.PERCENTAGE() != null) {
            frequency.relative(true);
        }
        if (ctx.CONSECUTIVE() != null) {
            frequency.consecutives(true);
        }
    }

    private double lowBound(String number, String comparator) {
        if (comparator.equals("=")) {
            return Double.parseDouble(number);
        }
        if (comparator.contains("<")) {
            return Double.MIN_VALUE;
        }
        return comparator.contains("=") ? Double.parseDouble(number) : Double.parseDouble(number) + 1.0;
    }

    private double highBound(String number, String comparator) {
        if (comparator.equals("=")) {
            return Double.parseDouble(number);
        }
        if (comparator.contains(">")) {
            return Double.MAX_VALUE;
        }
        return comparator.contains("=") ? Double.parseDouble(number) : Double.parseDouble(number) - 1.0;
    }

    private Operator operatorFrom(RuleContext parent) {
        if (parent.getParent().getParent() instanceof SetqlGrammar.OperationContext) {
            return Operator.fromText(((SetqlGrammar.OperationContext)parent.getParent().getParent()).operator().getText());
        }
        return Operator.OR;
    }

    @Override
    public void enterRecency(SetqlGrammar.RecencyContext ctx) {
        this.currentPredicate.create().recency(Integer.parseInt(ctx.NATURAL_VALUE().getText()), this.scale(ctx.scale()), ctx.NEW() != null ? AbstractExpression.AbstractPredicate.AbstractRecency.Range.New : AbstractExpression.AbstractPredicate.AbstractRecency.Range.Old);
    }

    private Scale scale(SetqlGrammar.ScaleContext ctx) {
        if (ctx.DAY() != null) {
            return Scale.Day;
        }
        if (ctx.MONTH() != null) {
            return Scale.Month;
        }
        if (ctx.YEAR() != null) {
            return Scale.Year;
        }
        return Scale.Hour;
    }
}

