/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.magritte.framework.utils.UTF8Control;
import io.intino.sezzet.model.graph.Category;
import io.intino.sezzet.model.graph.Feature;
import io.intino.sezzet.model.graph.Range;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.exceptions.SemanticException;
import io.intino.sezzet.setql.exceptions.SetqlError;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SetqlChecker {
    private final ResourceBundle messages;
    private List<SetqlError> errors = new ArrayList<SetqlError>();
    private SezzetGraph sezzetGraph;

    public SetqlChecker(SezzetGraph graph, Locale locale) {
        this.sezzetGraph = graph;
        this.messages = ResourceBundle.getBundle("messages", locale, (ResourceBundle.Control)new UTF8Control());
    }

    public void check(SetqlGraph graph) throws SemanticException {
        this.check(graph.expression());
        if (!this.errors.isEmpty()) {
            throw new SemanticException().addAll(this.errors);
        }
    }

    private void check(Expression expression) {
        for (Expression.InnerExpression e : expression.innerExpressionList()) {
            this.check(e.expression());
        }
        for (Expression.Predicate predicate : expression.predicateList()) {
            this.check(predicate);
        }
    }

    private void check(Expression.Predicate predicate) {
        Feature feature = this.sezzetGraph.find(predicate.property());
        if (feature == null) {
            this.errors.add(new SemanticException.SemanticError(predicate.line(), 1, this.message("feature.not.found", predicate.property())));
            return;
        }
        if (feature.isSingleton()) {
            if (!predicate.argumentList().isEmpty()) {
                this.errors.add(new SemanticException.SemanticError(predicate.line(), 1, this.message("values.not.accepted", predicate.property())));
            }
        } else {
            if (!feature.isSingleton() && predicate.argumentList().isEmpty()) {
                this.errors.add(new SemanticException.SemanticError(predicate.line(), 1, this.message("values.required", predicate.property())));
            }
            for (Expression.Predicate.Argument argument : predicate.argumentList()) {
                this.check(argument, feature, predicate.line());
            }
        }
        this.check(predicate.period(), feature, predicate.line());
        this.check(predicate.frequency(), feature, predicate.line());
        this.check(predicate.recency(), predicate.period(), feature, predicate.line());
    }

    private void check(Expression.Predicate.Argument argument, Feature feature, int line) {
        if (!argument.i$(Expression.Predicate.VariableOperation.class)) {
            if (feature.isEnumerate()) {
                this.checkEnumerate(argument, feature, line);
            } else if (feature.isNumeric()) {
                if (feature.asNumeric().unit() != null) {
                    if (argument instanceof Expression.Predicate.Numeric) {
                        ((Expression.Predicate.Numeric)argument).unit(feature.asNumeric().unit()).decimals(feature.asNumeric().range().decimals());
                    } else if (argument instanceof Expression.Predicate.Range) {
                        ((Expression.Predicate.Range)argument).unit(feature.asNumeric().unit()).decimals(feature.asNumeric().range().decimals());
                    }
                }
                if (!argument.i$(Expression.Predicate.Numeric.class) && !argument.i$(Expression.Predicate.Range.class)) {
                    this.errors.add(new SemanticException.SemanticError(line, 1, this.message("numeric.values.required", feature.label())));
                } else {
                    Feature.Numeric numeric = feature.asNumeric();
                    if (argument.i$(Expression.Predicate.Range.class)) {
                        Expression.Predicate.Range range = (Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class);
                        if (range.lowBound() == Double.MIN_VALUE) {
                            range.lowBound(numeric.range().from());
                        }
                        if (range.highBound() == Double.MAX_VALUE) {
                            range.highBound(numeric.range().to());
                        }
                        this.correctDoubleRange(range, numeric);
                        if (((Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class)).lowBound() < numeric.range().from() || ((Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class)).highBound() > numeric.range().to()) {
                            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("numeric.range.value.out.of.bound", numeric.range().from(), numeric.range().to())));
                        }
                    }
                }
            } else if (feature.isText() && !argument.i$(Expression.Predicate.Text.class)) {
                this.errors.add(new SemanticException.SemanticError(line, 1, this.message("text.values.required", feature.label())));
            }
        }
    }

    private void correctDoubleRange(Expression.Predicate.Range range, Feature.Numeric numeric) {
        if (!range.closedHighBound()) {
            range.highBound(range.highBound() - this.findStepValue(numeric.range(), range.highBound()));
        }
        if (!range.closedLowBound()) {
            range.lowBound(range.lowBound() + this.findStepValue(numeric.range(), range.lowBound()));
        }
    }

    private Double findStepValue(Range range, double value) {
        if (range.stepList().isEmpty() && range.from() >= value && range.to() <= value) {
            return range.stepSize();
        }
        return range.stepList().stream().filter(step -> step.from() <= value && step.to() >= value).findFirst().map(Range.Step::value).orElse(1.0);
    }

    private void variablesIn(String value) {
    }

    private void checkEnumerate(Expression.Predicate.Argument argument, Feature feature, int line) {
        Category category = this.checkAsLeaf(argument, feature, line);
        if (category == null) {
            category = this.checkAsComposite(argument, feature, line);
        }
        if (category == null) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("category.not.found", ((Expression.Predicate.SingleValue)argument.a$(Expression.Predicate.SingleValue.class)).value())));
        } else if (!this.isAnonymous(category)) {
            ((Expression.Predicate.SingleValue)argument.a$(Expression.Predicate.SingleValue.class)).value(category.name$());
        }
    }

    private boolean isAnonymous(Category category) {
        return category.name$().matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    }

    private Category checkAsComposite(Expression.Predicate.Argument argument, Feature feature, int line) {
        List compositeCategories = this.sezzetGraph.compositeCategoriesOf(feature);
        Category category = compositeCategories.stream().filter(v -> v.label().equalsIgnoreCase(((Expression.Predicate.SingleValue)argument.a$(Expression.Predicate.SingleValue.class)).value())).findFirst().orElse(null);
        if (category != null) {
            ((Expression.Predicate.Enum)argument.a$(Expression.Predicate.Enum.class)).isComposedCategory(true);
        }
        return category;
    }

    private Category checkAsLeaf(Expression.Predicate.Argument argument, Feature feature, int line) {
        String value = ((Expression.Predicate.SingleValue)argument.a$(Expression.Predicate.SingleValue.class)).value();
        return this.sezzetGraph.leafCategoriesOf(feature).stream().filter(v -> v.label().equalsIgnoreCase(value)).findFirst().orElse(null);
    }

    private void check(Expression.Predicate.Period period, Feature feature, int line) {
        if (period == null && feature.isTimeless()) {
            return;
        }
        if (period == null) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("period.required", new Object[0])));
            return;
        }
        if (period.i$(Expression.Predicate.FromNow.class)) {
            this.checkPeriodFromNow((Expression.Predicate.FromNow)period.a$(Expression.Predicate.FromNow.class), line);
        }
        if (period.i$(Expression.Predicate.TimeRange.class)) {
            this.checkTimeRange((Expression.Predicate.TimeRange)period.a$(Expression.Predicate.TimeRange.class), line);
        }
    }

    private void checkTimeRange(Expression.Predicate.TimeRange timeRange, int line) {
        Instant now = this.sezzetGraph.storeScale().scale().minus(Instant.now());
        io.intino.sezzet.model.graph.rules.Scale storeScale = this.sezzetGraph.storeScale().scale();
        if (timeRange.fromInstant().isAfter(now) || timeRange.toInstant().isAfter(now)) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("malformed.time.range", new Object[0])));
        }
        String[] split = timeRange.from().split("-");
        Scale scale = Scale.values()[split.length - 1];
        if (scale.ordinal() > storeScale.ordinal()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("scale.must.be.higher", storeScale.name())));
        }
        if (storeScale.ordinal() != scale.ordinal()) {
            this.transformScale(timeRange, scale, storeScale);
        }
    }

    private void checkPeriodFromNow(Expression.Predicate.FromNow period, int line) {
        Scale scale = period.scale();
        io.intino.sezzet.model.graph.rules.Scale storeScale = this.sezzetGraph.storeScale().scale();
        if (scale.ordinal() > storeScale.ordinal()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("scale.must.be.higher", storeScale.name())));
        }
        if (storeScale.ordinal() != scale.ordinal()) {
            this.transformScale(period, scale, storeScale);
        }
    }

    private void transformScale(Expression.Predicate.FromNow period, Scale scale, io.intino.sezzet.model.graph.rules.Scale storeScale) {
        int value = period.amount();
        for (int i = scale.ordinal(); i < storeScale.ordinal(); ++i) {
            value = scale.toLowerScale(value);
        }
        period.amount(value).scale(Scale.valueOf(storeScale.name()));
    }

    private void transformScale(Expression.Predicate.TimeRange period, Scale scale, io.intino.sezzet.model.graph.rules.Scale storeScale) {
        String to = period.to();
        String from = period.from();
        for (int i = scale.ordinal(); i < storeScale.ordinal(); ++i) {
            from = scale.toLowerScaleStart(from);
            to = scale.toLowerScaleEnding(to);
        }
        period.from(from);
        period.to(to);
    }

    private void check(Expression.Predicate.Frequency frequency, Feature feature, int line) {
        if (frequency == null) {
            return;
        }
        if (frequency.highBound() < 0 || frequency.lowBound() < 0 || frequency.lowBound() > frequency.highBound()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("malformed.frequency", new Object[0])));
        }
    }

    private void check(Expression.Predicate.Recency recency, Expression.Predicate.Period period, Feature feature, int line) {
        if (recency == null) {
            return;
        }
        if (period == null) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("recency.without.period", new Object[0])));
        } else if (period.i$(Expression.Predicate.FromNow.class) && ((Expression.Predicate.FromNow)period.a$(Expression.Predicate.FromNow.class)).amount() < recency.amount()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("recency.out.of.period", new Object[0])));
        }
        this.checkScale(recency, line);
    }

    private void checkScale(Expression.Predicate.Recency recency, int line) {
        Scale scale = recency.scale();
        io.intino.sezzet.model.graph.rules.Scale storeScale = this.sezzetGraph.storeScale().scale();
        if (scale.ordinal() > storeScale.ordinal()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("scale.must.be.higher", storeScale.name())));
        }
        if (storeScale.ordinal() != scale.ordinal()) {
            this.transformScale(recency, scale, storeScale);
        }
    }

    private void transformScale(Expression.Predicate.Recency recency, Scale scale, io.intino.sezzet.model.graph.rules.Scale storeScale) {
        int value = recency.amount();
        for (int i = scale.ordinal(); i < storeScale.ordinal(); ++i) {
            value = scale.toLowerScale(value);
        }
        recency.amount(value).scale(Scale.valueOf(storeScale.name()));
    }

    private String message(String key, Object ... parameters) {
        return MessageFormat.format(new String(this.messages.getString(key).getBytes(), StandardCharsets.UTF_8), parameters);
    }
}

