/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.alexandria.logger.Logger;
import io.intino.magritte.framework.Graph;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.MessageProvider;
import io.intino.sezzet.setql.SetqlChecker;
import io.intino.sezzet.setql.SetqlParser;
import io.intino.sezzet.setql.SetqlSugarFree;
import io.intino.sezzet.setql.exceptions.SemanticException;
import io.intino.sezzet.setql.exceptions.SyntaxException;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class SetQL {
    private static DecimalFormat formatter = SetQL.formatter();

    public static SetqlGraph parseAndResolve(String input, Locale locale, SezzetGraph sezzet) {
        SetqlGraph graph = (SetqlGraph)new Graph().loadStashes(new String[]{"Setql"}).as(SetqlGraph.class);
        try {
            SetqlParser parser = new SetqlParser(input, locale);
            parser.parse(graph);
            new SetqlChecker(sezzet, locale).check(graph);
            new SetqlSugarFree(sezzet).free(graph);
            return graph;
        }
        catch (SemanticException | SyntaxException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static String toString(Expression.Predicate self, Locale locale) {
        return self.property() + "(" + self.argumentList().stream().map(a -> a.toString(locale)).collect(Collectors.joining(", ")) + ")" + SetQL.separator(self) + SetQL.modifier(self.modifier(), locale) + SetQL.periodString(self, locale) + SetQL.frequencyString(self, locale) + SetQL.recencyString(self, locale);
    }

    public static String description(Expression.Predicate self, Locale locale, String subject) {
        String type = SetQL.type(self);
        return self.property() + " " + MessageProvider.message(locale, "description.join.first", new Object[0]) + " " + subject + " " + MessageProvider.message(locale, "description.join." + SetQL.modifier(self, type), new Object[0]) + " " + SetQL.values(self, locale, type) + SetQL.period(self, locale) + SetQL.frequency(self, locale) + SetQL.recency(self, locale);
    }

    private static String type(Expression.Predicate self) {
        return self.argumentList().isEmpty() ? "singleton" : ((Object)((Object)self.argumentList().get(0))).getClass().getSimpleName().toLowerCase();
    }

    private static String period(Expression.Predicate self, Locale locale) {
        if (self.period() == null) {
            return "";
        }
        String message = MessageProvider.message(locale, "description.join.period." + ((Object)((Object)self.period())).getClass().getSimpleName().toLowerCase() + (SetQL.valueOf(self.period()) == 1 ? ".singular" : ""), new Object[0]);
        return (String)(message.isEmpty() ? "" : " " + message) + " " + SetQL.periodDescription(self, locale);
    }

    private static int valueOf(Expression.Predicate.Period period) {
        return period.i$(Expression.Predicate.FromNow.class) ? ((Expression.Predicate.FromNow)period.a$(Expression.Predicate.FromNow.class)).amount() : 0;
    }

    private static String values(Expression.Predicate self, Locale locale, String type) {
        return self.argumentList().stream().map(a -> a.description(locale)).collect(Collectors.joining(", "));
    }

    private static String frequency(Expression.Predicate self, Locale locale) {
        return self.frequency() == null ? "" : " " + SetQL.description(self.frequency(), locale);
    }

    private static String recency(Expression.Predicate self, Locale locale) {
        return self.recency() == null ? "" : " " + MessageProvider.message(locale, "description.join.recency", new Object[0]) + " " + SetQL.recencyDescription(self, locale);
    }

    private static String modifier(Expression.Predicate self, String type) {
        Expression.Predicate.Range range;
        if (type.equals("numeric")) {
            return type + ".singular";
        }
        if (type.equals("range") && (range = (Expression.Predicate.Range)self.argumentList().get(0)).lowBound() == range.highBound()) {
            return "numeric.singular";
        }
        return type.equals("enum") || type.equals("text") ? type + (String)(self.argumentList().size() == 1 ? ".singular" : "." + self.modifier().name().toLowerCase()) : type;
    }

    public static String toString(Expression.Predicate.VariableOperation self, Locale locale) {
        return SetQL.toString(self);
    }

    public static String toString(Expression.Predicate.VariableOperation self) {
        StringBuilder builder = new StringBuilder("'");
        List<Expression.Predicate.VariableOperation.Comparison> comparisons = self.comparisonList();
        for (int i = 0; i < comparisons.size(); ++i) {
            if (i > 0) {
                builder.append(" ").append(self.operators().get(i - 1).value()).append(" ");
            }
            Expression.Predicate.VariableOperation.Comparison comparision = comparisons.get(i);
            builder.append(comparision.variable()).append(" ").append(comparision.comparator()).append(" ").append(comparision.value());
        }
        return builder.append("'").toString();
    }

    public static String toString(Expression.Predicate.Frequency self, Locale locale) {
        return " " + MessageProvider.message(locale, "frequency", new Object[0]) + SetQL.valuesOf(self.lowBound(), self.highBound(), 0);
    }

    public static String description(Expression.Predicate.Frequency self, Locale locale) {
        String values = SetQL.frequencyValuesOf(self.lowBound(), self.highBound(), 0, locale);
        String description = (String)(values.contains("..") ? MessageProvider.message(locale, "between", new Object[0]) + " " : "") + values.replace("..", " " + MessageProvider.message(locale, "and", new Object[0]) + " ") + " " + MessageProvider.message(locale, "times", new Object[0]);
        if (self.consecutives()) {
            description = description + " " + MessageProvider.message(locale, "consecutive", new Object[0]);
        }
        return description;
    }

    public static String toString(Expression.Predicate.Recency self, Locale locale) {
        return " " + MessageProvider.message(locale, "recency", new Object[0]) + " = " + self.amount() + self.scale().name().toLowerCase().charAt(0) + (String)(self.range().equals((Object)AbstractExpression.AbstractPredicate.AbstractRecency.Range.Old) ? "" : " " + MessageProvider.message(locale, self.range().name().toLowerCase(), new Object[0]));
    }

    public static String toString(Expression.Predicate.Range self, Locale locale) {
        String value = SetQL.valuesOf(self.lowBound(), self.highBound(), self.decimals()).trim();
        return value.startsWith("=") ? value.substring(2) : value;
    }

    public static String toString(Expression.Predicate.Numeric self, Locale locale) {
        return SetQL.truncate(self.value(), self.decimals());
    }

    private static String truncate(String value, int decimals) {
        if (!value.contains(".")) {
            return value;
        }
        int i = value.indexOf(".");
        if (i + decimals > value.length()) {
            return value;
        }
        return value.substring(0, i + decimals);
    }

    public static String toString(Expression.Predicate.FromNow self, Locale locale) {
        return " " + MessageProvider.message(locale, "period", new Object[0]) + " = " + self.amount() + SetQL.scale(self.scale(), locale, self.amount());
    }

    public static String description(Expression.Predicate.FromNow self, Locale locale) {
        return (String)(self.amount() == 1 ? "" : self.amount() + " ") + SetQL.scale(self.scale(), locale, self.amount());
    }

    public static String description(Expression.Predicate.Argument self, Locale locale) {
        return self.toString(locale);
    }

    public static String description(Expression.Predicate.Range self, Locale locale) {
        String values = SetQL.descriptionValuesOf(self.lowBound(), self.highBound(), 0, locale);
        return (String)(values.contains("..") ? MessageProvider.message(locale, "between", new Object[0]) + " " : "") + values.replace("..", (self.unit() == null ? "" : self.unit()) + " " + MessageProvider.message(locale, "and", new Object[0]) + " ") + (self.unit() == null ? "" : self.unit());
    }

    public static String description(Expression.Predicate.Numeric self, Locale locale) {
        return SetQL.truncate(formatter.format(Double.parseDouble(self.value())), self.decimals()) + (self.unit() == null ? "" : self.unit());
    }

    private static String scale(Scale self, Locale locale, int amount) {
        return MessageProvider.message(locale, self.name().toLowerCase() + (amount > 1 ? "_plural" : "") + "_natural", new Object[0]);
    }

    private static String modifier(AbstractExpression.AbstractPredicate.Modifier modifier, Locale locale) {
        if (modifier.equals((Object)AbstractExpression.AbstractPredicate.Modifier.All)) {
            return "";
        }
        return " " + MessageProvider.message(locale, modifier.name().toLowerCase(), new Object[0]);
    }

    public static String toString(Expression.Predicate.TimeRange self, Locale locale) {
        return " " + MessageProvider.message(locale, "period", new Object[0]) + " = " + self.from() + ".." + self.to();
    }

    public static String description(Expression.Predicate.TimeRange self, Locale locale) {
        return MessageProvider.message(locale, "description.join.from", new Object[0]) + " " + self.from() + " " + MessageProvider.message(locale, "description.join.to", new Object[0]) + " " + self.to();
    }

    private static String separator(Expression.Predicate self) {
        return self.modifier() != AbstractExpression.AbstractPredicate.Modifier.All || self.recency() != null || self.frequency() != null || self.period() != null ? " ::" : "";
    }

    private static String periodString(Expression.Predicate self, Locale locale) {
        return self.period() != null ? self.period().toString(locale) : "";
    }

    private static String periodDescription(Expression.Predicate self, Locale locale) {
        return self.period() != null ? self.period().description(locale) : "";
    }

    private static String frequencyString(Expression.Predicate self, Locale locale) {
        return self.frequency() != null ? self.frequency().description(locale) : "";
    }

    private static String recencyString(Expression.Predicate self, Locale locale) {
        return self.recency() != null ? self.recency().toString(locale) : "";
    }

    private static String recencyDescription(Expression.Predicate self, Locale locale) {
        Expression.Predicate.Recency recency = self.recency();
        return recency.amount() + " " + SetQL.scale(recency.scale(), locale, recency.amount()) + (String)(recency.range().equals((Object)AbstractExpression.AbstractPredicate.AbstractRecency.Range.Old) ? "" : " " + MessageProvider.message(locale, recency.range().name().toLowerCase(), new Object[0]));
    }

    private static String valuesOf(double lowBound, double highBound, int decimals) {
        if (lowBound == Double.MIN_VALUE) {
            return " <= " + highBound;
        }
        if (highBound == Double.MAX_VALUE) {
            return " >= " + lowBound;
        }
        return " = " + SetQL.truncate(String.format("%.2f", lowBound).replace(",", "."), decimals) + ".." + SetQL.truncate(String.format("%.2f", highBound).replace(",", "."), decimals);
    }

    private static String descriptionValuesOf(double lowBound, double highBound, int decimals, Locale locale) {
        String high;
        if (lowBound == Double.MIN_VALUE || lowBound == -2.147483648E9) {
            return MessageProvider.message(locale, "lowerorequals", new Object[0]) + " " + SetQL.truncate(formatter.format(highBound), decimals);
        }
        if (highBound >= Double.MAX_VALUE || highBound >= 2.147483647E9) {
            return MessageProvider.message(locale, "greaterorequals", new Object[0]) + " " + SetQL.truncate(formatter.format(lowBound), decimals);
        }
        String low = SetQL.truncate(formatter.format(lowBound), decimals);
        if (low.equals(high = SetQL.truncate(formatter.format(highBound), decimals))) {
            return MessageProvider.message(locale, "equals", new Object[0]) + " " + SetQL.truncate(formatter.format(highBound), decimals);
        }
        return low + ".." + high;
    }

    private static String frequencyValuesOf(double lowBound, double highBound, int decimals, Locale locale) {
        String high;
        if (lowBound == 0.0) {
            return MessageProvider.message(locale, "frequency.lower", new Object[0]) + " " + SetQL.truncate(formatter.format(highBound + 1.0), decimals);
        }
        if (highBound >= Double.MAX_VALUE || highBound >= 2.147483647E9) {
            return MessageProvider.message(locale, "frequency.greater", new Object[0]) + " " + SetQL.truncate(formatter.format(lowBound - 1.0), decimals);
        }
        String low = SetQL.truncate(formatter.format(lowBound), decimals);
        if (low.equals(high = SetQL.truncate(formatter.format(highBound), decimals))) {
            return MessageProvider.message(locale, "equals", new Object[0]) + " " + SetQL.truncate(formatter.format(highBound), decimals);
        }
        return low + ".." + high;
    }

    public static Instant fromInstant(Expression.Predicate.TimeRange self) {
        return SetQL.instantOf(self.from());
    }

    public static Instant toInstant(Expression.Predicate.TimeRange self) {
        return SetQL.instantOf(self.to());
    }

    private static Instant instantOf(String value) {
        int[] fields = SetQL.toInt(value.split("-"));
        ZonedDateTime time = ZonedDateTime.of(fields[0], fields.length > 1 ? fields[1] : 1, fields.length > 2 ? fields[2] : 1, fields.length > 3 ? fields[3] : 0, fields.length > 4 ? fields[4] : 0, fields.length > 5 ? fields[5] : 0, 0, ZoneId.of("UTC"));
        return Instant.from(time);
    }

    private static int[] toInt(String[] strings) {
        int[] fields = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            fields[i] = Integer.parseInt(strings[i]);
        }
        return fields;
    }

    private static DecimalFormat formatter() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(symbols);
        return decimalFormat;
    }
}

