/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql.graph;

import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.functions.ToString;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractExpression
extends Layer
implements Terminal {
    protected String raw;
    protected List<Operand> operandList = new ArrayList<Operand>();
    protected List<InnerExpression> innerExpressionList = new ArrayList<InnerExpression>();
    protected List<Predicate> predicateList = new ArrayList<Predicate>();

    public AbstractExpression(Node node) {
        super(node);
    }

    public String raw() {
        return this.raw;
    }

    public Expression raw(String value) {
        this.raw = value;
        return (Expression)this;
    }

    public List<Operand> operandList() {
        return Collections.unmodifiableList(this.operandList);
    }

    public Operand operand(int index) {
        return this.operandList.get(index);
    }

    public List<Operand> operandList(java.util.function.Predicate<Operand> predicate) {
        return this.operandList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<InnerExpression> innerExpressionList() {
        return Collections.unmodifiableList(this.innerExpressionList);
    }

    public InnerExpression innerExpression(int index) {
        return this.innerExpressionList.get(index);
    }

    public List<InnerExpression> innerExpressionList(java.util.function.Predicate<InnerExpression> predicate) {
        return this.innerExpressionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Predicate> predicateList() {
        return Collections.unmodifiableList(this.predicateList);
    }

    public Predicate predicate(int index) {
        return this.predicateList.get(index);
    }

    public List<Predicate> predicateList(java.util.function.Predicate<Predicate> predicate) {
        return this.predicateList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Operand>(this.operandList).forEach(c -> components.add(c.core$()));
        new ArrayList<InnerExpression>(this.innerExpressionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Predicate>(this.predicateList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("raw", new ArrayList<String>(Collections.singletonList(this.raw)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Expression$Operand")) {
            this.operandList.add((Operand)node.as(Operand.class));
        }
        if (node.is("Expression$InnerExpression")) {
            this.innerExpressionList.add((InnerExpression)node.as(InnerExpression.class));
        }
        if (node.is("Expression$Predicate")) {
            this.predicateList.add((Predicate)node.as(Predicate.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Expression$Operand")) {
            this.operandList.remove(node.as(Operand.class));
        }
        if (node.is("Expression$InnerExpression")) {
            this.innerExpressionList.remove(node.as(InnerExpression.class));
        }
        if (node.is("Expression$Predicate")) {
            this.predicateList.remove(node.as(Predicate.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("raw")) {
            this.raw = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("raw")) {
            this.raw = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SetqlGraph graph() {
        return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
    }

    public static class Predicate
    extends Operand
    implements Terminal {
        protected String property;
        protected ToString toString;
        protected Operator argumentOperator;
        protected Modifier modifier;
        protected List<Argument> argumentList = new ArrayList<Argument>();
        protected List<Range> rangeList = new ArrayList<Range>();
        protected List<SingleValue> singleValueList = new ArrayList<SingleValue>();
        protected List<Numeric> numericList = new ArrayList<Numeric>();
        protected List<Text> textList = new ArrayList<Text>();
        protected List<Enum> enumList = new ArrayList<Enum>();
        protected List<VariableOperation> variableOperationList = new ArrayList<VariableOperation>();
        protected Period period;
        protected FromNow fromNow;
        protected TimeRange timeRange;
        protected Frequency frequency;
        protected Recency recency;

        public Predicate(Node node) {
            super(node);
        }

        public String property() {
            return this.property;
        }

        public String toString(Locale locale) {
            return this.toString.toString(locale);
        }

        public Operator argumentOperator() {
            return this.argumentOperator;
        }

        public Modifier modifier() {
            return this.modifier;
        }

        public Predicate property(String value) {
            this.property = value;
            return this;
        }

        public Predicate toString(ToString value) {
            this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
            return this;
        }

        public Predicate argumentOperator(Operator value) {
            this.argumentOperator = value;
            return this;
        }

        public Predicate modifier(Modifier value) {
            this.modifier = value;
            return this;
        }

        public List<Argument> argumentList() {
            return Collections.unmodifiableList(this.argumentList);
        }

        public Argument argument(int index) {
            return this.argumentList.get(index);
        }

        public List<Argument> argumentList(java.util.function.Predicate<Argument> predicate) {
            return this.argumentList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Range> rangeList() {
            return Collections.unmodifiableList(this.rangeList);
        }

        public Range range(int index) {
            return this.rangeList.get(index);
        }

        public List<Range> rangeList(java.util.function.Predicate<Range> predicate) {
            return this.rangeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<SingleValue> singleValueList() {
            return Collections.unmodifiableList(this.singleValueList);
        }

        public SingleValue singleValue(int index) {
            return this.singleValueList.get(index);
        }

        public List<SingleValue> singleValueList(java.util.function.Predicate<SingleValue> predicate) {
            return this.singleValueList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Numeric> numericList() {
            return Collections.unmodifiableList(this.numericList);
        }

        public Numeric numeric(int index) {
            return this.numericList.get(index);
        }

        public List<Numeric> numericList(java.util.function.Predicate<Numeric> predicate) {
            return this.numericList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Text> textList() {
            return Collections.unmodifiableList(this.textList);
        }

        public Text text(int index) {
            return this.textList.get(index);
        }

        public List<Text> textList(java.util.function.Predicate<Text> predicate) {
            return this.textList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Enum> enumList() {
            return Collections.unmodifiableList(this.enumList);
        }

        public Enum enum$(int index) {
            return this.enumList.get(index);
        }

        public List<Enum> enumList(java.util.function.Predicate<Enum> predicate) {
            return this.enumList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<VariableOperation> variableOperationList() {
            return Collections.unmodifiableList(this.variableOperationList);
        }

        public VariableOperation variableOperation(int index) {
            return this.variableOperationList.get(index);
        }

        public List<VariableOperation> variableOperationList(java.util.function.Predicate<VariableOperation> predicate) {
            return this.variableOperationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Period period() {
            return this.period;
        }

        public FromNow fromNow() {
            return this.fromNow;
        }

        public TimeRange timeRange() {
            return this.timeRange;
        }

        public Frequency frequency() {
            return this.frequency;
        }

        public Recency recency() {
            return this.recency;
        }

        public Predicate period(Period value) {
            this.period = value;
            return this;
        }

        public Predicate fromNow(FromNow value) {
            this.fromNow = value;
            return this;
        }

        public Predicate timeRange(TimeRange value) {
            this.timeRange = value;
            return this;
        }

        public Predicate frequency(Frequency value) {
            this.frequency = value;
            return this;
        }

        public Predicate recency(Recency value) {
            this.recency = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Argument>(this.argumentList).forEach(c -> components.add(c.core$()));
            new ArrayList<Range>(this.rangeList).forEach(c -> components.add(c.core$()));
            new ArrayList<SingleValue>(this.singleValueList).forEach(c -> components.add(c.core$()));
            new ArrayList<Numeric>(this.numericList).forEach(c -> components.add(c.core$()));
            new ArrayList<Text>(this.textList).forEach(c -> components.add(c.core$()));
            new ArrayList<Enum>(this.enumList).forEach(c -> components.add(c.core$()));
            new ArrayList<VariableOperation>(this.variableOperationList).forEach(c -> components.add(c.core$()));
            if (this.period != null) {
                components.add(this.period.core$());
            }
            if (this.fromNow != null) {
                components.add(this.fromNow.core$());
            }
            if (this.timeRange != null) {
                components.add(this.timeRange.core$());
            }
            if (this.frequency != null) {
                components.add(this.frequency.core$());
            }
            if (this.recency != null) {
                components.add(this.recency.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("property", new ArrayList<String>(Collections.singletonList(this.property)));
            map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
            map.put("argumentOperator", new ArrayList<Operator>(Collections.singletonList(this.argumentOperator)));
            map.put("modifier", new ArrayList<Modifier>(Collections.singletonList(this.modifier)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Expression$Predicate$Argument")) {
                this.argumentList.add((Argument)node.as(Argument.class));
            }
            if (node.is("Expression$Predicate$Range")) {
                this.rangeList.add((Range)node.as(Range.class));
            }
            if (node.is("Expression$Predicate$SingleValue")) {
                this.singleValueList.add((SingleValue)node.as(SingleValue.class));
            }
            if (node.is("Expression$Predicate$Numeric")) {
                this.numericList.add((Numeric)node.as(Numeric.class));
            }
            if (node.is("Expression$Predicate$Text")) {
                this.textList.add((Text)node.as(Text.class));
            }
            if (node.is("Expression$Predicate$Enum")) {
                this.enumList.add((Enum)node.as(Enum.class));
            }
            if (node.is("Expression$Predicate$VariableOperation")) {
                this.variableOperationList.add((VariableOperation)node.as(VariableOperation.class));
            }
            if (node.is("Expression$Predicate$Period")) {
                this.period = (Period)node.as(Period.class);
            }
            if (node.is("Expression$Predicate$FromNow")) {
                this.fromNow = (FromNow)node.as(FromNow.class);
            }
            if (node.is("Expression$Predicate$TimeRange")) {
                this.timeRange = (TimeRange)node.as(TimeRange.class);
            }
            if (node.is("Expression$Predicate$Frequency")) {
                this.frequency = (Frequency)node.as(Frequency.class);
            }
            if (node.is("Expression$Predicate$Recency")) {
                this.recency = (Recency)node.as(Recency.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Expression$Predicate$Argument")) {
                this.argumentList.remove(node.as(Argument.class));
            }
            if (node.is("Expression$Predicate$Range")) {
                this.rangeList.remove(node.as(Range.class));
            }
            if (node.is("Expression$Predicate$SingleValue")) {
                this.singleValueList.remove(node.as(SingleValue.class));
            }
            if (node.is("Expression$Predicate$Numeric")) {
                this.numericList.remove(node.as(Numeric.class));
            }
            if (node.is("Expression$Predicate$Text")) {
                this.textList.remove(node.as(Text.class));
            }
            if (node.is("Expression$Predicate$Enum")) {
                this.enumList.remove(node.as(Enum.class));
            }
            if (node.is("Expression$Predicate$VariableOperation")) {
                this.variableOperationList.remove(node.as(VariableOperation.class));
            }
            if (node.is("Expression$Predicate$Period")) {
                this.period = null;
            }
            if (node.is("Expression$Predicate$FromNow")) {
                this.fromNow = null;
            }
            if (node.is("Expression$Predicate$TimeRange")) {
                this.timeRange = null;
            }
            if (node.is("Expression$Predicate$Frequency")) {
                this.frequency = null;
            }
            if (node.is("Expression$Predicate$Recency")) {
                this.recency = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("property")) {
                this.property = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("toString")) {
                this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
            } else if (name.equalsIgnoreCase("argumentOperator")) {
                this.argumentOperator = (Operator)((Object)WordLoader.load(values, Operator.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("modifier")) {
                this.modifier = (Modifier)((Object)WordLoader.load(values, Modifier.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("property")) {
                this.property = (String)values.get(0);
            } else if (name.equalsIgnoreCase("toString")) {
                this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
            } else if (name.equalsIgnoreCase("argumentOperator")) {
                this.argumentOperator = (Operator)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("modifier")) {
                this.modifier = (Modifier)((Object)values.get(0));
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public SetqlGraph graph() {
            return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
        }

        public static class Recency
        extends Layer
        implements Terminal {
            protected ToString toString;
            protected int amount;
            protected Scale scale;
            protected Range range;

            public Recency(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public int amount() {
                return this.amount;
            }

            public Scale scale() {
                return this.scale;
            }

            public Range range() {
                return this.range;
            }

            public Recency toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return this;
            }

            public Recency amount(int value) {
                this.amount = value;
                return this;
            }

            public Recency scale(Scale value) {
                this.scale = value;
                return this;
            }

            public Recency range(Range value) {
                this.range = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                map.put("amount", new ArrayList<Integer>(Collections.singletonList(this.amount)));
                map.put("scale", new ArrayList<Scale>(Collections.singletonList(this.scale)));
                map.put("range", new ArrayList<Range>(Collections.singletonList(this.range)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)WordLoader.load(values, Scale.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("range")) {
                    this.range = (Range)((Object)WordLoader.load(values, Range.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("range")) {
                    this.range = (Range)((Object)values.get(0));
                }
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public static enum Range {
                Old,
                New;

            }
        }

        public static class Frequency
        extends Layer
        implements Terminal {
            protected ToString toString;
            protected int lowBound;
            protected int highBound;
            protected boolean consecutives;

            public Frequency(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public int lowBound() {
                return this.lowBound;
            }

            public int highBound() {
                return this.highBound;
            }

            public boolean consecutives() {
                return this.consecutives;
            }

            public Frequency toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return this;
            }

            public Frequency lowBound(int value) {
                this.lowBound = value;
                return this;
            }

            public Frequency highBound(int value) {
                this.highBound = value;
                return this;
            }

            public Frequency consecutives(boolean value) {
                this.consecutives = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                map.put("lowBound", new ArrayList<Integer>(Collections.singletonList(this.lowBound)));
                map.put("highBound", new ArrayList<Integer>(Collections.singletonList(this.highBound)));
                map.put("consecutives", new ArrayList<Boolean>(Collections.singletonList(this.consecutives)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                } else if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("consecutives")) {
                    this.consecutives = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                } else if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("consecutives")) {
                    this.consecutives = (Boolean)values.get(0);
                }
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static class TimeRange
        extends Period
        implements Terminal {
            protected String from;
            protected String to;
            protected io.intino.tara.magritte.Expression<Instant> fromInstant;
            protected io.intino.tara.magritte.Expression<Instant> toInstant;

            public TimeRange(Node node) {
                super(node);
            }

            public String from() {
                return this.from;
            }

            public String to() {
                return this.to;
            }

            public Instant fromInstant() {
                return (Instant)this.fromInstant.value();
            }

            public Instant toInstant() {
                return (Instant)this.toInstant.value();
            }

            public TimeRange from(String value) {
                this.from = value;
                return this;
            }

            public TimeRange to(String value) {
                this.to = value;
                return this;
            }

            public TimeRange fromInstant(io.intino.tara.magritte.Expression<Instant> value) {
                this.fromInstant = (io.intino.tara.magritte.Expression)FunctionLoader.load(value, (Layer)this, io.intino.tara.magritte.Expression.class);
                return this;
            }

            public TimeRange toInstant(io.intino.tara.magritte.Expression<Instant> value) {
                this.toInstant = (io.intino.tara.magritte.Expression)FunctionLoader.load(value, (Layer)this, io.intino.tara.magritte.Expression.class);
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("from", new ArrayList<String>(Collections.singletonList(this.from)));
                map.put("to", new ArrayList<String>(Collections.singletonList(this.to)));
                map.put("fromInstant", new ArrayList<io.intino.tara.magritte.Expression<Instant>>(Collections.singletonList(this.fromInstant)));
                map.put("toInstant", new ArrayList<io.intino.tara.magritte.Expression<Instant>>(Collections.singletonList(this.toInstant)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("from")) {
                    this.from = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("fromInstant")) {
                    this.fromInstant = (io.intino.tara.magritte.Expression)FunctionLoader.load(values, (Layer)this, io.intino.tara.magritte.Expression.class).get(0);
                } else if (name.equalsIgnoreCase("toInstant")) {
                    this.toInstant = (io.intino.tara.magritte.Expression)FunctionLoader.load(values, (Layer)this, io.intino.tara.magritte.Expression.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("from")) {
                    this.from = (String)values.get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (String)values.get(0);
                } else if (name.equalsIgnoreCase("fromInstant")) {
                    this.fromInstant = (io.intino.tara.magritte.Expression)FunctionLoader.load(values.get(0), (Layer)this, io.intino.tara.magritte.Expression.class);
                } else if (name.equalsIgnoreCase("toInstant")) {
                    this.toInstant = (io.intino.tara.magritte.Expression)FunctionLoader.load(values.get(0), (Layer)this, io.intino.tara.magritte.Expression.class);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static class FromNow
        extends Period
        implements Terminal {
            protected int amount;
            protected Scale scale;

            public FromNow(Node node) {
                super(node);
            }

            public int amount() {
                return this.amount;
            }

            public Scale scale() {
                return this.scale;
            }

            public FromNow amount(int value) {
                this.amount = value;
                return this;
            }

            public FromNow scale(Scale value) {
                this.scale = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("amount", new ArrayList<Integer>(Collections.singletonList(this.amount)));
                map.put("scale", new ArrayList<Scale>(Collections.singletonList(this.scale)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)WordLoader.load(values, Scale.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("amount")) {
                    this.amount = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("scale")) {
                    this.scale = (Scale)((Object)values.get(0));
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class Period
        extends Layer
        implements Terminal {
            protected ToString toString;

            public Period(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public Period toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class VariableOperation
        extends SingleValue
        implements Terminal {
            protected List<Operator> operators = new ArrayList<Operator>();
            protected List<Comparison> comparisonList = new ArrayList<Comparison>();

            public VariableOperation(Node node) {
                super(node);
            }

            public List<Operator> operators() {
                return this.operators;
            }

            public VariableOperation operators(List<Operator> values) {
                this.operators = values;
                return this;
            }

            public List<Comparison> comparisonList() {
                return Collections.unmodifiableList(this.comparisonList);
            }

            public Comparison comparison(int index) {
                return this.comparisonList.get(index);
            }

            public List<Comparison> comparisonList(java.util.function.Predicate<Comparison> predicate) {
                return this.comparisonList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Comparison>(this.comparisonList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("operators", this.operators);
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Expression$Predicate$VariableOperation$Comparison")) {
                    this.comparisonList.add((Comparison)node.as(Comparison.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Expression$Predicate$VariableOperation$Comparison")) {
                    this.comparisonList.remove(node.as(Comparison.class));
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("operators")) {
                    this.operators = WordLoader.load(values, Operator.class, (Layer)this);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("operators")) {
                    this.operators = new ArrayList(values);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public static class Comparison
            extends Layer
            implements Terminal {
                protected String variable;
                protected String comparator;
                protected String value;

                public Comparison(Node node) {
                    super(node);
                }

                public String variable() {
                    return this.variable;
                }

                public String comparator() {
                    return this.comparator;
                }

                public String value() {
                    return this.value;
                }

                public Comparison variable(String value) {
                    this.variable = value;
                    return this;
                }

                public Comparison comparator(String value) {
                    this.comparator = value;
                    return this;
                }

                public Comparison value(String value) {
                    this.value = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("variable", new ArrayList<String>(Collections.singletonList(this.variable)));
                    map.put("comparator", new ArrayList<String>(Collections.singletonList(this.comparator)));
                    map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("variable")) {
                        this.variable = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("comparator")) {
                        this.comparator = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("value")) {
                        this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("variable")) {
                        this.variable = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("comparator")) {
                        this.comparator = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("value")) {
                        this.value = (String)values.get(0);
                    }
                }

                public SetqlGraph graph() {
                    return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
                }
            }

            public class Clear {
                public void comparison(java.util.function.Predicate<Comparison> filter) {
                    new ArrayList<Comparison>(VariableOperation.this.comparisonList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends SingleValue.Create {
                public Create(String name) {
                    super(name);
                }

                public Comparison comparison(String variable, String comparator, String value) {
                    Comparison newElement = (Comparison)VariableOperation.this.core$().graph().concept(Comparison.class).createNode(this.name, VariableOperation.this.core$()).as(Comparison.class);
                    newElement.core$().set((Layer)newElement, "variable", Collections.singletonList(variable));
                    newElement.core$().set((Layer)newElement, "comparator", Collections.singletonList(comparator));
                    newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                    return newElement;
                }
            }
        }

        public static class Enum
        extends SingleValue
        implements Terminal {
            protected boolean isComposedCategory;

            public Enum(Node node) {
                super(node);
            }

            public boolean isComposedCategory() {
                return this.isComposedCategory;
            }

            public Enum isComposedCategory(boolean value) {
                this.isComposedCategory = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("isComposedCategory", new ArrayList<Boolean>(Collections.singletonList(this.isComposedCategory)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("isComposedCategory")) {
                    this.isComposedCategory = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("isComposedCategory")) {
                    this.isComposedCategory = (Boolean)values.get(0);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static class Text
        extends SingleValue
        implements Terminal {
            public Text(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static class Numeric
        extends SingleValue
        implements Terminal {
            public Numeric(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class SingleValue
        extends Argument
        implements Terminal {
            protected String value;

            public SingleValue(Node node) {
                super(node);
            }

            public String value() {
                return this.value;
            }

            public SingleValue value(String value) {
                this.value = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public class Create
            extends Argument.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Range
        extends Argument
        implements Terminal {
            protected int lowBound;
            protected int highBound;

            public Range(Node node) {
                super(node);
            }

            public int lowBound() {
                return this.lowBound;
            }

            public int highBound() {
                return this.highBound;
            }

            public Range lowBound(int value) {
                this.lowBound = value;
                return this;
            }

            public Range highBound(int value) {
                this.highBound = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("lowBound", new ArrayList<Integer>(Collections.singletonList(this.lowBound)));
                map.put("highBound", new ArrayList<Integer>(Collections.singletonList(this.highBound)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("lowBound")) {
                    this.lowBound = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("highBound")) {
                    this.highBound = (Integer)values.get(0);
                }
            }

            @Override
            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }
        }

        public static abstract class Argument
        extends Layer
        implements Terminal {
            protected ToString toString;

            public Argument(Node node) {
                super(node);
            }

            public String toString(Locale locale) {
                return this.toString.toString(locale);
            }

            public Argument toString(ToString value) {
                this.toString = (ToString)FunctionLoader.load((Object)this.toString, (Layer)this, ToString.class);
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("toString", this.toString != null ? new ArrayList<ToString>(Collections.singletonList(this.toString)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values, (Layer)this, ToString.class).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("toString")) {
                    this.toString = (ToString)FunctionLoader.load(values.get(0), (Layer)this, ToString.class);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public SetqlGraph graph() {
                return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Clear {
            public void range(java.util.function.Predicate<Range> filter) {
                new ArrayList<Range>(Predicate.this.rangeList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void numeric(java.util.function.Predicate<Numeric> filter) {
                new ArrayList<Numeric>(Predicate.this.numericList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void text(java.util.function.Predicate<Text> filter) {
                new ArrayList<Text>(Predicate.this.textList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void enum$(java.util.function.Predicate<Enum> filter) {
                new ArrayList<Enum>(Predicate.this.enumList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void variableOperation(java.util.function.Predicate<VariableOperation> filter) {
                new ArrayList<VariableOperation>(Predicate.this.variableOperationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Operand.Create {
            public Create(String name) {
                super(name);
            }

            public Range range(int lowBound, int highBound) {
                Range newElement = (Range)Predicate.this.core$().graph().concept(Range.class).createNode(this.name, Predicate.this.core$()).as(Range.class);
                newElement.core$().set((Layer)newElement, "lowBound", Collections.singletonList(lowBound));
                newElement.core$().set((Layer)newElement, "highBound", Collections.singletonList(highBound));
                return newElement;
            }

            public Numeric numeric(String value) {
                Numeric newElement = (Numeric)Predicate.this.core$().graph().concept(Numeric.class).createNode(this.name, Predicate.this.core$()).as(Numeric.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }

            public Text text(String value) {
                Text newElement = (Text)Predicate.this.core$().graph().concept(Text.class).createNode(this.name, Predicate.this.core$()).as(Text.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }

            public Enum enum$(String value) {
                Enum newElement = (Enum)Predicate.this.core$().graph().concept(Enum.class).createNode(this.name, Predicate.this.core$()).as(Enum.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }

            public VariableOperation variableOperation() {
                VariableOperation newElement = (VariableOperation)Predicate.this.core$().graph().concept(VariableOperation.class).createNode(this.name, Predicate.this.core$()).as(VariableOperation.class);
                return newElement;
            }

            public FromNow fromNow(int amount, Scale scale) {
                FromNow newElement = (FromNow)Predicate.this.core$().graph().concept(FromNow.class).createNode(this.name, Predicate.this.core$()).as(FromNow.class);
                newElement.core$().set((Layer)newElement, "amount", Collections.singletonList(amount));
                newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
                return newElement;
            }

            public TimeRange timeRange(String from, String to) {
                TimeRange newElement = (TimeRange)Predicate.this.core$().graph().concept(TimeRange.class).createNode(this.name, Predicate.this.core$()).as(TimeRange.class);
                newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
                newElement.core$().set((Layer)newElement, "to", Collections.singletonList(to));
                return newElement;
            }

            public Frequency frequency(int lowBound, int highBound) {
                Frequency newElement = (Frequency)Predicate.this.core$().graph().concept(Frequency.class).createNode(this.name, Predicate.this.core$()).as(Frequency.class);
                newElement.core$().set((Layer)newElement, "lowBound", Collections.singletonList(lowBound));
                newElement.core$().set((Layer)newElement, "highBound", Collections.singletonList(highBound));
                return newElement;
            }

            public Recency recency(int amount, Scale scale, Recency.Range range) {
                Recency newElement = (Recency)Predicate.this.core$().graph().concept(Recency.class).createNode(this.name, Predicate.this.core$()).as(Recency.class);
                newElement.core$().set((Layer)newElement, "amount", Collections.singletonList(amount));
                newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
                newElement.core$().set((Layer)newElement, "range", Collections.singletonList(range));
                return newElement;
            }
        }

        public static enum Modifier {
            All,
            Commons,
            Uncommons;

        }
    }

    public static class InnerExpression
    extends Operand
    implements Terminal {
        protected Expression expression;

        public InnerExpression(Node node) {
            super(node);
        }

        public Expression expression() {
            return this.expression;
        }

        public InnerExpression expression(Expression value) {
            this.expression = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.expression != null) {
                components.add(this.expression.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Expression")) {
                this.expression = (Expression)node.as(Expression.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Expression")) {
                this.expression = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public SetqlGraph graph() {
            return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
        }

        public class Clear {
        }

        public class Create
        extends Operand.Create {
            public Create(String name) {
                super(name);
            }

            public Expression expression(String raw) {
                Expression newElement = (Expression)InnerExpression.this.core$().graph().concept(Expression.class).createNode(this.name, InnerExpression.this.core$()).as(Expression.class);
                newElement.core$().set((Layer)newElement, "raw", Collections.singletonList(raw));
                return newElement;
            }
        }
    }

    public static abstract class Operand
    extends Layer
    implements Terminal {
        protected int line;
        protected Operator operator;

        public Operand(Node node) {
            super(node);
        }

        public int line() {
            return this.line;
        }

        public Operator operator() {
            return this.operator;
        }

        public Operand line(int value) {
            this.line = value;
            return this;
        }

        public Operand operator(Operator value) {
            this.operator = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("line", new ArrayList<Integer>(Collections.singletonList(this.line)));
            map.put("operator", new ArrayList<Operator>(Collections.singletonList(this.operator)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("line")) {
                this.line = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("operator")) {
                this.operator = (Operator)((Object)WordLoader.load(values, Operator.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("line")) {
                this.line = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("operator")) {
                this.operator = (Operator)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public SetqlGraph graph() {
            return (SetqlGraph)this.core$().graph().as(SetqlGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void innerExpression(java.util.function.Predicate<InnerExpression> filter) {
            new ArrayList<InnerExpression>(AbstractExpression.this.innerExpressionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void predicate(java.util.function.Predicate<Predicate> filter) {
            new ArrayList<Predicate>(AbstractExpression.this.predicateList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public InnerExpression innerExpression(int line) {
            InnerExpression newElement = (InnerExpression)AbstractExpression.this.core$().graph().concept(InnerExpression.class).createNode(this.name, AbstractExpression.this.core$()).as(InnerExpression.class);
            newElement.core$().set((Layer)newElement, "line", Collections.singletonList(line));
            return newElement;
        }

        public Predicate predicate(int line, String property) {
            Predicate newElement = (Predicate)AbstractExpression.this.core$().graph().concept(Predicate.class).createNode(this.name, AbstractExpression.this.core$()).as(Predicate.class);
            newElement.core$().set((Layer)newElement, "line", Collections.singletonList(line));
            newElement.core$().set((Layer)newElement, "property", Collections.singletonList(property));
            return newElement;
        }
    }
}

