/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.model.graph.Category;
import io.intino.sezzet.model.graph.Feature;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class SetqlSugarFree {
    private SezzetGraph sezzet;

    SetqlSugarFree(SezzetGraph sezzet) {
        this.sezzet = sezzet;
    }

    public void free(SetqlGraph graph) {
        this.free(graph.expression());
    }

    private void free(Expression expression) {
        for (AbstractExpression.InnerExpression e : expression.innerExpressionList()) {
            this.free(e.expression());
        }
        for (AbstractExpression.Predicate predicate : new ArrayList<AbstractExpression.Predicate>(expression.predicateList())) {
            this.free(predicate);
        }
    }

    private void free(AbstractExpression.Predicate predicate) {
        Feature feature = this.sezzet.find(predicate.property());
        for (AbstractExpression.Predicate.Enum argument : new ArrayList<AbstractExpression.Predicate.Enum>(predicate.enumList())) {
            if (!argument.isComposedCategory()) continue;
            this.freeComposedValue(argument, this.categoryFrom(feature, argument));
        }
        if (!predicate.modifier().equals((Object)AbstractExpression.Predicate.Modifier.All)) {
            this.freeModifier(predicate);
        }
        if (predicate.recency() != null) {
            this.freeRecency(predicate);
        }
    }

    private void freeComposedValue(AbstractExpression.Predicate.Argument argument, Category value) {
        List categories = this.sezzet.leafCategoriesOf(Collections.singletonList(value));
        AbstractExpression.Predicate predicate = (AbstractExpression.Predicate)argument.core$().ownerAs(AbstractExpression.Predicate.class);
        predicate.clear().enum$(e -> true);
        for (Category c : categories) {
            predicate.create().enum$(c.label());
        }
    }

    private void freeModifier(AbstractExpression.Predicate predicate) {
        AbstractExpression.Predicate.Modifier modifier = predicate.modifier();
        if (modifier.equals((Object)AbstractExpression.Predicate.Modifier.Commons)) {
            predicate.argumentOperator(Operator.AND);
        } else if (modifier.equals((Object)AbstractExpression.Predicate.Modifier.Uncommons)) {
            predicate.argumentOperator(Operator.NAND);
        }
        predicate.modifier(AbstractExpression.Predicate.Modifier.All);
    }

    private void freeRecency(AbstractExpression.Predicate predicate) {
        this.substitute((Expression)predicate.core$().ownerAs(Expression.class), predicate, this.createInnerExpression(predicate, (Expression)predicate.core$().ownerAs(Expression.class)));
    }

    private void substitute(Expression expression, AbstractExpression.Operand predicate, AbstractExpression.Operand newExpression) {
        expression.replace(predicate, newExpression);
    }

    private AbstractExpression.InnerExpression createInnerExpression(AbstractExpression.Predicate predicate, Expression expression) {
        AbstractExpression.Predicate.Recency recency = predicate.recency();
        AbstractExpression.InnerExpression innerExpression = expression.create().innerExpression(predicate.line());
        Expression wrappedExpression = innerExpression.create().expression("");
        AbstractExpression.Predicate p1 = wrappedExpression.create().predicate(predicate.line(), predicate.property());
        AbstractExpression.Predicate p2 = wrappedExpression.create().predicate(predicate.line(), predicate.property());
        this.copyArguments(predicate, p1, p2);
        Scale scale = recency.scale();
        if (predicate.period().i$(AbstractExpression.Predicate.FromNow.class)) {
            AbstractExpression.Predicate.FromNow fromNow = (AbstractExpression.Predicate.FromNow)predicate.period().a$(AbstractExpression.Predicate.FromNow.class);
            p1.create().timeRange(scale.label(this.bound(fromNow.amount() - 1, scale)), scale.label(scale.minus(Instant.now())));
            if (recency.range().equals((Object)AbstractExpression.Predicate.Recency.Range.Old)) {
                p2.create().fromNow(recency.amount(), scale);
            } else {
                p2.create().timeRange(scale.label(this.bound(recency.amount(), scale)), scale.label(this.bound(1, scale)));
            }
        } else {
            AbstractExpression.Predicate.TimeRange timeRange = (AbstractExpression.Predicate.TimeRange)predicate.period().a$(AbstractExpression.Predicate.TimeRange.class);
            p1.create().timeRange(timeRange.from(), timeRange.to());
            if (recency.range().equals((Object)AbstractExpression.Predicate.Recency.Range.Old)) {
                p2.create().timeRange(scale.label(this.bound(recency.amount(), scale, timeRange.toInstant())), timeRange.to());
            } else {
                p2.create().timeRange(timeRange.from(), scale.label(this.bound(recency.amount(), scale, timeRange.toInstant())));
            }
        }
        p1.operator(predicate.operator());
        p2.operator(Operator.DIFF);
        return innerExpression;
    }

    private Instant bound(int amount, Scale scale) {
        Instant now = Instant.now();
        for (int i = 0; i <= amount; ++i) {
            now = scale.minus(now);
        }
        return now;
    }

    private Instant bound(int amount, Scale scale, Instant reference) {
        Instant instant = reference;
        for (int i = 0; i <= amount; ++i) {
            instant = scale.minus(instant);
        }
        return instant;
    }

    private void copyArguments(AbstractExpression.Predicate predicate, AbstractExpression.Predicate p1, AbstractExpression.Predicate p2) {
        for (AbstractExpression.Predicate.Argument argument : predicate.argumentList()) {
            this.copyArgument(argument, Arrays.asList(p1, p2));
        }
    }

    private void copyArgument(AbstractExpression.Predicate.Argument argument, List<AbstractExpression.Predicate> destinations) {
        if (argument.i$(AbstractExpression.Predicate.Numeric.class)) {
            destinations.forEach(d -> d.create().numeric(((AbstractExpression.Predicate.Numeric)argument.a$(AbstractExpression.Predicate.Numeric.class)).value()));
        } else if (argument.i$(AbstractExpression.Predicate.Text.class)) {
            destinations.forEach(d -> d.create().text(((AbstractExpression.Predicate.Text)argument.a$(AbstractExpression.Predicate.Text.class)).value()));
        } else if (argument.i$(AbstractExpression.Predicate.Enum.class)) {
            destinations.forEach(d -> d.create().enum$(((AbstractExpression.Predicate.Enum)argument.a$(AbstractExpression.Predicate.Enum.class)).value()));
        } else if (argument.i$(AbstractExpression.Predicate.Range.class)) {
            destinations.forEach(d -> d.create().range(((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).lowBound(), ((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).highBound()));
        }
    }

    private Category categoryFrom(Feature feature, AbstractExpression.Predicate.Enum argument) {
        return this.sezzet.compositeCategoriesOf(feature).stream().filter(v -> v.label().equalsIgnoreCase(argument.value())).findFirst().orElse(null);
    }
}

