/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.setql.SetqlENLexicon;
import io.intino.sezzet.setql.SetqlESLexicon;
import io.intino.sezzet.setql.SetqlGrammar;
import io.intino.sezzet.setql.SetqlModelGenerator;
import io.intino.sezzet.setql.exceptions.ErrorStrategy;
import io.intino.sezzet.setql.exceptions.GrammarErrorListener;
import io.intino.sezzet.setql.exceptions.SemanticException;
import io.intino.sezzet.setql.exceptions.SyntaxException;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.tara.magritte.utils.UTF8Control;
import java.util.Locale;
import java.util.ResourceBundle;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class SetqlParser {
    private final String input;
    private final ResourceBundle messages;
    private SetqlGrammar grammar;
    private SetqlGrammar.RootContext rootContext;

    public SetqlParser(String input, Locale locale) {
        this.input = input;
        this.messages = ResourceBundle.getBundle("messages", locale, (ResourceBundle.Control)new UTF8Control());
        if (input == null || input.isEmpty()) {
            return;
        }
        Lexer lexer = this.lexer(locale);
        lexer.reset();
        this.grammar = new SetqlGrammar((TokenStream)new CommonTokenStream((TokenSource)lexer));
        this.grammar.setErrorHandler((ANTLRErrorStrategy)new ErrorStrategy());
        this.grammar.addErrorListener(new GrammarErrorListener());
    }

    public void parse(SetqlGraph setqlGraph) throws SyntaxException, SemanticException {
        if (this.rootContext == null) {
            this.parse();
        }
        this.walk(new ParseTreeWalker(), new SetqlModelGenerator(setqlGraph));
    }

    public void check(SetqlGraph setqlGraph) throws SyntaxException, SemanticException {
        if (this.rootContext == null) {
            this.parse();
        }
        this.walk(new ParseTreeWalker(), new SetqlModelGenerator(setqlGraph));
    }

    private void walk(ParseTreeWalker walker, SetqlModelGenerator generator) throws SyntaxException, SemanticException {
        try {
            walker.walk((ParseTreeListener)generator, (ParseTree)this.rootContext);
            if (!generator.errors().isEmpty()) {
                throw new SemanticException().addAll(generator.errors());
            }
            generator.expression().raw(this.input);
        }
        catch (RecognitionException e) {
            Token token = ((Parser)e.getRecognizer()).getCurrentToken();
            throw new SyntaxException().add(new SyntaxException.SyntaxError(this.messages, token.getLine(), token.getCharPositionInLine(), token.getText(), this.getExpectedTokens((Parser)e.getRecognizer())));
        }
    }

    void parse() throws SyntaxException {
        try {
            this.rootContext = this.grammar.root();
        }
        catch (RecognitionException e) {
            Parser recognizer = (Parser)e.getRecognizer();
            Token token = recognizer.getCurrentToken();
            throw new SyntaxException().add(new SyntaxException.SyntaxError(this.messages, token.getLine(), token.getCharPositionInLine(), token.getText(), this.getExpectedTokens(recognizer)));
        }
    }

    private String getExpectedTokens(Parser recognizer) {
        try {
            return recognizer.getExpectedTokens().toString(VocabularyImpl.fromTokenNames((String[])recognizer.getTokenNames()));
        }
        catch (Exception e) {
            return "";
        }
    }

    private Lexer lexer(Locale locale) {
        if (locale.getCountry().equals("ES")) {
            return new SetqlESLexicon((CharStream)CharStreams.fromString((String)this.input));
        }
        return new SetqlENLexicon((CharStream)CharStreams.fromString((String)this.input));
    }
}

