/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.setql.SetqlGrammar;
import io.intino.sezzet.setql.SetqlGrammarBaseListener;
import io.intino.sezzet.setql.exceptions.SetqlError;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class SetqlModelGenerator
extends SetqlGrammarBaseListener {
    private List<SetqlError> errors = new ArrayList<SetqlError>();
    private final SetqlGraph graph;
    private Expression expression;
    private Stack<Expression> criterionStack = new Stack();
    private AbstractExpression.Predicate currentPredicate;

    SetqlModelGenerator(SetqlGraph graph) {
        this.graph = graph;
    }

    List<SetqlError> errors() {
        return this.errors;
    }

    Expression expression() {
        return this.expression;
    }

    @Override
    public void enterCriterion(SetqlGrammar.CriterionContext ctx) {
        if (this.criterionStack.isEmpty()) {
            this.expression = this.graph.create().expression(ctx.getText());
            this.criterionStack.push(this.expression);
        } else {
            AbstractExpression.InnerExpression innerExpression = this.criterionStack.peek().create().innerExpression(ctx.STAR().getSymbol().getLine());
            this.addOperator(ctx.parent, innerExpression);
            this.criterionStack.push(innerExpression.create().expression(ctx.getText()));
        }
    }

    private void addOperator(RuleContext parent, AbstractExpression.InnerExpression expression) {
        expression.operator(this.operatorFrom(parent));
    }

    @Override
    public void exitCriterion(SetqlGrammar.CriterionContext ctx) {
        this.criterionStack.pop();
    }

    @Override
    public void enterPredicate(SetqlGrammar.PredicateContext ctx) {
        Expression expression = this.criterionStack.peek();
        String feature = ctx.restriction().feature().getText();
        this.currentPredicate = expression.create().predicate(ctx.getStart().getLine(), feature);
        if (ctx.parent instanceof SetqlGrammar.InlinePredicateContext) {
            this.addOperator(ctx.parent);
        }
        this.enterArgument(ctx, this.currentPredicate);
    }

    private void addOperator(RuleContext parent) {
        this.currentPredicate.operator(this.operatorFrom(parent));
    }

    private void enterArgument(SetqlGrammar.PredicateContext ctx, AbstractExpression.Predicate predicate) {
        for (SetqlGrammar.ArgumentContext arg : ctx.restriction().argument()) {
            if (arg.range() != null) {
                this.processRange(predicate, arg);
                continue;
            }
            if (arg.comparator() != null) {
                this.processRelativeRange(predicate, arg);
                continue;
            }
            if (arg.STRING() != null) {
                String text = arg.STRING().getText();
                predicate.create().text(text.substring(1, text.length() - 1));
                continue;
            }
            if (arg.number() != null) {
                predicate.create().numeric(arg.number().getText());
                continue;
            }
            if (!arg.IDENTIFIER().isEmpty()) {
                predicate.create().enum$(String.join((CharSequence)" ", arg.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList())));
                continue;
            }
            if (arg.expression() == null) continue;
            this.processVariableOperation(predicate, arg);
        }
    }

    private void processVariableOperation(AbstractExpression.Predicate predicate, SetqlGrammar.ArgumentContext arg) {
        SetqlGrammar.ComputeContext expression = arg.expression().compute();
        AbstractExpression.Predicate.VariableOperation operation = predicate.create().variableOperation();
        if (expression instanceof SetqlGrammar.ComparatorExpressionContext) {
            this.parseComparision((SetqlGrammar.ComparatorExpressionContext)expression, operation);
        } else if (expression instanceof SetqlGrammar.BinaryExpressionContext) {
            SetqlGrammar.BinaryExpressionContext binary = (SetqlGrammar.BinaryExpressionContext)expression;
            operation.operators().add(Operator.fromText(binary.op.getText()));
            this.parseBinary(binary, operation);
        }
    }

    private void parseComparision(SetqlGrammar.ComparatorExpressionContext comparision, AbstractExpression.Predicate.VariableOperation operation) {
        if (comparision.left instanceof SetqlGrammar.IdentifierExpressionContext || comparision.right instanceof SetqlGrammar.IdentifierExpressionContext) {
            operation.create().comparison(this.variableFrom(comparision), comparision.op.getText(), this.number(comparision));
        }
    }

    private void parseBinary(SetqlGrammar.BinaryExpressionContext binary, AbstractExpression.Predicate.VariableOperation operation) {
        this.parseComparision((SetqlGrammar.ComparatorExpressionContext)binary.left, operation);
        this.parseComparision((SetqlGrammar.ComparatorExpressionContext)binary.right, operation);
    }

    private String variableFrom(SetqlGrammar.ComparatorExpressionContext comparision) {
        return comparision.left instanceof SetqlGrammar.IdentifierExpressionContext ? ((SetqlGrammar.IdentifierExpressionContext)comparision.left).IDENTIFIER().getText() : ((SetqlGrammar.IdentifierExpressionContext)comparision.right).IDENTIFIER().getText();
    }

    private String number(SetqlGrammar.ComparatorExpressionContext comparision) {
        return comparision.left instanceof SetqlGrammar.DecimalExpressionContext ? ((SetqlGrammar.DecimalExpressionContext)comparision.left).number().getText() : ((SetqlGrammar.DecimalExpressionContext)comparision.right).number().getText();
    }

    private void processRelativeRange(AbstractExpression.Predicate predicate, SetqlGrammar.ArgumentContext arg) {
        predicate.create().range(this.lowBound(arg.number().getText(), arg.comparator().getText()), this.highBound(arg.number().getText(), arg.comparator().getText()));
    }

    private void processRange(AbstractExpression.Predicate predicate, SetqlGrammar.ArgumentContext arg) {
        predicate.create().range(Integer.parseInt(arg.range().rangeValue(0).getText()), Integer.parseInt(arg.range().rangeValue(1).getText()));
    }

    @Override
    public void enterPeriod(SetqlGrammar.PeriodContext ctx) {
        if (ctx.scale() != null) {
            this.currentPredicate.create().fromNow(Integer.parseInt(ctx.NATURAL_VALUE().getText()), this.scale(ctx.scale()));
        } else {
            this.currentPredicate.create().timeRange(ctx.dateRange().dateValue().get(0).getText(), ctx.dateRange().dateValue().get(1).getText());
        }
    }

    @Override
    public void enterModifier(SetqlGrammar.ModifierContext ctx) {
        if (ctx.COMMONS() != null) {
            this.currentPredicate.modifier(AbstractExpression.Predicate.Modifier.Commons);
        } else if (ctx.UNCOMMONS() != null) {
            this.currentPredicate.modifier(AbstractExpression.Predicate.Modifier.Uncommons);
        }
    }

    @Override
    public void enterFrequency(SetqlGrammar.FrequencyContext ctx) {
        AbstractExpression.Predicate.Frequency frequency;
        if (ctx.range() != null) {
            frequency = this.currentPredicate.create().frequency(Integer.parseInt(ctx.range() != null ? ctx.range().rangeValue(0).getText() : ctx.NATURAL_VALUE().getText()), ctx.range() != null ? Integer.parseInt(ctx.range().rangeValue(1).getText()) : Integer.MAX_VALUE);
        } else {
            int lowBound = this.lowBound(ctx.NATURAL_VALUE().getText(), ctx.comparator().getText());
            frequency = this.currentPredicate.create().frequency(lowBound < 0 ? 0 : lowBound, this.highBound(ctx.NATURAL_VALUE().getText(), ctx.comparator().getText()));
        }
        if (ctx.CONSECUTIVE() != null) {
            frequency.consecutives(true);
        }
    }

    private int lowBound(String number, String comparator) {
        if (comparator.equals("=")) {
            return Integer.parseInt(number);
        }
        if (comparator.contains("<")) {
            return Integer.MIN_VALUE;
        }
        return comparator.contains("=") ? Integer.parseInt(number) : Integer.parseInt(number) + 1;
    }

    private int highBound(String number, String comparator) {
        if (comparator.equals("=")) {
            return Integer.parseInt(number);
        }
        if (comparator.contains(">")) {
            return Integer.MAX_VALUE;
        }
        return comparator.contains("=") ? Integer.parseInt(number) : Integer.parseInt(number) - 1;
    }

    private Operator operatorFrom(RuleContext parent) {
        if (parent.getParent().getParent() instanceof SetqlGrammar.OperationContext) {
            return Operator.fromText(((SetqlGrammar.OperationContext)parent.getParent().getParent()).operator().getText());
        }
        return Operator.OR;
    }

    @Override
    public void enterRecency(SetqlGrammar.RecencyContext ctx) {
        this.currentPredicate.create().recency(Integer.parseInt(ctx.NATURAL_VALUE().getText()), this.scale(ctx.scale()), ctx.NEW() != null ? AbstractExpression.Predicate.Recency.Range.New : AbstractExpression.Predicate.Recency.Range.Old);
    }

    private Scale scale(SetqlGrammar.ScaleContext ctx) {
        if (ctx.DAY() != null) {
            return Scale.Day;
        }
        if (ctx.MONTH() != null) {
            return Scale.Month;
        }
        if (ctx.YEAR() != null) {
            return Scale.Year;
        }
        return Scale.Hour;
    }
}

