/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.model.graph.Category;
import io.intino.sezzet.model.graph.Feature;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.model.graph.numeric.NumericFeature;
import io.intino.sezzet.setql.exceptions.SemanticException;
import io.intino.sezzet.setql.exceptions.SetqlError;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Scale;
import io.intino.tara.magritte.utils.UTF8Control;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SetqlChecker {
    private final ResourceBundle messages;
    private List<SetqlError> errors = new ArrayList<SetqlError>();
    private SezzetGraph sezzetGraph;

    public SetqlChecker(SezzetGraph graph, Locale locale) {
        this.sezzetGraph = graph;
        this.messages = ResourceBundle.getBundle("messages", locale, (ResourceBundle.Control)new UTF8Control());
    }

    public void check(SetqlGraph graph) throws SemanticException {
        this.check(graph.expression());
        if (!this.errors.isEmpty()) {
            throw new SemanticException().addAll(this.errors);
        }
    }

    private void check(Expression expression) {
        for (AbstractExpression.InnerExpression e : expression.innerExpressionList()) {
            this.check(e.expression());
        }
        for (AbstractExpression.Predicate predicate : expression.predicateList()) {
            this.check(predicate);
        }
    }

    private void check(AbstractExpression.Predicate predicate) {
        Feature feature = this.sezzetGraph.find(predicate.property());
        if (feature == null) {
            this.errors.add(new SemanticException.SemanticError(predicate.line(), 1, this.message("feature.not.found", predicate.property())));
            return;
        }
        if (feature.isSingleton()) {
            if (!predicate.argumentList().isEmpty()) {
                this.errors.add(new SemanticException.SemanticError(predicate.line(), 1, this.message("values.not.accepted", predicate.property())));
            }
        } else {
            if (!feature.isSingleton() && predicate.argumentList().isEmpty()) {
                this.errors.add(new SemanticException.SemanticError(predicate.line(), 1, this.message("values.required", predicate.property())));
            }
            for (AbstractExpression.Predicate.Argument argument : predicate.argumentList()) {
                this.check(argument, feature, predicate.line());
            }
        }
        this.check(predicate.period(), feature, predicate.line());
        this.check(predicate.frequency(), feature, predicate.line());
        this.check(predicate.recency(), predicate.period(), feature, predicate.line());
    }

    private void check(AbstractExpression.Predicate.Argument argument, Feature feature, int line) {
        if (argument.i$(AbstractExpression.Predicate.VariableOperation.class)) {
            this.variablesIn(((AbstractExpression.Predicate.VariableOperation)argument.a$(AbstractExpression.Predicate.VariableOperation.class)).value());
        } else if (feature.isEnumerate()) {
            this.checkEnumerate(argument, feature, line);
        } else if (feature.isNumeric()) {
            if (!argument.i$(AbstractExpression.Predicate.Numeric.class) && !argument.i$(AbstractExpression.Predicate.Range.class)) {
                this.errors.add(new SemanticException.SemanticError(line, 1, this.message("numeric.values.required", feature.label())));
            } else {
                NumericFeature numeric = feature.asNumeric();
                if (argument.i$(AbstractExpression.Predicate.Range.class)) {
                    AbstractExpression.Predicate.Range range = (AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class);
                    if (range.lowBound() == Integer.MIN_VALUE) {
                        range.lowBound(numeric.range().from());
                    }
                    if (range.highBound() == Integer.MAX_VALUE) {
                        range.highBound(numeric.range().to());
                    }
                    if (((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).lowBound() < numeric.range().from() || ((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).highBound() > numeric.range().to()) {
                        this.errors.add(new SemanticException.SemanticError(line, 1, this.message("numeric.range.value.out.of.bound", numeric.range().from(), numeric.range().to())));
                    }
                }
            }
        } else if (feature.isText() && !argument.i$(AbstractExpression.Predicate.Text.class)) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("text.values.required", feature.label())));
        }
    }

    private void variablesIn(String value) {
    }

    private void checkEnumerate(AbstractExpression.Predicate.Argument argument, Feature feature, int line) {
        Category category = this.checkAsLeaf(argument, feature, line);
        if (category == null) {
            category = this.checkAsComposite(argument, feature, line);
        }
        if (category == null) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("category.not.found", ((AbstractExpression.Predicate.SingleValue)argument.a$(AbstractExpression.Predicate.SingleValue.class)).value())));
        }
    }

    private Category checkAsComposite(AbstractExpression.Predicate.Argument argument, Feature feature, int line) {
        List compositeCategories = this.sezzetGraph.compositeCategoriesOf(feature);
        Category category = compositeCategories.stream().filter(v -> v.label().equalsIgnoreCase(((AbstractExpression.Predicate.SingleValue)argument.a$(AbstractExpression.Predicate.SingleValue.class)).value())).findFirst().orElse(null);
        if (category != null) {
            ((AbstractExpression.Predicate.Enum)argument.a$(AbstractExpression.Predicate.Enum.class)).isComposedCategory(true);
        }
        return category;
    }

    private Category checkAsLeaf(AbstractExpression.Predicate.Argument argument, Feature feature, int line) {
        String value = ((AbstractExpression.Predicate.SingleValue)argument.a$(AbstractExpression.Predicate.SingleValue.class)).value();
        return this.sezzetGraph.leafCategoriesOf(feature).stream().filter(v -> v.label().equalsIgnoreCase(value)).findFirst().orElse(null);
    }

    private void check(AbstractExpression.Predicate.Period period, Feature feature, int line) {
        if (period == null && feature.isTimeless()) {
            return;
        }
        if (period == null) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("period.required", new Object[0])));
            return;
        }
        if (period.i$(AbstractExpression.Predicate.FromNow.class)) {
            this.checkPeriodFromNow((AbstractExpression.Predicate.FromNow)period.a$(AbstractExpression.Predicate.FromNow.class), line);
        }
        if (period.i$(AbstractExpression.Predicate.TimeRange.class)) {
            this.checkTimeRange((AbstractExpression.Predicate.TimeRange)period.a$(AbstractExpression.Predicate.TimeRange.class), line);
        }
    }

    private void checkTimeRange(AbstractExpression.Predicate.TimeRange timeRange, int line) {
        Instant now = this.sezzetGraph.storeScale().scale().minus(Instant.now());
        io.intino.sezzet.model.graph.rules.Scale storeScale = this.sezzetGraph.storeScale().scale();
        if (timeRange.fromInstant().isAfter(now) || timeRange.toInstant().isAfter(now)) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("malformed.time.range", new Object[0])));
        }
        String[] split = timeRange.from().split("-");
        Scale scale = Scale.values()[split.length - 1];
        if (scale.ordinal() > storeScale.ordinal()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("scale.must.be.higher", storeScale.name())));
        }
        if (storeScale.ordinal() != scale.ordinal()) {
            this.transformScale(timeRange, scale, storeScale);
        }
    }

    private void checkPeriodFromNow(AbstractExpression.Predicate.FromNow period, int line) {
        Scale scale = period.scale();
        io.intino.sezzet.model.graph.rules.Scale storeScale = this.sezzetGraph.storeScale().scale();
        if (scale.ordinal() > storeScale.ordinal()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("scale.must.be.higher", storeScale.name())));
        }
        if (storeScale.ordinal() != scale.ordinal()) {
            this.transformScale(period, scale, storeScale);
        }
    }

    private void transformScale(AbstractExpression.Predicate.FromNow period, Scale scale, io.intino.sezzet.model.graph.rules.Scale storeScale) {
        int value = period.amount();
        for (int i = scale.ordinal(); i < storeScale.ordinal(); ++i) {
            value = scale.toLowerScale(value);
        }
        period.amount(value).scale(Scale.valueOf(storeScale.name()));
    }

    private void transformScale(AbstractExpression.Predicate.TimeRange period, Scale scale, io.intino.sezzet.model.graph.rules.Scale storeScale) {
        String to = period.to();
        String from = period.from();
        for (int i = scale.ordinal(); i < storeScale.ordinal(); ++i) {
            from = scale.toLowerScaleStart(from);
            to = scale.toLowerScaleEnding(to);
        }
        period.from(from);
        period.to(to);
    }

    private void check(AbstractExpression.Predicate.Frequency frequency, Feature feature, int line) {
        if (frequency == null) {
            return;
        }
        if (frequency.highBound() < 0 || frequency.lowBound() < 0 || frequency.lowBound() > frequency.highBound()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("malformed.frequency", new Object[0])));
        }
    }

    private void check(AbstractExpression.Predicate.Recency recency, AbstractExpression.Predicate.Period period, Feature feature, int line) {
        if (recency == null) {
            return;
        }
        if (period == null) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("recency.without.period", new Object[0])));
        } else if (period.i$(AbstractExpression.Predicate.FromNow.class) && ((AbstractExpression.Predicate.FromNow)period.a$(AbstractExpression.Predicate.FromNow.class)).amount() < recency.amount()) {
            this.errors.add(new SemanticException.SemanticError(line, 1, this.message("recency.out.of.period", new Object[0])));
        }
    }

    private String message(String key, Object ... parameters) {
        return MessageFormat.format(new String(this.messages.getString(key).getBytes(), StandardCharsets.UTF_8), parameters);
    }
}

