/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.setql;

import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.MessageProvider;
import io.intino.sezzet.setql.SetqlChecker;
import io.intino.sezzet.setql.SetqlParser;
import io.intino.sezzet.setql.SetqlSugarFree;
import io.intino.sezzet.setql.exceptions.SemanticException;
import io.intino.sezzet.setql.exceptions.SyntaxException;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.tara.magritte.Graph;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class SetQL {
    public static SetqlGraph parseAndResolve(String input, Locale locale, SezzetGraph sezzet) {
        SetqlGraph graph = (SetqlGraph)new Graph().loadStashes(new String[]{"Setql"}).as(SetqlGraph.class);
        try {
            SetqlParser parser = new SetqlParser(input, locale);
            parser.parse(graph);
            new SetqlChecker(sezzet, locale).check(graph);
            new SetqlSugarFree(sezzet).free(graph);
            return graph;
        }
        catch (SyntaxException e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SemanticException e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String toString(AbstractExpression.Predicate self, Locale locale) {
        return self.property() + "(" + String.join((CharSequence)", ", self.argumentList().stream().map(a -> a.toString(locale)).collect(Collectors.toList())) + ")" + SetQL.separator(self) + SetQL.modifier(self.modifier(), locale) + SetQL.periodString(self, locale) + SetQL.frequencyString(self, locale) + SetQL.recencyString(self, locale);
    }

    public static String toString(AbstractExpression.Predicate.VariableOperation self, Locale locale) {
        return SetQL.toString(self);
    }

    public static String toString(AbstractExpression.Predicate.VariableOperation self) {
        StringBuilder builder = new StringBuilder("'");
        List<AbstractExpression.Predicate.VariableOperation.Comparison> comparisions = self.comparisonList();
        for (int i = 0; i < comparisions.size(); ++i) {
            if (i > 0) {
                builder.append(" ").append(self.operators().get(i - 1).value()).append(" ");
            }
            AbstractExpression.Predicate.VariableOperation.Comparison comparision = comparisions.get(i);
            builder.append(comparision.variable()).append(" ").append(comparision.comparator()).append(" ").append(comparision.value());
        }
        return builder.append("'").toString();
    }

    public static String toString(AbstractExpression.Predicate.Frequency self, Locale locale) {
        return " " + MessageProvider.message(locale, "frequency", new Object[0]) + SetQL.valuesOf(self.lowBound(), self.highBound());
    }

    public static String toString(AbstractExpression.Predicate.Recency self, Locale locale) {
        return " " + MessageProvider.message(locale, "recency", new Object[0]) + " = " + self.amount() + self.scale().name().toLowerCase().charAt(0) + (self.range().equals((Object)AbstractExpression.Predicate.Recency.Range.Old) ? "" : " " + MessageProvider.message(locale, self.range().name().toLowerCase(), new Object[0]));
    }

    public static String toString(AbstractExpression.Predicate.Range self, Locale locale) {
        String value = SetQL.valuesOf(self.lowBound(), self.highBound()).trim();
        return value.startsWith("=") ? value.substring(2) : value;
    }

    public static String toString(AbstractExpression.Predicate.FromNow self, Locale locale) {
        return " " + MessageProvider.message(locale, "period", new Object[0]) + " = " + self.amount() + self.scale().name().toLowerCase().charAt(0);
    }

    private static String modifier(AbstractExpression.Predicate.Modifier modifier, Locale locale) {
        if (modifier.equals((Object)AbstractExpression.Predicate.Modifier.All)) {
            return "";
        }
        return " " + MessageProvider.message(locale, modifier.name().toLowerCase(), new Object[0]);
    }

    public static String toString(AbstractExpression.Predicate.TimeRange self, Locale locale) {
        return " " + MessageProvider.message(locale, "period", new Object[0]) + " = " + self.from() + ".." + self.to();
    }

    private static String separator(AbstractExpression.Predicate self) {
        return self.modifier() != AbstractExpression.Predicate.Modifier.All || self.recency() != null || self.frequency() != null || self.period() != null ? " ::" : "";
    }

    private static String periodString(AbstractExpression.Predicate self, Locale locale) {
        return self.period() != null ? self.period().toString(locale) : "";
    }

    private static String frequencyString(AbstractExpression.Predicate self, Locale locale) {
        return self.frequency() != null ? self.frequency().toString(locale) : "";
    }

    private static String recencyString(AbstractExpression.Predicate self, Locale locale) {
        return self.recency() != null ? self.recency().toString(locale) : "";
    }

    private static String valuesOf(int lowBound, int highBound) {
        if (lowBound == Integer.MIN_VALUE) {
            return " <= " + highBound;
        }
        if (highBound == Integer.MAX_VALUE) {
            return " >= " + lowBound;
        }
        return " = " + lowBound + ".." + highBound;
    }

    public static Instant fromInstant(AbstractExpression.Predicate.TimeRange self) {
        return SetQL.instantOf(self.from());
    }

    public static Instant toInstant(AbstractExpression.Predicate.TimeRange self) {
        return SetQL.instantOf(self.to());
    }

    private static Instant instantOf(String value) {
        int[] fields = SetQL.toInt(value.split("-"));
        ZonedDateTime time = ZonedDateTime.of(fields[0], fields.length > 1 ? fields[1] : 1, fields.length > 2 ? fields[2] : 1, fields.length > 3 ? fields[3] : 0, fields.length > 4 ? fields[4] : 0, fields.length > 5 ? fields[5] : 0, 0, ZoneId.of("UTC"));
        return Instant.from(time);
    }

    private static int[] toInt(String[] strings) {
        int[] fields = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            fields[i] = Integer.parseInt(strings[i]);
        }
        return fields;
    }
}

