/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box.displays;

import io.intino.alexandria.ui.displays.AlexandriaStamp;
import io.intino.sezzet.editor.box.SezzetExpressionValidator;
import io.intino.sezzet.editor.box.displays.CodeSuggester;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorNotifier;
import io.intino.sezzet.editor.box.schemas.ChangeParameters;
import io.intino.sezzet.editor.box.schemas.Setup;
import io.intino.sezzet.editor.box.schemas.SuggestParameters;
import io.intino.sezzet.editor.box.schemas.ValidationItem;
import io.intino.sezzet.model.graph.Feature;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.MessageProvider;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.tara.magritte.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SezzetEditor
extends AlexandriaStamp<SezzetEditorNotifier> {
    private CodeSuggester codeSuggester;
    private List<Consumer<ChangeContext>> listeners = new ArrayList<Consumer<ChangeContext>>();
    private SetqlGraph setql = (SetqlGraph)new Graph().loadStashes(new String[]{"Setql"}).as(SetqlGraph.class);
    private SezzetGraph sezzetGraph;
    private final List<Feature> features;
    private String expression;
    private boolean readonly = false;
    private boolean isExpressionValid = false;

    public SezzetEditor(String dsl) {
        this.sezzetGraph = (SezzetGraph)new Graph().loadStashes(new String[]{"Sezzet", dsl}).as(SezzetGraph.class);
        this.features = this.sezzetGraph.allFeatures();
    }

    public String expression() {
        return this.expression;
    }

    public SezzetEditor expression(String expression) {
        this.expression = expression;
        return this;
    }

    public SezzetEditor readonly(boolean value) {
        this.readonly = value;
        return this;
    }

    public SezzetEditor addListener(Consumer<ChangeContext> listener) {
        this.listeners.add(listener);
        return this;
    }

    protected void init() {
        super.init();
        this.codeSuggester = new CodeSuggester(this.sezzetGraph, this.features, this.locale());
        ((SezzetEditorNotifier)this.notifier).render(new Setup().readonly(this.readonly).features(this.features()).constants(Arrays.asList(this.textFromKey("period"), this.textFromKey("frequency"), this.textFromKey("recency"), this.textFromKey("consecutives"), this.textFromKey("commons"), this.textFromKey("uncommons"), this.textFromKey("old"), this.textFromKey("new"))));
    }

    public void refresh() {
        ((SezzetEditorNotifier)this.notifier).setExpression(this.expression);
        this.validate();
    }

    public void onChange(ChangeParameters params) {
        this.expression = params.expression();
        this.validate();
        this.listeners.forEach(l -> l.accept(this.changeContext(params, this.graph())));
    }

    public boolean isValid() {
        return this.isExpressionValid;
    }

    private ChangeContext changeContext(final ChangeParameters params, final SetqlGraph graph) {
        final String line = this.lineOf(params);
        return new ChangeContext(){

            @Override
            public boolean existsOperator() {
                return !line.startsWith("*");
            }

            @Override
            public String operand() {
                return line;
            }

            @Override
            public Expression expression() {
                return graph == null ? null : graph.expression();
            }

            @Override
            public String rawExpression() {
                return params.expression();
            }

            @Override
            public int lineNumber() {
                return params.cursor().row();
            }
        };
    }

    private String lineOf(ChangeParameters parameters) {
        String[] split = parameters.expression().split("\n");
        int row = parameters.cursor().row();
        if (row >= split.length) {
            return "";
        }
        return split[row].trim();
    }

    private void validate() {
        SezzetExpressionValidator validator = new SezzetExpressionValidator(this.graph(), this.sezzetGraph);
        List<ValidationItem> validationItems = validator.validationItems(this.expression, this.locale());
        this.isExpressionValid = validationItems.isEmpty();
        ((SezzetEditorNotifier)this.notifier).validationResult(validationItems);
    }

    public void onSuggest(SuggestParameters params) {
        ((SezzetEditorNotifier)this.notifier).suggestion(this.codeSuggester.suggest(params.line(), params.cursor()));
    }

    private String textFromKey(String key) {
        return MessageProvider.message((Locale)this.locale(), (String)key, (Object[])new Object[0]);
    }

    private Locale locale() {
        String language = this.session().browser().languageFromMetadata();
        return language.equals("es") || language.equals("mx") ? new Locale("es", "ES") : Locale.ENGLISH;
    }

    private List<String> features() {
        return this.features.stream().map(Feature::label).collect(Collectors.toList());
    }

    private SetqlGraph graph() {
        return (SetqlGraph)this.setql.core$().clone().as(SetqlGraph.class);
    }

    public static interface ChangeContext {
        public boolean existsOperator();

        public String operand();

        public Expression expression();

        public String rawExpression();

        public int lineNumber();
    }
}

