/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box.displays;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.AlexandriaCatalog;
import io.intino.alexandria.ui.displays.AlexandriaDesktop;
import io.intino.alexandria.ui.displays.AlexandriaElementDisplay;
import io.intino.alexandria.ui.displays.AlexandriaPanel;
import io.intino.alexandria.ui.displays.AlexandriaTemporalRangeCatalog;
import io.intino.alexandria.ui.displays.AlexandriaTemporalTimeCatalog;
import io.intino.alexandria.ui.model.Catalog;
import io.intino.alexandria.ui.model.Element;
import io.intino.alexandria.ui.model.Panel;
import io.intino.alexandria.ui.model.TemporalCatalog;
import io.intino.alexandria.ui.model.panel.Desktop;
import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.displays.SezzetEditorHome;
import io.intino.sezzet.editor.box.displays.SezzetEditorMold;
import java.util.HashMap;
import java.util.Map;

public class Displays {
    private static Map<String, ElementDisplayBuilder> displayMap = new HashMap<String, ElementDisplayBuilder>();

    public static AlexandriaElementDisplay displayFor(EditorBox box, String name) {
        if (!displayMap.containsKey(name)) {
            return null;
        }
        return displayMap.get(name).build(box);
    }

    public static AlexandriaElementDisplay displayFor(EditorBox box, Element element) {
        if (!displayMap.containsKey(element.name())) {
            return Displays.defaultElement(box, element);
        }
        return displayMap.get(element.name()).build(box);
    }

    public static <T extends Element> T elementFor(EditorBox box, Class<T> tClass, String name) {
        if (!displayMap.containsKey(name)) {
            return null;
        }
        return (T)displayMap.get(name).build(box).element();
    }

    public static Class<? extends AlexandriaElementDisplay> displayTypeFor(EditorBox box, Element element) {
        if (!displayMap.containsKey(element.name())) {
            return Displays.defaultElementType(box, element);
        }
        return displayMap.get(element.name()).build(box).getClass();
    }

    private static Class<? extends AlexandriaElementDisplay> defaultElementType(EditorBox box, Element element) {
        if (element instanceof Panel) {
            return AlexandriaPanel.class;
        }
        if (element instanceof TemporalCatalog) {
            return ((TemporalCatalog)element).type() == TemporalCatalog.Type.Range ? AlexandriaTemporalRangeCatalog.class : AlexandriaTemporalTimeCatalog.class;
        }
        if (element instanceof Catalog) {
            return AlexandriaCatalog.class;
        }
        if (element instanceof Desktop) {
            return AlexandriaDesktop.class;
        }
        return null;
    }

    private static AlexandriaElementDisplay defaultElement(EditorBox box, Element element) {
        if (element instanceof Panel) {
            return new AlexandriaPanel((Box)box);
        }
        if (element instanceof TemporalCatalog) {
            return ((TemporalCatalog)element).type() == TemporalCatalog.Type.Range ? new AlexandriaTemporalRangeCatalog((Box)box) : new AlexandriaTemporalTimeCatalog((Box)box);
        }
        if (element instanceof Catalog) {
            return new AlexandriaCatalog((Box)box);
        }
        if (element instanceof Desktop) {
            return new AlexandriaDesktop((Box)box);
        }
        return null;
    }

    static {
        displayMap.put("SezzetEditorHome", box -> new SezzetEditorHome(box));
        displayMap.put("SezzetEditorMold", box -> new SezzetEditorMold(box));
    }

    private static interface ElementDisplayBuilder {
        public AlexandriaElementDisplay build(EditorBox var1);
    }
}

