/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box.displays;

import io.intino.alexandria.Base64;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.AlexandriaDesktop;
import io.intino.alexandria.ui.displays.AlexandriaElementDisplay;
import io.intino.alexandria.ui.model.Element;
import io.intino.alexandria.ui.model.Mold;
import io.intino.alexandria.ui.model.Panel;
import io.intino.alexandria.ui.model.View;
import io.intino.alexandria.ui.model.panel.Desktop;
import io.intino.alexandria.ui.model.view.container.Container;
import io.intino.alexandria.ui.model.view.container.MoldContainer;
import io.intino.alexandria.ui.utils.IOUtils;
import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.displays.Displays;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorHomeNotifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSezzetEditorHome
extends AlexandriaDesktop<SezzetEditorHomeNotifier> {
    public AbstractSezzetEditorHome(EditorBox box) {
        super((Box)box);
        this.element((Element)AbstractSezzetEditorHome.buildDesktop(box));
    }

    private static Desktop buildDesktop(final EditorBox box) {
        Desktop desktop = new Desktop();
        desktop.elementDisplayBuilder(new Desktop.ElementDisplayBuilder(){

            public AlexandriaElementDisplay displayFor(Element element, Object o) {
                return this.get(element, o);
            }

            public Class<? extends AlexandriaElementDisplay> displayTypeFor(Element element, Object o) {
                return this.get(element, o).getClass();
            }

            private AlexandriaElementDisplay get(Element element, Object o) {
                return Displays.displayFor(box, element);
            }
        });
        desktop.title("sezzet");
        desktop.subtitle("sezzet predicates editor");
        desktop.logo(AbstractSezzetEditorHome.toBase64(AbstractSezzetEditorHome.class.getResourceAsStream("/no-logo.png")));
        desktop.favicon(AbstractSezzetEditorHome.toBase64(AbstractSezzetEditorHome.class.getResourceAsStream("")));
        desktop.layout(Panel.Layout.Tab);
        AbstractSezzetEditorHome.buildViews(box).forEach(v -> desktop.add(v));
        return desktop;
    }

    private static List<View> buildViews(EditorBox box) {
        ArrayList<View> result = new ArrayList<View>();
        result.add(new View().container((Container)new MoldContainer().mold((Mold)Displays.displayFor(box, "SezzetEditorMold").element())).layout(View.Layout.Tab).width(100).name("7d8e6882-e386-4578-a26b-e89a70eb82ca").label("editor"));
        return result;
    }

    private static String toBase64(InputStream resource) {
        try {
            if (resource == null) {
                return "";
            }
            return "data:image/png;base64," + Base64.encode((byte[])AbstractSezzetEditorHome.toByteArray(resource));
        }
        catch (IOException e) {
            return "";
        }
    }

    private static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)output);
        return output.toByteArray();
    }
}

