/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.datamarts;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.datamarts.ConceptAttribute;
import io.intino.ness.terminal.builder.codegeneration.datamarts.ConceptRenderer;
import io.intino.ness.terminal.builder.codegeneration.datamarts.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityMounterFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    private final String destinationPackage;
    private final String ontologyPackage;
    private final Datamart datamart;

    public EntityMounterFrameFactory(String destinationPackage, String ontologyPackage, Datamart datamart) {
        this.destinationPackage = destinationPackage;
        this.ontologyPackage = ontologyPackage;
        this.datamart = datamart;
    }

    public Map<String, Frame> create(Entity entity) {
        if (entity.isAbstract()) {
            return new HashMap<String, Frame>(0);
        }
        return Map.of(this.getMounterPath(entity, this.destinationPackage), this.frameOf(entity).toFrame());
    }

    private FrameBuilder frameOf(Entity entity) {
        Parameter parent;
        String entityName = StringFormatters.firstUpperCase().format((Object)entity.name$()).toString();
        List<Struct> structList = EntityMounterFrameFactory.structListOf(entity);
        FrameBuilder builder = new FrameBuilder(new String[]{"mounter"}).add("message").add("package", (Object)this.destinationPackage).add("ontologypackage", (Object)this.ontologyPackage).add("datamart", (Object)this.datamart.name$()).add("name", (Object)entity.core$().name()).add("attribute", this.attributesOf(entity).stream().map(this::attrFrameOf).toArray(FrameBuilder[]::new)).add("struct", structList.stream().map(s -> this.structFrameOf((Struct)s, entity.name$(), entity.from().message().name$())).toArray(FrameBuilder[]::new));
        if (!this.datamart.structList().isEmpty()) {
            builder.add("hasStructs", (Object)new FrameBuilder().add("package", (Object)this.destinationPackage));
        }
        builder.add("parent", (Object)((parent = this.parameter(entity.core$(), "entity")) != null ? ((Entity)parent.values().get(0)).name$() : "io.intino.ness.master.model.Entity"));
        builder.add("normalizeId", (Object)new FrameBuilder(new String[]{"normalizeId", entity.isAbstract() || entity.isDecorable() ? "abstract" : ""}).add("package", (Object)this.destinationPackage).add("name", (Object)entityName).toFrame());
        if (entity.isDecorable() || entity.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (entity.isDecorable()) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private static List<Struct> structListOf(Entity entity) {
        Entity parent;
        ArrayList structs = new ArrayList(entity.structList());
        Entity entity2 = parent = entity.isExtensionOf() ? entity.asExtensionOf().entity() : null;
        while (parent != null) {
            structs.addAll(parent.structList());
            parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
        }
        Collections.reverse(structs);
        return structs.stream().distinct().toList();
    }

    private FrameBuilder structFrameOf(Struct struct, String ownerName, String messageEvent) {
        FrameBuilder builder = new FrameBuilder(new String[]{"struct"});
        if (struct.multiple()) {
            builder.add("multiple");
        }
        String fullName = ownerName + DOT + String.valueOf(StringFormatters.firstUpperCase().format((Object)struct.name$()));
        String type = ownerName.contains(DOT) ? ownerName + DOT + String.valueOf(StringFormatters.firstUpperCase().format((Object)struct.name$())) : messageEvent + DOT + String.valueOf(StringFormatters.firstUpperCase().format((Object)struct.name$()));
        builder.add("name", (Object)(ownerName.replace(DOT, "$") + "$" + struct.name$()));
        builder.add("attribName", struct.multiple() ? struct.name$() + "List" : struct.name$());
        builder.add("fullName", (Object)fullName);
        builder.add("type", (Object)type);
        builder.add("typename", StringFormatters.firstUpperCase().format((Object)struct.name$()));
        builder.add("package", (Object)(this.ontologyPackage + ".entities"));
        builder.add("attribute", this.attributesOf(struct, (Object attribute, Node owner) -> this.attributeFromStruct(attribute, (Node)owner, fullName)).stream().map(this::attrFrameOf).toArray(FrameBuilder[]::new));
        builder.add("struct", struct.structList().stream().map(s -> this.structFrameOf((Struct)s, fullName, messageEvent)).toArray(FrameBuilder[]::new));
        return builder;
    }

    private ConceptAttribute attributeFromStruct(Object o, Node node, final String fullName) {
        return new ConceptAttribute(this, o, node){

            @Override
            public String ownerFullName() {
                return fullName;
            }
        };
    }

    public FrameBuilder attrFrameOf(String fullName, ConceptAttribute attr) {
        FrameBuilder builder = ConceptRenderer.super.attrFrameOf(attr);
        if (attr.isWord()) {
            builder.add("type", (Object)(fullName + DOT + Formatters.firstUpperCase(attr.type())));
        }
        return builder;
    }

    @Override
    public Datamart datamart() {
        return this.datamart;
    }

    @Override
    public String workingPackage() {
        return this.ontologyPackage;
    }

    private String getMounterPath(Entity entity, String aPackage) {
        return aPackage + ".mounters." + String.valueOf(StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)(entity.core$().name() + "Mounter")).toString()));
    }
}

