/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.datamarts;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.framework.Node;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.datamarts.ConceptAttribute;
import io.intino.ness.terminal.builder.codegeneration.datamarts.DefaultValueHelper;
import io.intino.ness.terminal.builder.codegeneration.datamarts.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public interface ConceptRenderer {
    public Datamart datamart();

    public String workingPackage();

    default public String structsPackage() {
        return this.workingPackage() + ".structs.";
    }

    default public String entitiesPackage() {
        return this.workingPackage() + ".entities.";
    }

    default public Parameter parameter(Node c, String name) {
        List values = (List)c.variables().get(name);
        return values == null ? null : Parameter.of(values);
    }

    default public List<ConceptAttribute> attributesOf(Struct struct) {
        return this.attributesOf(struct, ConceptAttribute::new);
    }

    default public List<ConceptAttribute> attributesOf(Struct struct, BiFunction<Object, Node, ConceptAttribute> ctor) {
        return struct.attributeList().stream().map(a -> (ConceptAttribute)ctor.apply(a, struct.core$())).collect(Collectors.toList());
    }

    default public List<ConceptAttribute> attributesOf(Entity entity) {
        return this.attributesOf(entity, ConceptAttribute::new);
    }

    default public List<ConceptAttribute> attributesOf(Entity entity, BiFunction<Object, Node, ConceptAttribute> ctor) {
        LinkedHashMap<String, ConceptAttribute> map = new LinkedHashMap<String, ConceptAttribute>();
        Helper.getAttributesFromParents(entity, map, ctor);
        Helper.getAttributesFromEntity(entity, entity.attributeList(), map, false, ctor);
        return new ArrayList<ConceptAttribute>(map.values());
    }

    default public ConceptAttribute attrOf(Node owner, final Struct structAttr) {
        return new ConceptAttribute(this, structAttr, owner){

            @Override
            public String name$() {
                return this.isList() ? super.name$() + "List" : super.name$();
            }

            @Override
            public boolean isList() {
                return structAttr.multiple();
            }

            @Override
            public boolean isStruct() {
                return true;
            }

            @Override
            public boolean shouldAddPackageBeforeName() {
                return false;
            }

            @Override
            public Struct asStruct() {
                return structAttr;
            }
        };
    }

    default public FrameBuilder attrFrameOf(ConceptAttribute attr) {
        FrameBuilder builder = new FrameBuilder().add("attribute");
        attr.conceptList().forEach(aspect -> builder.add(aspect.name()));
        Object owner = attr.owner();
        if (owner.is(Entity.Abstract.class) || owner.is(Entity.Decorable.class)) {
            builder.add("castToSubclass", (Object)("(" + owner.name() + ")"));
        }
        if (attr.inherited()) {
            builder.add("inherited");
        }
        Object type = attr.type();
        builder.add("typename", type);
        if (attr.isEntity() && attr.shouldAddPackageBeforeName()) {
            type = this.entitiesPackage() + (String)type;
        } else if (attr.isStruct() && attr.shouldAddPackageBeforeName()) {
            type = this.structsPackage() + (String)type;
        } else if (attr.isWord()) {
            type = Formatters.firstUpperCase(attr.ownerFullName()) + "." + (String)type;
        }
        this.handleCollectionType(attr, builder, (String)type);
        builder.add("name", (Object)attr.name$()).add("owner", (Object)owner.name()).add("package", (Object)this.workingPackage()).add("index", (Object)owner.componentList().indexOf(attr.core$())).add("entityOwner", (Object)owner.name());
        this.processParameters(attr.core$(), builder, (String)type);
        return builder;
    }

    private void handleCollectionType(ConceptAttribute attr, FrameBuilder builder, String type) {
        if (attr.isList() || attr.isSet()) {
            String collectionType = attr.isList() ? "List" : "Set";
            builder.add("type", (Object)(collectionType + "<" + type + ">"));
            builder.add("collectionType", (Object)collectionType);
            builder.add("typeParameter", (Object)type);
        } else if (attr.isMap()) {
            builder.add("type", (Object)"Map<String, String>");
            builder.add("collectionType", (Object)"Map");
            builder.add("typeParameter", (Object)type);
        } else {
            builder.add("type", (Object)type);
        }
    }

    private void processParameters(Node node, FrameBuilder builder, String type) {
        Parameter struct;
        Parameter defaultValue;
        Parameter values = this.parameter(node, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(node)) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
        } else {
            builder.add("defaultValue", (Object)"null");
        }
        Parameter format = this.parameter(node, "format");
        if (format != null) {
            builder.add("format", format.values().get(0));
        } else if (type.startsWith("Date")) {
            builder.add("format", (Object)this.defaultFormat(type));
        }
        Parameter entity = this.parameter(node, "entity");
        if (entity != null) {
            String name = ((Entity)entity.values().get(0)).name$();
            builder.add("entity", (Object)name);
            Entity reference = this.datamart().entityList().stream().filter(e -> e.name$().equals(name)).findFirst().orElse(null);
            if (reference != null && reference.core$().conceptList().stream().anyMatch(c -> c.name().equals("Component"))) {
                builder.add("component");
            }
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            Struct structNode = (Struct)struct.values().get(0);
            builder.add("struct", (Object)this.paramStructFrame(structNode)).add("structLength", (Object)String.valueOf(structNode.attributeList().size()));
        }
    }

    private String defaultFormat(String type) {
        return type.equals("Date") ? "dd/MM/yyyy" : "dd/MM/yyyy HH:mm:ss";
    }

    private Frame paramStructFrame(Struct struct) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)struct.core$().name()).add("package", (Object)this.workingPackage()).add("attribute", (Object)this.attributesOf(struct).stream().map(this::attrFrameOf).toArray()).toFrame();
    }

    private String defaultValue(Node c, String type, Parameter defaultValue) {
        return "null";
    }

    private static String defaultValueOf(String type, Parameter defaultValue) {
        if (type.contains("List<")) {
            return "new java.util.ArrayList<>()";
        }
        if (type.contains("Set<")) {
            return "new java.util.HashSet<>()";
        }
        if (type.contains("Map<")) {
            return "new java.util.HashMap<>()";
        }
        return defaultValue.values().get(0).toString();
    }

    public static class Helper {
        private static void getAttributesFromParents(Entity entity, Map<String, ConceptAttribute> map, BiFunction<Object, Node, ConceptAttribute> ctor) {
            if (!entity.isExtensionOf()) {
                return;
            }
            ArrayList<Entity.Attribute> attributes = new ArrayList<Entity.Attribute>();
            Entity parent = entity.asExtensionOf().entity();
            while (parent != null) {
                attributes.addAll(parent.attributeList());
                parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
            }
            Collections.reverse(attributes);
            Helper.getAttributesFromEntity(entity, attributes, map, true, ctor);
        }

        private static void getAttributesFromEntity(Entity entity, List<Entity.Attribute> attributeList, Map<String, ConceptAttribute> attribs, boolean inherited, BiFunction<Object, Node, ConceptAttribute> ctor) {
            attributeList.forEach(a -> attribs.put(a.name$(), ((ConceptAttribute)ctor.apply(a, entity.core$())).inherited(inherited)));
        }
    }
}

