package io.intino.ness.terminal.builder.codegeneration.datamarts.nodes;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class IndicatorImplTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("indicatorNode", "default")), (trigger("nodeimpl"))).output(literal("private class IndicatorNodeImpl implements IndicatorNode {\n\tprivate final String id;\n\tprivate volatile File file;\n\n\tprivate IndicatorNodeImpl(String id, File file) {\n\t\tthis.id = requireNonNull(id);\n\t\tthis.file = file;\n\t}\n\n\t@Override\n\tpublic boolean exists() {\n\t\ttry {\n\t\t\treturn get() != null;\n\t\t} catch(IndicatorNotAvailableException e) {\n\t\t\treturn false;\n\t\t}\n\t}\n\n\t@Override\n\tpublic Indicator get() throws IndicatorNotAvailableException {\n\t\tsynchronized(this) {\n\t\t\ttry {\n\t\t\t\tif (hasLocalAccessToIndicators) return Indicator.load(new java.io.FileInputStream(this.file));\n\t\t\t\treturn downloadFromDatahub();\n\t\t\t} catch(Exception e) {\n\t\t\t\tthrow new IndicatorNotAvailableException(e);\n\t\t\t}\n\t\t}\n\t}\n\n\n\tprivate Indicator downloadFromDatahub() throws Exception {\n\t\tjakarta.jms.Message response = requestResponseFromDatahub(\"get-indicator=\" + id, request(hasLocalAccessToIndicators ? \"path\" : \"download\"));\n    \tif (!response.getBooleanProperty(\"success\")) throw new ReelNotAvailableException(\"Could not get indicator \" + id + \" because datahub returned success=false in the response\");\n    \tif (response instanceof jakarta.jms.TextMessage textResponse) {\n    \t\tfile = getFile(textResponse);\n    \t\thasLocalAccessToIndicators = true;\n    \t\tif (file != null && file.exists()) return loadFile();\n    \t\tfile = null;\n    \t\thasLocalAccessToIndicators = false;\n    \t\tresponse = requestResponseFromDatahub(\"get-indicator=\" + id, request(\"download\"));\n    \t}\n    \tif (!response.getBooleanProperty(\"success\")) throw new ReelNotAvailableException(\"Could not get indicator \" + id + \" because datahub returned success=false in the response\");\n    \treturn readFromBytes((jakarta.jms.BytesMessage) response);\n\t}\n\n\tprivate Indicator readFromBytes(jakarta.jms.BytesMessage m) throws Exception {\n\t\tint messageSize = m.getIntProperty(\"size\");\n\t\tbyte[] bytes = new byte[messageSize];\n\t\tm.readBytes(bytes, messageSize);\n\t\treturn Indicator.load(new ByteArrayInputStream(bytes));\n\t}\n\n\tprivate jakarta.jms.Message request(String mode) throws Exception {\n\t\tActiveMQTextMessage message = new ActiveMQTextMessage();\n\t\tmessage.setText(\"datamart=\" + name() + \";operation=get-indicator;id=\" + id + \";mode=\" + mode);\n\t\treturn message;\n\t}\n\n\tprivate File getFile(jakarta.jms.TextMessage m) {\n\t\ttry {\n\t\t\treturn new File(m.getText());\n\t\t} catch(Exception e) {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate Indicator loadFile() throws Exception {\n\t\treturn Indicator.load(new java.io.FileInputStream(this.file));\n\t}\n}"))
		);
	}
}