package io.intino.ness.terminal.builder.codegeneration.datamarts;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DatamartImplTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("datamart", "message", "impl"))).output(literal("package ")).output(mark("package")).output(literal(";\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.terminal.Connector;\nimport io.intino.ness.master.reflection.*;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.Datamart.Translator;\n\nimport org.apache.activemq.command.ActiveMQTextMessage;\n\nimport java.io.File;\nimport java.util.*;\nimport java.io.*;\nimport java.util.concurrent.atomic.AtomicBoolean;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.LocalDate;\nimport java.time.LocalDateTime;\nimport java.time.Instant;\n\nimport ")).output(mark("ontologypackage")).output(literal(".*;\n\nimport static java.util.Objects.requireNonNull;\n\npublic class ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartImpl implements ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart {\n\n\tprivate static final String DATAHUB_MESSAGE_TOPIC = \"service.ness.datamarts\";\n\tprivate static final ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartImpl.")).output(mark("name", "FirstUpperCase")).output(literal("DatamartDefinition definition = new ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartImpl.")).output(mark("name", "FirstUpperCase")).output(literal("DatamartDefinition();\n\n\t")).output(expression().output(literal("private static final Set<String> TIMELINE_EVENTS = Set.of(")).output(mark("timelineEvents")).output(literal(");"))).output(literal("\n\t")).output(expression().output(literal("private static final Set<String> REEL_EVENTS = Set.of(")).output(mark("reelEvents")).output(literal(");"))).output(literal("\n\n\tprivate final Connector connector;\n\tprivate final ")).output(mark("terminal")).output(literal(".DatamartsRetryConfig retryConfig;\n\tprivate final List<EntityListener> entityListeners = new ArrayList<>();\n\tprivate final Map<String, List<MasterMounter>> mounters = new HashMap<>();\n\tprivate final ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart.Entities entities;\n\tprivate Instant ts;\n\t")).output(expression().output(mark("hasTimelines")).output(literal("private boolean hasLocalAccessToTimelines;"))).output(literal("\n\t")).output(expression().output(mark("hasTimelines")).output(literal("private final Map<String, TimelineNodeImpl> timelines = new java.util.concurrent.ConcurrentHashMap<>();"))).output(literal("\n\t")).output(expression().output(mark("hasTimelines")).output(literal("private boolean hasLocalAccessToIndicators;"))).output(literal("\n\t")).output(expression().output(mark("hasTimelines")).output(literal("private final Map<String, IndicatorNodeImpl> indicators = new java.util.concurrent.ConcurrentHashMap<>();"))).output(literal("\n\t")).output(expression().output(mark("hasReels")).output(literal("private boolean hasLocalAccessToReels;"))).output(literal("\n\t")).output(expression().output(mark("hasReels")).output(literal("private final Map<String, ReelNodeImpl> reels = new java.util.concurrent.ConcurrentHashMap<>();"))).output(literal("\n\tprivate volatile Translator translator = new Translator.Identity();\n\tprivate volatile boolean initializing = false;\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartImpl(Connector connector, ")).output(mark("terminal")).output(literal(".DatamartsRetryConfig retryConfig) {\n\t\tthis.connector = requireNonNull(connector);\n\t\tthis.retryConfig = requireNonNull(retryConfig);\n\t\tthis.entities = new ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart.Entities(this);\n\t\tinitMounters();\n\t}\n\n\tpublic synchronized ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartImpl init(String datamartSourceSelector) {\n\t\ttry {\n\t\t\tinitializing = true;\n\t\t\tdownloadDatamartFromDatahub(datamartSourceSelector);\n\t\t\tLogger.info(\"")).output(mark("name", "FirstUpperCase")).output(literal("Datamart (\" + (snapshotTimetag().isEmpty() ? \"\" : \"snapshot \" + snapshotTimetag() + \", \")  + connector.clientId() + \") initialized successfully.\");\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"")).output(mark("name", "FirstUpperCase")).output(literal("Datamart failed to start because a \" + e.getClass().getName() + \" occurred: \" + e.getMessage());\n\t\t} finally {\n\t\t\tinitializing = false;\n\t\t}\n\t\treturn this;\n\t}\n\n\tpublic boolean requiresDatahubNotifications() {\n\t\treturn true;\n\t}\n\n\t@Override\n\tpublic int size() {\n\t\treturn entities.size();\n\t}\n\n\t@Override\n\tpublic int sizeDisabled() {\n\t\treturn entities.sizeDisabled();\n\t}\n\n\t@Override\n\t@SuppressWarnings(\"unchecked\")\n\tpublic <T extends Entity> T get(String id) {\n\t\treturn (T) entities.get(id);\n\t}\n\n\t@Override\n\tpublic Stream<Entity> entities() {\n\t\treturn entities.streamGeneric();\n\t}\n\n\t@Override\n\tpublic void addEntityListener(EntityListener listener) {\n\t\tif (listener == null) throw new NullPointerException(\"EntityListener cannot be null\");\n\t\tentityListeners.add(listener);\n\t}\n\n\t@Override\n\tpublic DatamartDefinition getDefinition() {\n\t\treturn definition;\n\t}\n\n\t@Override\n    public List<String> listSnapshots() {\n    \ttry {\n    \t\tjakarta.jms.Message message = requestResponseFromDatahub(\"listSnapshots\", listSnapshotsRequest());\n    \t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n    \t\treturn handleListSnapshotsResponse(message);\n    \t} catch (Exception e) {\n    \t\tLogger.error(\"Could not download list of available snapshots: \" + e.getMessage(), e);\n    \t\treturn java.util.Collections.emptyList();\n    \t}\n    }\n\n    private jakarta.jms.Message listSnapshotsRequest() throws Exception {\n    \tActiveMQTextMessage message = new ActiveMQTextMessage();\n    \tmessage.setText(\"datamart=\" + name() + \";operation=snapshots\");\n    \treturn message;\n    }\n\n    private List<String> handleListSnapshotsResponse(jakarta.jms.Message message) throws Exception {\n    \treturn java.util.Arrays.stream(((jakarta.jms.TextMessage) message).getText().split(\",\")).collect(Collectors.toList());\n    }\n\n    @Override\n    public synchronized ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart snapshot(String timetag) {\n    \tif (timetag == null) return this;\n    \treturn new ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartImpl(connector, retryConfig) {\n    \t\t@Override\n    \t\tprotected String snapshotTimetag() {\n    \t\t\treturn timetag;\n    \t\t}\n    \t\t@Override\n    \t\tpublic synchronized MasterDatamart snapshot(String timetag) {\n    \t\t\tthrow new java.lang.UnsupportedOperationException(\"Cannot request snapshots to snapshot instances of a datamart\");\n    \t\t}\n    \t}.init(null);\n\t}\n\n    public Instant ts() {\n    \treturn this.ts;\n    }\n\n\t")).output(expression().output(mark("entity", "getter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("hasTimelines", "timelinesByIdMethod"))).output(literal("\n\t")).output(expression().output(mark("timeline", "getter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("hasReels", "reelsByIdMethod"))).output(literal("\n\t")).output(expression().output(mark("reel", "getter").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(mark("indicator", "getter").multiple("\n\n"))).output(literal("\n\n\t@Override\n\tpublic Translator translator() {\n\t\treturn translator;\n\t}\n\n\t@Override\n\tpublic void translator(Translator translator) {\n\t\tthis.translator = translator;\n\t}\n\n\tprivate void downloadDatamartFromDatahub(String datamartSourceSelector) throws DatahubRequestException {\n\t\tif (connector instanceof io.intino.alexandria.terminal.StubConnector) return;\n\t\tLogger.debug(\"Downloading datamart from datahub...\");\n\t\tlong start = java.lang.System.currentTimeMillis();\n\n\t\tLogger.debug(\"Downloading entities...\");\n\t\tint[] eventCount = new int[1];\n\t\tloadEntitiesFromEvents(downloadEntities(eventCount, datamartSourceSelector), eventCount);\n\n\t\t")).output(expression().output(mark("hasTimelines")).output(literal("loadTimelinesFromDatahub();"))).output(literal("\n\t\t")).output(expression().output(mark("hasTimelines")).output(literal("loadIndicatorsFromDatahub();"))).output(literal("\n\n\t\t")).output(expression().output(mark("hasReels")).output(literal("loadReelsFromDatahub();"))).output(literal("\n\n\t\tlong time = java.lang.System.currentTimeMillis() - start;\n\t\tLogger.debug(\"Datamart downloaded from datahub after \" + time + \" ms\");\n\t}\n\n\t")).output(expression().output(mark("hasTimelines", "loadTimelinesFromDatahubMethod"))).output(literal("\n\t")).output(expression().output(mark("hasTimelines", "loadIndicatorsFromDatahubMethod"))).output(literal("\n\n\t")).output(expression().output(mark("hasReels", "loadReelsFromDatahubMethod"))).output(literal("\n\n\tprivate Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) throws DatahubRequestException {\n\t\ttry {\n\t\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"downloadEvents\", downloadEntitiesRequest(datamartSourceSelector));\n\t\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\t\treturn handleDownloadResponse(message, eventCount);\n\t\t} catch (NullPointerException e) {\n\t\t\tthrow new DatahubRequestException(\"Could not download datamart: no response from datahub.\");\n\t\t} catch(DatahubRequestException e) {\n\t\t\tthrow e;\n\t\t} catch (Exception e) {\n\t\t\tthrow new DatahubRequestException(\"Could not download datamart: \" + e.getMessage());\n\t\t}\n\t}\n\n\tprivate jakarta.jms.Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {\n\t\tActiveMQTextMessage message = new ActiveMQTextMessage();\n\t\tmessage.setText(\"datamart=\" + name() +\n\t\t\t\";operation=entities\" +\n\t\t\t(snapshotTimetag().isEmpty() ? \"\" : \";timetag=\" + snapshotTimetag()) +\n\t\t\t(datamartSourceSelector == null ? \"\" : \";sourceSelector=\" + datamartSourceSelector)\n\t\t);\n\t\treturn message;\n\t}\n\n\tprotected String snapshotTimetag() {\n\t\treturn \"\";\n\t}\n\n\tprivate Stream<Event> handleDownloadResponse(jakarta.jms.Message message, int[] eventCount) throws Exception {\n\t\tjakarta.jms.BytesMessage m = (jakarta.jms.BytesMessage) message;\n\t\teventCount[0] = m.getIntProperty(\"size\");\n\t\tint size = m.getIntProperty(\"size\");\n\t\tbyte[] bytes = new byte[size];\n\t\tm.readBytes(bytes, size);\n\t\treturn io.intino.alexandria.zim.ZimStream.of(new java.io.ByteArrayInputStream(bytes)).map(io.intino.alexandria.event.message.MessageEvent::new);\n\t}\n\n\tprivate void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {\n\t\tevents.forEach(this::mount);\n\t}\n\n\tpublic synchronized void mount(Event event) {\n\t\ttry {\n\t\t\tif (event == null) return;\n        \tthis.ts = event.ts();\n        \tmountEntities(event);\n\t\t} catch(Throwable e) {\n\t\t\tLogger.error(\"Error while mounting event ss=\" + event.ss() + \", ts=\" + event.ts() + \" -> \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\tpublic synchronized void handleDatahubNotification(String notification) {\n\t\ttry {\n\t\t\tif(notification == null || notification.isBlank()) return;\n\t\t\tString[] typeAndSs = notification.split(\"\\0\");\n    \t\t")).output(expression().output(mark("hasTimelines")).output(literal("handleTimelineNotification(typeAndSs")).output(literal("[")).output(literal("0")).output(literal("]")).output(literal(", typeAndSs")).output(literal("[")).output(literal("1")).output(literal("]")).output(literal(");"))).output(literal("\n    \t\t")).output(expression().output(mark("hasReels")).output(literal("handleReelNotification(typeAndSs")).output(literal("[")).output(literal("0")).output(literal("]")).output(literal(", typeAndSs")).output(literal("[")).output(literal("1")).output(literal("]")).output(literal(");"))).output(literal("\n\t\t} catch(Throwable e) {\n\t\t\tLogger.error(\"Error while processing datahub notification \" + notification + \": \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\t")).output(expression().output(mark("hasReels")).output(literal("private void handleReelNotification(String type, String id) {")).output(literal("\n")).output(literal("\tif (!REEL_EVENTS.contains(type)) return;")).output(literal("\n")).output(literal("\tString key = normalizedId(id, type);")).output(literal("\n")).output(literal("\tReelNodeImpl reel = reels.computeIfAbsent(key, k -> new ReelNodeImpl(id, type, null));")).output(literal("\n")).output(literal("\treel.notifyChange();")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(mark("hasTimelines")).output(literal("private void handleTimelineNotification(String type, String id) {")).output(literal("\n")).output(literal("\tif (!TIMELINE_EVENTS.contains(type)) return;")).output(literal("\n")).output(literal("\tString key = normalizedId(id, type);")).output(literal("\n")).output(literal("\tTimelineNodeImpl timeline = timelines.computeIfAbsent(key, k -> new TimelineNodeImpl(id, type, null));")).output(literal("\n")).output(literal("\ttimeline.notifyChange();")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\tprivate String normalizedId(String id, String type) {\n\t\treturn id.replace(\":\", \"-\") + \":\" + type;\n\t}\n\n\tprivate void mountEntities(Event event) {\n\t\ttry {\n\t\t\tList<")).output(mark("name", "FirstUpperCase")).output(literal("Mounter> mounters = this.mounters.get(event.type());\n\t\t\tif(mounters == null) return;\n\t\t\tmounters.forEach(mounter -> mounter.useListeners(!initializing).mount(event));\n\t\t} catch (Exception e) {\n\t\t\tLogger.error(\"Failed to mount event of type \" + event.type() + \": \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\tprivate void initMounters() {\n\t\t")).output(expression().output(mark("entity", "registerMounter").multiple("\n"))).output(literal("\n\t}\n\n\tprivate static int availableThreads() {\n\t\treturn Runtime.getRuntime().availableProcessors();\n\t}\n\n\tprivate jakarta.jms.Message requestResponseFromDatahub(String requestName, jakarta.jms.Message request) throws DatahubRequestException {\n    \tlong timeout = retryConfig.initialTimeoutAmount;\n    \tfor(int i = 0; i < retryConfig.maxAttempts; i++) {\n    \t\tjakarta.jms.Message message = connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, retryConfig.timeoutUnit);\n    \t\tif (message != null) return message;\n    \t\tif (i < retryConfig.maxAttempts - 1) Logger.warn(\"(\"+(i+1)+\") Datahub did not respond after \" + timeout + \" \" + retryConfig.timeoutUnit + \" to the request '\" + requestName + \"'. Trying again...\");\n    \t\ttimeout *= retryConfig.timeoutMultiplier;\n    \t}\n    \tthrow new DatahubRequestException(\"Datahub did not respond to the request '\" + requestName + \"' after \" + retryConfig.maxAttempts);\n    }\n\n\t")).output(expression().output(mark("timelineNode", "nodeImpl"))).output(literal("\n\n\t")).output(expression().output(mark("reelNode", "nodeImpl"))).output(literal("\n\n\t")).output(expression().output(mark("indicatorNode", "nodeImpl"))).output(literal("\n\n\tprivate static Set<String> sourcesOfTimeline(String type) {\n    \treturn switch(type) {\n    \t\t")).output(expression().output(mark("timeline", "sourcesSwitchCase").multiple("\n"))).output(literal("\n    \t\tdefault -> java.util.Collections.emptySet();\n    \t};\n    }\n\n\tprivate static Set<String> sourcesOfReel(String type) {\n    \treturn switch(type) {\n    \t\t")).output(expression().output(mark("reel", "sourcesSwitchCase").multiple("\n"))).output(literal("\n    \t\tdefault -> java.util.Collections.emptySet();\n    \t};\n    }\n\n\tpublic static final class ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartDefinition implements DatamartDefinition {\n\n\t\t@Override\n\t\tpublic String name() {\n\t\t\treturn \"")).output(mark("name")).output(literal("\";\n\t\t}\n\n\t\t@Override\n\t\tpublic Scale scale() {\n\t\t\treturn Scale.")).output(mark("scale")).output(literal(";\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {\n\t\t\treturn new Query<EntityDefinition>(List.of(")).output(expression().output(mark("entity", "definition").multiple(","))).output(literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {\n\t\t\treturn new Query<StructDefinition>(List.of(")).output(expression().output(mark("struct", "definition").multiple(","))).output(literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String name) {\n\t\t\tswitch(name) {\n\t\t\t\t")).output(expression().output(mark("entity", "defSwitchCase").multiple("\n"))).output(literal("\n\t\t\t}\n\t\t\treturn Optional.empty();\n\t\t}\n\n\t\t@Override\n    \tpublic Optional<StructDefinition> struct(String name) {\n    \t\tswitch(name) {\n    \t\t\t")).output(expression().output(mark("struct", "defSwitchCase").multiple("\n"))).output(literal("\n    \t\t}\n    \t\treturn Optional.empty();\n    \t}\n\n\t\tprivate ")).output(mark("name", "FirstUpperCase")).output(literal("DatamartDefinition datamart() {\n\t\t\treturn this;\n\t\t}\n\n\t\t")).output(expression().output(mark("entity", "declareDefinition").multiple("\n"))).output(literal("\n\n        ")).output(expression().output(mark("struct", "declareDefinition").multiple("\n"))).output(literal("\n\t}\n\n\tstatic {\n\t\ttry {\n\t\t\tObject ref = ")).output(mark("name", "firstUpperCase")).output(literal("Datamart.class.getDeclaredField(\"definition\").get(null);\n\t\t\tjava.lang.reflect.Field field = ref.getClass().getDeclaredField(\"definition\");\n\t\t\tfield.setAccessible(true);\n\t\t\tfield.set(ref, definition);\n\t\t\tfield.setAccessible(false);\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"Could not set ")).output(mark("name", "firstUpperCase")).output(literal("Datamart.definition field\");\n\t\t}\n\t}\n}")),
			rule().condition((type("entity")), (trigger("definition"))).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition")),
			rule().condition((type("struct")), (trigger("definition"))).output(mark("fullName", "firstLowerCase")).output(literal("StructDefinition")),
			rule().condition((type("entity")), (trigger("defswitchcase"))).output(literal("case \"")).output(mark("name", "FirstUpperCase")).output(literal("\": return Optional.of(")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition);")),
			rule().condition((type("struct")), (trigger("defswitchcase"))).output(literal("case \"")).output(mark("fullName", "FirstUpperCase")).output(literal("\": return Optional.of(")).output(mark("fullName", "firstLowerCase")).output(literal("StructDefinition);")),
			rule().condition((type("entity")), (trigger("declaredefinition"))).output(literal("public final EntityDefinition ")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition = new EntityDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")).output(mark("fullName")).output(literal("\";}\n\tpublic String name() {return \"")).output(mark("name")).output(literal("\";}\n\tpublic boolean isAbstract() {return ")).output(mark("isAbstract")).output(literal(";}\n\tpublic List<AttributeDefinition> declaredAttributes() {\treturn declaredAttributes;}\n\tpublic Optional<EntityDefinition> parent() {return ")).output(expression().output(literal("Optional.of(")).output(mark("parent", "firstLowerCase")).output(literal("EntityDefinition)")).next(expression().output(literal("Optional.empty()")))).output(literal(";}\n\tpublic List<EntityDefinition> ancestors() {return java.util.List.of(")).output(expression().output(mark("ancestor", "definition").multiple(","))).output(literal(");}\n\tpublic List<EntityDefinition> descendants() {return java.util.List.of(")).output(expression().output(mark("descendant", "definition").multiple(","))).output(literal(");}\n\tpublic Class<?> javaClass() {return ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>();\n\t\t")).output(expression().output(mark("hasNoParents", "addIdAndEnabledAttributes"))).output(literal("\n    \t")).output(expression().output(mark("attribute", "addDefinition").multiple("\n"))).output(literal("\n    \treturn Collections.synchronizedList(list);\n\t}\n\tpublic boolean equals(Object other) {\n\t\tif (other == null || other.getClass() != getClass()) return false;\n\t\treturn fullName().equals(((EntityDefinition)other).fullName());\n\t}\n\tpublic int hashCode() {return fullName().hashCode();}\n\tpublic String toString() {return fullName();}\n};")),
			rule().condition((type("struct")), (trigger("declaredefinition"))).output(literal("public final StructDefinition ")).output(mark("fullName", "firstLowerCase")).output(literal("StructDefinition = new StructDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")).output(mark("fullName")).output(literal("\";}\n\tpublic String name() {return \"")).output(mark("name")).output(literal("\";}\n\tpublic List<AttributeDefinition> declaredAttributes() {return declaredAttributes;}\n\tpublic Optional<StructDefinition> parent() {return ")).output(expression().output(literal("Optional.of(")).output(mark("parent", "firstLowerCase")).output(literal("StructDefinition)")).next(expression().output(literal("Optional.empty()")))).output(literal(";}\n\tpublic List<StructDefinition> ancestors() {return java.util.List.of(")).output(expression().output(mark("ancestor", "definition").multiple(","))).output(literal(");}\n\tpublic List<StructDefinition> descendants() {return java.util.List.of(")).output(expression().output(mark("descendant", "definition").multiple(","))).output(literal(");}\n\tpublic Class<?> javaClass() {return ")).output(mark("package")).output(literal(".")).output(mark("name", "FirstUpperCase")).output(literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>(")).output(mark("numAttributes")).output(literal(");\n    \t")).output(expression().output(mark("attribute", "addDefinition").multiple("\n"))).output(literal("\n    \treturn Collections.synchronizedList(list);\n\t}\n\tpublic boolean equals(Object other) {\n    \tif (other == null || other.getClass() != getClass()) return false;\n    \treturn fullName().equals(((StructDefinition)other).fullName());\n    }\n    public int hashCode() {return fullName().hashCode();}\n    public String toString() {return fullName();}\n};")),
			rule().condition((type("subclass")), (trigger("name"))).output(literal("\"")).output(mark("name", "FirstUpperCase")).output(literal("\"")),
			rule().condition((type("entity")), (anyTypes("descendant","ancestor")), (trigger("definition"))).output(mark("name", "FirstUpperCase")).output(literal("EntityDefinition")),
			rule().condition((type("struct")), (anyTypes("descendant","ancestor")), (trigger("definition"))).output(mark("name", "FirstUpperCase")).output(literal("StructDefinition")),
			rule().condition((trigger("addidandenabledattributes"))).output(literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"id\";}\n\tpublic Class<?> type() {return String.class;}\n\tpublic String toString() {return name();}\n});\nlist.add(new AttributeDefinition() {\n\tpublic String name() {return \"enabled\";}\n\tpublic Class<?> type() {return Boolean.class;}\n\tpublic String toString() {return name();}\n});")),
			rule().condition((type("attribute")), not(type("inherited")), (type("collection")), (trigger("adddefinition"))).output(literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")).output(mark("name", "firstLowerCase")).output(literal("\";}\n\tpublic Class<?> type() {return ")).output(mark("type")).output(literal(".class;}\n\tpublic String toString() {return name();}\n\tpublic List<ParameterDefinition> parameters() {\n\t\treturn List.of(new ParameterDefinition() {\n\t\t\tpublic Optional<ConceptDefinition<?>> asConceptDefinition() {return ")).output(mark("parameter", "asConceptDefinition")).output(literal(";}\n\t\t\tpublic Class<?> javaClass() {return ")).output(mark("parameterType")).output(literal(".class;}\n\t\t\tpublic String toString() {return javaClass().getSimpleName();}\n\t\t});\n\t}\n});")),
			rule().condition((type("attribute")), not(type("inherited")), (trigger("adddefinition"))).output(literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")).output(mark("name", "firstLowerCase")).output(literal("\";}\n\tpublic Class<?> type() {return ")).output(mark("type")).output(literal(".class;}\n\tpublic String toString() {return name();}\n});")),
			rule().condition((type("parameter")), (type("entity")), (trigger("asconceptdefinition"))).output(literal("Optional.of(datamart().")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition)")),
			rule().condition((type("parameter")), (type("struct")), (trigger("asconceptdefinition"))).output(literal("Optional.of(datamart().")).output(mark("name", "firstLowerCase")).output(literal("StructDefinition)")),
			rule().condition((type("parameter")), (trigger("asconceptdefinition"))).output(literal("Optional.empty()")),
			rule().condition(not(type("abstract")), (type("entity")), (trigger("registermounter"))).output(literal("mounters.computeIfAbsent(\"")).output(mark("event", "firstUpperCase")).output(literal("\", type -> new ArrayList<>(1)).add(new ")).output(mark("package")).output(literal(".mounters.")).output(mark("name", "FirstUpperCase")).output(literal("Mounter(entities, entityListeners));")),
			rule().condition((type("subclasstop")), (trigger("getallstream"))).output(mark("name", "Plural", "firstLowerCase")).output(literal("()")),
			rule().condition((type("subclasstop")), (trigger("getallstreamdisabled"))).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled()")),
				rule().condition((type("timeline")), (trigger("getter"))).output(literal("@Override\npublic TimelineNode ")).output(mark("name", "FirstLowerCase")).output(literal("Timeline(String id) {\n\tString key = normalizedId(id, \"")).output(mark("name")).output(literal("\");\n\tif (timelines.containsKey(key)) return timelines.get(key);\n\tif (!hasLocalAccessToTimelines) return timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, \"")).output(mark("name")).output(literal("\"));\n\treturn TimelineNode.empty();\n}")),
				rule().condition((type("reel")), (trigger("getter"))).output(literal("@Override\npublic ReelNode ")).output(mark("name", "FirstLowerCase")).output(literal("Reel(String id) {\n\tString key = normalizedId(id, \"")).output(mark("name")).output(literal("\");\n\tif (reels.containsKey(key)) return reels.get(key);\n\tif (!hasLocalAccessToReels) return reels.computeIfAbsent(key, theId -> new ReelNodeImpl(id, \"")).output(mark("name")).output(literal("\"));\n\treturn ReelNode.empty();\n}\n\n@Override\npublic Stream<ReelNode> ")).output(mark("name", "FirstLowerCase")).output(literal("Reels() {\n\tStream stream = reels.values().stream().filter(r -> r.type.equals(\"")).output(mark("name")).output(literal("\")).toList().stream();\n\treturn stream;\n}")),
			rule().condition((type("indicator")), (trigger("getter"))).output(literal("@Override\npublic IndicatorNode ")).output(mark("label", "FirstLowerCase")).output(literal("Indicator() {\n\tif (hasLocalAccessToIndicators) return indicators.containsKey(\"")).output(mark("name")).output(literal("\") ? indicators.get(\"")).output(mark("name")).output(literal("\") : IndicatorNode.empty();\n\treturn indicators.computeIfAbsent(\"")).output(mark("name")).output(literal("\", theId -> new IndicatorNodeImpl(\"")).output(mark("name")).output(literal("\", null));\n}")),
				rule().condition((trigger("timelinesbyidmethod"))).output(literal("@Override\npublic Stream<TimelineNode> timelines(String id) {\n\tString key = id.replace(\":\", \"-\");\n\tStream stream = timelines.values().stream().filter(t -> t.id.equals(key)).toList().stream();\n\treturn stream;\n}")),
				rule().condition((trigger("reelsbyidmethod"))).output(literal("@Override\npublic Stream<ReelNode> reels(String id) {\n\tString key = id.replace(\":\", \"-\");\n\tStream stream = reels.values().stream().filter(r -> r.id.equals(key)).toList().stream();\n\treturn stream;\n}")),
			rule().condition((trigger("sourcesswitchcase"))).output(literal("case \"")).output(mark("name")).output(literal("\" -> Set.of(")).output(mark("sources")).output(literal(");")),
			rule().condition((type("abstract")), (trigger("getter"))).output(literal("@Override\npublic ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(String id) {\n\treturn id == null ? null : entities.getDescendant(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition, id);\n}\n\n@Override\npublic ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("Disabled(String id) {\n\treturn id == null ? null : entities.getDescendantDisabled(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("() {\n\treturn Stream.of(\n\t\t")).output(mark("subclasstop", "getAllStream").multiple(",\n")).output(literal("\n\t).<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(">flatMap(java.util.function.Function.identity());\n}\n\n@Override\npublic Stream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled() {\n\treturn Stream.of(\n\t\t")).output(mark("subclasstop", "getAllStreamDisabled").multiple(",\n")).output(literal("\n\t).<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(">flatMap(java.util.function.Function.identity());\n}")),
			rule().condition((type("superclass")), not(type("abstract")), (trigger("getter"))).output(literal("@Override\npublic ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(String id) {\n\treturn id == null ? null : entities.getDescendant(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition, id);\n}\n\n@Override\npublic ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("Disabled(String id) {\n\treturn id == null ? null : entities.getDescendantDisabled(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("() {\n\treturn Stream.of(\n\t\tentities.<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(">stream(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition),\n\t\t")).output(mark("subclasstop", "getAllStream").multiple(",\n")).output(literal("\n\t).<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(">flatMap(java.util.function.Function.identity());//.distinct();\n}\n\n@Override\npublic Stream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled() {\n\treturn Stream.of(\n\t\tentities.<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(">streamDisabled(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition),\n\t\t")).output(mark("subclasstop", "getAllStreamDisabled").multiple(",\n")).output(literal("\n\t).<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(">flatMap(java.util.function.Function.identity());\n}")),
			rule().condition((trigger("getter"))).output(literal("@Override\npublic ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(String id) {\n\treturn id == null ? null : entities.get(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition, id);\n}\n\n@Override\npublic ")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("Disabled(String id) {\n\treturn id == null ? null : entities.getDisabled(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("() {\n\treturn entities.stream(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition);\n}\n\n@Override\npublic Stream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled() {\n\treturn entities.streamDisabled(definition.")).output(mark("name", "firstLowerCase")).output(literal("EntityDefinition);\n}")),
			rule().condition((trigger("loadtimelinesfromdatahubmethod"))).output(literal("private void loadTimelinesFromDatahub() {\n\tLogger.debug(\"Downloading timelines...\");\n\tBoolean hasLocalAccessToTimelines = null;\n    for(String filename : listTimelineFiles()) {\n    \tif (filename == null || filename.isBlank()) continue;\n    \ttry {\n           \tFile file = new File(filename);\n           \tString id = file.getName().replace(\".timeline\", \"\");\n           \tString type = file.getParentFile().getName();\n           \tTimelineNodeImpl node = new TimelineNodeImpl(id, type, file.exists() ? file : null);\n           \ttimelines.put(id + \":\" + type, node);\n           \tif (hasLocalAccessToTimelines == null) hasLocalAccessToTimelines = file.exists();\n           \telse hasLocalAccessToTimelines &= file.exists();\n        } catch (Exception e) {\n           \tLogger.debug(\"Could not load timeline \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n        }\n    }\n    this.hasLocalAccessToTimelines = hasLocalAccessToTimelines != null && hasLocalAccessToTimelines;\n    Logger.debug(\"Loaded \" + timelines.size() + \" timelines (hasLocalAccessToTimelines=\" + this.hasLocalAccessToTimelines + \")\");\n}\n\nprivate String[] listTimelineFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-timelines;\");\n\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"list-timelines\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\treturn ((jakarta.jms.TextMessage) message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")),
			rule().condition((trigger("loadindicatorsfromdatahubmethod"))).output(literal("private void loadIndicatorsFromDatahub() {\n\tLogger.debug(\"Downloading indicators...\");\n\tBoolean hasLocalAccessToIndicators = null;\n    for(String filename : listIndicatorFiles()) {\n\t\tif (filename == null || filename.isBlank()) continue;\n\t\ttry {\n\t\t\tFile file = new File(filename);\n\t\t\tString id = file.getName().replace(\".indicator\", \"\");\n\t\t\tIndicatorNodeImpl node = new IndicatorNodeImpl(id, file.exists() ? file : null);\n\t\t\tindicators.put(id, node);\n\t\t\tif (hasLocalAccessToIndicators == null) hasLocalAccessToIndicators = file.exists();\n\t\t\telse hasLocalAccessToIndicators &= file.exists();\n\t\t} catch (Exception e) {\n\t\t\tLogger.debug(\"Could not load indicator \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n\t\t}\n\t}\n\tthis.hasLocalAccessToIndicators = hasLocalAccessToIndicators != null && hasLocalAccessToIndicators;\n\tLogger.debug(\"Loaded \" + indicators.size() + \" indicators (hasLocalAccessToTimelines=\" + this.hasLocalAccessToTimelines + \")\");\n}\n\nprivate String[] listIndicatorFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-indicators;\");\n\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"list-indicators\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\treturn ((jakarta.jms.TextMessage) message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")),
				rule().condition((trigger("loadreelsfromdatahubmethod"))).output(literal("private void loadReelsFromDatahub() {\n\tLogger.debug(\"Downloading reels...\");\n\tBoolean hasLocalAccessToReels = null;\n\tfor(String filename : listReelFiles()) {\n\t\tif (filename == null || filename.isBlank()) continue;\n\t\ttry {\n\t    \tFile file = new File(filename);\n\t    \tString id = file.getName().replace(\".reel\", \"\");\n\t    \tString type = file.getParentFile().getName();\n\t    \tReelNodeImpl node = new ReelNodeImpl(id, type, file.exists() ? file : null);\n\t    \treels.put(id + \":\" + type, node);\n\t    \tif (hasLocalAccessToReels == null) hasLocalAccessToReels = file.exists();\n            else hasLocalAccessToReels &= file.exists();\n\t    } catch (Exception e) {\n\t    \tLogger.debug(\"Could not load reel \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n\t    }\n\t}\n\tthis.hasLocalAccessToReels = hasLocalAccessToReels != null && hasLocalAccessToReels;\n\tLogger.debug(\"Loaded \" + reels.size() + \" reels\");\n}\n\nprivate String[] listReelFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-reels;\");\n\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"list-reels\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\treturn ((jakarta.jms.TextMessage)message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}"))
		);
	}
}