/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.datamarts;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DatamartImplTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"datamart", "message", "impl"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.terminal.Connector;\nimport io.intino.ness.master.reflection.*;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.Datamart.Translator;\n\nimport org.apache.activemq.command.ActiveMQTextMessage;\n\nimport java.io.File;\nimport java.util.*;\nimport java.io.*;\nimport java.util.concurrent.atomic.AtomicBoolean;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.LocalDate;\nimport java.time.LocalDateTime;\nimport java.time.Instant;\n\nimport ")}).output(new Rule.Output[]{this.mark("ontologypackage", new String[0])}).output(new Rule.Output[]{this.literal(".*;\n\nimport static java.util.Objects.requireNonNull;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl implements ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart {\n\n\tprivate static final String DATAHUB_MESSAGE_TOPIC = \"service.ness.datamarts\";\n\tprivate static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition definition = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition();\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("private static final Set<String> TIMELINE_EVENTS = Set.of(")}).output(new Rule.Output[]{this.mark("timelineEvents", new String[0])}).output(new Rule.Output[]{this.literal(");")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("private static final Set<String> REEL_EVENTS = Set.of(")}).output(new Rule.Output[]{this.mark("reelEvents", new String[0])}).output(new Rule.Output[]{this.literal(");")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate final Connector connector;\n\tprivate final ")}).output(new Rule.Output[]{this.mark("terminal", new String[0])}).output(new Rule.Output[]{this.literal(".DatamartsRetryConfig retryConfig;\n\tprivate final List<EntityListener> entityListeners = new ArrayList<>();\n\tprivate final Map<String, List<MasterMounter>> mounters = new HashMap<>();\n\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.Entities entities;\n\tprivate Instant ts;\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private boolean hasLocalAccessToTimelines;")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private final Map<String, TimelineNodeImpl> timelines = new java.util.concurrent.ConcurrentHashMap<>();")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private boolean hasLocalAccessToIndicators;")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private final Map<String, IndicatorNodeImpl> indicators = new java.util.concurrent.ConcurrentHashMap<>();")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("private boolean hasLocalAccessToReels;")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("private final Map<String, ReelNodeImpl> reels = new java.util.concurrent.ConcurrentHashMap<>();")})}).output(new Rule.Output[]{this.literal("\n\tprivate volatile Translator translator = new Translator.Identity();\n\tprivate volatile boolean initializing = false;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(Connector connector, ")}).output(new Rule.Output[]{this.mark("terminal", new String[0])}).output(new Rule.Output[]{this.literal(".DatamartsRetryConfig retryConfig) {\n\t\tthis.connector = requireNonNull(connector);\n\t\tthis.retryConfig = requireNonNull(retryConfig);\n\t\tthis.entities = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.Entities(this);\n\t\tinitMounters();\n\t}\n\n\tpublic synchronized ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl init(String datamartSourceSelector) {\n\t\ttry {\n\t\t\tinitializing = true;\n\t\t\tdownloadDatamartFromDatahub(datamartSourceSelector);\n\t\t\tLogger.info(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart (\" + (snapshotTimetag().isEmpty() ? \"\" : \"snapshot \" + snapshotTimetag() + \", \")  + connector.clientId() + \") initialized successfully.\");\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart failed to start because a \" + e.getClass().getName() + \" occurred: \" + e.getMessage());\n\t\t} finally {\n\t\t\tinitializing = false;\n\t\t}\n\t\treturn this;\n\t}\n\n\tpublic boolean requiresDatahubNotifications() {\n\t\treturn true;\n\t}\n\n\t@Override\n\tpublic int size() {\n\t\treturn entities.size();\n\t}\n\n\t@Override\n\tpublic int sizeDisabled() {\n\t\treturn entities.sizeDisabled();\n\t}\n\n\t@Override\n\t@SuppressWarnings(\"unchecked\")\n\tpublic <T extends Entity> T get(String id) {\n\t\treturn (T) entities.get(id);\n\t}\n\n\t@Override\n\tpublic Stream<Entity> entities() {\n\t\treturn entities.streamGeneric();\n\t}\n\n\t@Override\n\tpublic void addEntityListener(EntityListener listener) {\n\t\tif (listener == null) throw new NullPointerException(\"EntityListener cannot be null\");\n\t\tentityListeners.add(listener);\n\t}\n\n\t@Override\n\tpublic DatamartDefinition getDefinition() {\n\t\treturn definition;\n\t}\n\n\t@Override\n    public List<String> listSnapshots() {\n    \ttry {\n    \t\tjakarta.jms.Message message = requestResponseFromDatahub(\"listSnapshots\", listSnapshotsRequest());\n    \t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n    \t\treturn handleListSnapshotsResponse(message);\n    \t} catch (Exception e) {\n    \t\tLogger.error(\"Could not download list of available snapshots: \" + e.getMessage(), e);\n    \t\treturn java.util.Collections.emptyList();\n    \t}\n    }\n\n    private jakarta.jms.Message listSnapshotsRequest() throws Exception {\n    \tActiveMQTextMessage message = new ActiveMQTextMessage();\n    \tmessage.setText(\"datamart=\" + name() + \";operation=snapshots\");\n    \treturn message;\n    }\n\n    private List<String> handleListSnapshotsResponse(jakarta.jms.Message message) throws Exception {\n    \treturn java.util.Arrays.stream(((jakarta.jms.TextMessage) message).getText().split(\",\")).collect(Collectors.toList());\n    }\n\n    @Override\n    public synchronized ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart snapshot(String timetag) {\n    \tif (timetag == null) return this;\n    \treturn new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(connector, retryConfig) {\n    \t\t@Override\n    \t\tprotected String snapshotTimetag() {\n    \t\t\treturn timetag;\n    \t\t}\n    \t\t@Override\n    \t\tpublic synchronized MasterDatamart snapshot(String timetag) {\n    \t\t\tthrow new java.lang.UnsupportedOperationException(\"Cannot request snapshots to snapshot instances of a datamart\");\n    \t\t}\n    \t}.init(null);\n\t}\n\n    public Instant ts() {\n    \treturn this.ts;\n    }\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[]{"timelinesByIdMethod"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timeline", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[]{"reelsByIdMethod"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reel", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t@Override\n\tpublic Translator translator() {\n\t\treturn translator;\n\t}\n\n\t@Override\n\tpublic void translator(Translator translator) {\n\t\tthis.translator = translator;\n\t}\n\n\tprivate void downloadDatamartFromDatahub(String datamartSourceSelector) throws DatahubRequestException {\n\t\tif (connector instanceof io.intino.alexandria.terminal.StubConnector) return;\n\t\tLogger.debug(\"Downloading datamart from datahub...\");\n\t\tlong start = java.lang.System.currentTimeMillis();\n\n\t\tLogger.debug(\"Downloading entities...\");\n\t\tint[] eventCount = new int[1];\n\t\tloadEntitiesFromEvents(downloadEntities(eventCount, datamartSourceSelector), eventCount);\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("loadTimelinesFromDatahub();")})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("loadIndicatorsFromDatahub();")})}).output(new Rule.Output[]{this.literal("\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("loadReelsFromDatahub();")})}).output(new Rule.Output[]{this.literal("\n\n\t\tlong time = java.lang.System.currentTimeMillis() - start;\n\t\tLogger.debug(\"Datamart downloaded from datahub after \" + time + \" ms\");\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[]{"loadTimelinesFromDatahubMethod"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[]{"loadIndicatorsFromDatahubMethod"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[]{"loadReelsFromDatahubMethod"})})}).output(new Rule.Output[]{this.literal("\n\n\tprivate Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) throws DatahubRequestException {\n\t\ttry {\n\t\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"downloadEvents\", downloadEntitiesRequest(datamartSourceSelector));\n\t\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\t\treturn handleDownloadResponse(message, eventCount);\n\t\t} catch (NullPointerException e) {\n\t\t\tthrow new DatahubRequestException(\"Could not download datamart: no response from datahub.\");\n\t\t} catch(DatahubRequestException e) {\n\t\t\tthrow e;\n\t\t} catch (Exception e) {\n\t\t\tthrow new DatahubRequestException(\"Could not download datamart: \" + e.getMessage());\n\t\t}\n\t}\n\n\tprivate jakarta.jms.Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {\n\t\tActiveMQTextMessage message = new ActiveMQTextMessage();\n\t\tmessage.setText(\"datamart=\" + name() +\n\t\t\t\";operation=entities\" +\n\t\t\t(snapshotTimetag().isEmpty() ? \"\" : \";timetag=\" + snapshotTimetag()) +\n\t\t\t(datamartSourceSelector == null ? \"\" : \";sourceSelector=\" + datamartSourceSelector)\n\t\t);\n\t\treturn message;\n\t}\n\n\tprotected String snapshotTimetag() {\n\t\treturn \"\";\n\t}\n\n\tprivate Stream<Event> handleDownloadResponse(jakarta.jms.Message message, int[] eventCount) throws Exception {\n\t\tjakarta.jms.BytesMessage m = (jakarta.jms.BytesMessage) message;\n\t\teventCount[0] = m.getIntProperty(\"size\");\n\t\tint size = m.getIntProperty(\"size\");\n\t\tbyte[] bytes = new byte[size];\n\t\tm.readBytes(bytes, size);\n\t\treturn io.intino.alexandria.zim.ZimStream.of(new java.io.ByteArrayInputStream(bytes)).map(io.intino.alexandria.event.message.MessageEvent::new);\n\t}\n\n\tprivate void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {\n\t\tevents.forEach(this::mount);\n\t}\n\n\tpublic synchronized void mount(Event event) {\n\t\ttry {\n\t\t\tif (event == null) return;\n        \tthis.ts = event.ts();\n        \tmountEntities(event);\n\t\t} catch(Throwable e) {\n\t\t\tLogger.error(\"Error while mounting event ss=\" + event.ss() + \", ts=\" + event.ts() + \" -> \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\tpublic synchronized void handleDatahubNotification(String notification) {\n\t\ttry {\n\t\t\tif(notification == null || notification.isBlank()) return;\n\t\t\tString[] typeAndSs = notification.split(\"\\0\");\n    \t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("handleTimelineNotification(typeAndSs")}).output(new Rule.Output[]{this.literal("[")}).output(new Rule.Output[]{this.literal("0")}).output(new Rule.Output[]{this.literal("]")}).output(new Rule.Output[]{this.literal(", typeAndSs")}).output(new Rule.Output[]{this.literal("[")}).output(new Rule.Output[]{this.literal("1")}).output(new Rule.Output[]{this.literal("]")}).output(new Rule.Output[]{this.literal(");")})}).output(new Rule.Output[]{this.literal("\n    \t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("handleReelNotification(typeAndSs")}).output(new Rule.Output[]{this.literal("[")}).output(new Rule.Output[]{this.literal("0")}).output(new Rule.Output[]{this.literal("]")}).output(new Rule.Output[]{this.literal(", typeAndSs")}).output(new Rule.Output[]{this.literal("[")}).output(new Rule.Output[]{this.literal("1")}).output(new Rule.Output[]{this.literal("]")}).output(new Rule.Output[]{this.literal(");")})}).output(new Rule.Output[]{this.literal("\n\t\t} catch(Throwable e) {\n\t\t\tLogger.error(\"Error while processing datahub notification \" + notification + \": \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("private void handleReelNotification(String type, String id) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tif (!REEL_EVENTS.contains(type)) return;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString key = normalizedId(id, type);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tReelNodeImpl reel = reels.computeIfAbsent(key, k -> new ReelNodeImpl(id, type, null));")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\treel.notifyChange();")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private void handleTimelineNotification(String type, String id) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tif (!TIMELINE_EVENTS.contains(type)) return;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString key = normalizedId(id, type);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tTimelineNodeImpl timeline = timelines.computeIfAbsent(key, k -> new TimelineNodeImpl(id, type, null));")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\ttimeline.notifyChange();")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate String normalizedId(String id, String type) {\n\t\treturn id.replace(\":\", \"-\") + \":\" + type;\n\t}\n\n\tprivate void mountEntities(Event event) {\n\t\ttry {\n\t\t\tList<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Mounter> mounters = this.mounters.get(event.type());\n\t\t\tif(mounters == null) return;\n\t\t\tmounters.forEach(mounter -> mounter.useListeners(!initializing).mount(event));\n\t\t} catch (Exception e) {\n\t\t\tLogger.error(\"Failed to mount event of type \" + event.type() + \": \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\tprivate void initMounters() {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"registerMounter"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tprivate static int availableThreads() {\n\t\treturn Runtime.getRuntime().availableProcessors();\n\t}\n\n\tprivate jakarta.jms.Message requestResponseFromDatahub(String requestName, jakarta.jms.Message request) throws DatahubRequestException {\n    \tlong timeout = retryConfig.initialTimeoutAmount;\n    \tfor(int i = 0; i < retryConfig.maxAttempts; i++) {\n    \t\tjakarta.jms.Message message = connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, retryConfig.timeoutUnit);\n    \t\tif (message != null) return message;\n    \t\tif (i < retryConfig.maxAttempts - 1) Logger.warn(\"(\"+(i+1)+\") Datahub did not respond after \" + timeout + \" \" + retryConfig.timeoutUnit + \" to the request '\" + requestName + \"'. Trying again...\");\n    \t\ttimeout *= retryConfig.timeoutMultiplier;\n    \t}\n    \tthrow new DatahubRequestException(\"Datahub did not respond to the request '\" + requestName + \"' after \" + retryConfig.maxAttempts);\n    }\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timelineNode", new String[]{"nodeImpl"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reelNode", new String[]{"nodeImpl"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicatorNode", new String[]{"nodeImpl"})})}).output(new Rule.Output[]{this.literal("\n\n\tprivate static Set<String> sourcesOfTimeline(String type) {\n    \treturn switch(type) {\n    \t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timeline", new String[]{"sourcesSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\tdefault -> java.util.Collections.emptySet();\n    \t};\n    }\n\n\tprivate static Set<String> sourcesOfReel(String type) {\n    \treturn switch(type) {\n    \t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reel", new String[]{"sourcesSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\tdefault -> java.util.Collections.emptySet();\n    \t};\n    }\n\n\tpublic static final class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition implements DatamartDefinition {\n\n\t\t@Override\n\t\tpublic String name() {\n\t\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t\t}\n\n\t\t@Override\n\t\tpublic Scale scale() {\n\t\t\treturn Scale.")}).output(new Rule.Output[]{this.mark("scale", new String[0])}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {\n\t\t\treturn new Query<EntityDefinition>(List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {\n\t\t\treturn new Query<StructDefinition>(List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String name) {\n\t\t\tswitch(name) {\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"defSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t}\n\t\t\treturn Optional.empty();\n\t\t}\n\n\t\t@Override\n    \tpublic Optional<StructDefinition> struct(String name) {\n    \t\tswitch(name) {\n    \t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"defSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\t}\n    \t\treturn Optional.empty();\n    \t}\n\n\t\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition datamart() {\n\t\t\treturn this;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"declareDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"declareDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tstatic {\n\t\ttry {\n\t\t\tObject ref = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.class.getDeclaredField(\"definition\").get(null);\n\t\t\tjava.lang.reflect.Field field = ref.getClass().getDeclaredField(\"definition\");\n\t\t\tfield.setAccessible(true);\n\t\t\tfield.set(ref, definition);\n\t\t\tfield.setAccessible(false);\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"Could not set ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.definition field\");\n\t\t}\n\t}\n}")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("definition")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("defswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return Optional.of(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition);")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("defswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return Optional.of(")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition);")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("declaredefinition")}).output(new Rule.Output[]{this.literal("public final EntityDefinition ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition = new EntityDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")}).output(new Rule.Output[]{this.mark("fullName", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic boolean isAbstract() {return ")}).output(new Rule.Output[]{this.mark("isAbstract", new String[0])}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<AttributeDefinition> declaredAttributes() {\treturn declaredAttributes;}\n\tpublic Optional<EntityDefinition> parent() {return ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.of(")}).output(new Rule.Output[]{this.mark("parent", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.empty()")}))}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<EntityDefinition> ancestors() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("ancestor", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic List<EntityDefinition> descendants() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("descendant", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>();\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasNoParents", new String[]{"addIdAndEnabledAttributes"})})}).output(new Rule.Output[]{this.literal("\n    \t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"addDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \treturn Collections.synchronizedList(list);\n\t}\n\tpublic boolean equals(Object other) {\n\t\tif (other == null || other.getClass() != getClass()) return false;\n\t\treturn fullName().equals(((EntityDefinition)other).fullName());\n\t}\n\tpublic int hashCode() {return fullName().hashCode();}\n\tpublic String toString() {return fullName();}\n};")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("declaredefinition")}).output(new Rule.Output[]{this.literal("public final StructDefinition ")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition = new StructDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")}).output(new Rule.Output[]{this.mark("fullName", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic List<AttributeDefinition> declaredAttributes() {return declaredAttributes;}\n\tpublic Optional<StructDefinition> parent() {return ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.of(")}).output(new Rule.Output[]{this.mark("parent", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition)")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.empty()")}))}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<StructDefinition> ancestors() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("ancestor", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic List<StructDefinition> descendants() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("descendant", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>(")}).output(new Rule.Output[]{this.mark("numAttributes", new String[0])}).output(new Rule.Output[]{this.literal(");\n    \t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"addDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \treturn Collections.synchronizedList(list);\n\t}\n\tpublic boolean equals(Object other) {\n    \tif (other == null || other.getClass() != getClass()) return false;\n    \treturn fullName().equals(((StructDefinition)other).fullName());\n    }\n    public int hashCode() {return fullName().hashCode();}\n    public String toString() {return fullName();}\n};")}), this.rule().condition(this.type("subclass"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.anyTypes(new String[]{"descendant", "ancestor"}), this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.anyTypes(new String[]{"descendant", "ancestor"}), this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("StructDefinition")}), this.rule().condition(this.trigger("addidandenabledattributes"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"id\";}\n\tpublic Class<?> type() {return String.class;}\n\tpublic String toString() {return name();}\n});\nlist.add(new AttributeDefinition() {\n\tpublic String name() {return \"enabled\";}\n\tpublic Class<?> type() {return Boolean.class;}\n\tpublic String toString() {return name();}\n});")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("inherited")), this.type("collection"), this.trigger("adddefinition")}).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\";}\n\tpublic Class<?> type() {return ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\tpublic String toString() {return name();}\n\tpublic List<ParameterDefinition> parameters() {\n\t\treturn List.of(new ParameterDefinition() {\n\t\t\tpublic Optional<ConceptDefinition<?>> asConceptDefinition() {return ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"asConceptDefinition"})}).output(new Rule.Output[]{this.literal(";}\n\t\t\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("parameterType", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\t\t\tpublic String toString() {return javaClass().getSimpleName();}\n\t\t});\n\t}\n});")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("inherited")), this.trigger("adddefinition")}).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\";}\n\tpublic Class<?> type() {return ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\tpublic String toString() {return name();}\n});")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.type("entity"), this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.of(datamart().")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.type("struct"), this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.of(datamart().")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition)")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.empty()")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.type("entity"), this.trigger("registermounter")}).output(new Rule.Output[]{this.literal("mounters.computeIfAbsent(\"")}).output(new Rule.Output[]{this.mark("event", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("\", type -> new ArrayList<>(1)).add(new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mounters.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Mounter(entities, entityListeners));")}), this.rule().condition(this.type("subclasstop"), new Rule.Condition[]{this.trigger("getallstream")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.type("subclasstop"), new Rule.Condition[]{this.trigger("getallstreamdisabled")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled()")}), this.rule().condition(this.type("timeline"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic TimelineNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(String id) {\n\tString key = normalizedId(id, \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\");\n\tif (timelines.containsKey(key)) return timelines.get(key);\n\tif (!hasLocalAccessToTimelines) return timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"));\n\treturn TimelineNode.empty();\n}")}), this.rule().condition(this.type("reel"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ReelNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(String id) {\n\tString key = normalizedId(id, \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\");\n\tif (reels.containsKey(key)) return reels.get(key);\n\tif (!hasLocalAccessToReels) return reels.computeIfAbsent(key, theId -> new ReelNodeImpl(id, \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"));\n\treturn ReelNode.empty();\n}\n\n@Override\npublic Stream<ReelNode> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Reels() {\n\tStream stream = reels.values().stream().filter(r -> r.type.equals(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")).toList().stream();\n\treturn stream;\n}")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic IndicatorNode ")}).output(new Rule.Output[]{this.mark("label", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Indicator() {\n\tif (hasLocalAccessToIndicators) return indicators.containsKey(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\") ? indicators.get(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\") : IndicatorNode.empty();\n\treturn indicators.computeIfAbsent(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", theId -> new IndicatorNodeImpl(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", null));\n}")}), this.rule().condition(this.trigger("timelinesbyidmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic Stream<TimelineNode> timelines(String id) {\n\tStream stream = timelines.values().stream().filter(t -> t.id.equals(id)).toList().stream();\n\treturn stream;\n}")}), this.rule().condition(this.trigger("reelsbyidmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic Stream<ReelNode> reels(String id) {\n\tStream stream = reels.values().stream().filter(r -> r.id.equals(id)).toList().stream();\n\treturn stream;\n}")}), this.rule().condition(this.trigger("sourcesswitchcase"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\" -> Set.of(")}).output(new Rule.Output[]{this.mark("sources", new String[0])}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.type("abstract"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null ? null : entities.getDescendant(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled(String id) {\n\treturn id == null ? null : entities.getDescendantDisabled(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\t")}).output(new Rule.Output[]{this.mark("subclasstop", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled() {\n\treturn Stream.of(\n\t\t")}).output(new Rule.Output[]{this.mark("subclasstop", new String[]{"getAllStreamDisabled"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());\n}")}), this.rule().condition(this.type("superclass"), new Rule.Condition[]{this.not(this.type("abstract")), this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null ? null : entities.getDescendant(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled(String id) {\n\treturn id == null ? null : entities.getDescendantDisabled(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\tentities.<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">stream(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition),\n\t\t")}).output(new Rule.Output[]{this.mark("subclasstop", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());//.distinct();\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled() {\n\treturn Stream.of(\n\t\tentities.<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">streamDisabled(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition),\n\t\t")}).output(new Rule.Output[]{this.mark("subclasstop", new String[]{"getAllStreamDisabled"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null ? null : entities.get(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled(String id) {\n\treturn id == null ? null : entities.getDisabled(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn entities.stream(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled() {\n\treturn entities.streamDisabled(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition);\n}")}), this.rule().condition(this.trigger("loadtimelinesfromdatahubmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void loadTimelinesFromDatahub() {\n\tLogger.debug(\"Downloading timelines...\");\n\tBoolean hasLocalAccessToTimelines = null;\n    for(String filename : listTimelineFiles()) {\n    \tif (filename == null || filename.isBlank()) continue;\n    \ttry {\n           \tFile file = new File(filename);\n           \tString id = file.getName().replace(\".timeline\", \"\");\n           \tString type = file.getParentFile().getName();\n           \tTimelineNodeImpl node = new TimelineNodeImpl(id, type, file.exists() ? file : null);\n           \ttimelines.put(id + \":\" + type, node);\n           \tif (hasLocalAccessToTimelines == null) hasLocalAccessToTimelines = file.exists();\n           \telse hasLocalAccessToTimelines &= file.exists();\n        } catch (Exception e) {\n           \tLogger.debug(\"Could not load timeline \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n        }\n    }\n    this.hasLocalAccessToTimelines = hasLocalAccessToTimelines != null && hasLocalAccessToTimelines;\n    Logger.debug(\"Loaded \" + timelines.size() + \" timelines (hasLocalAccessToTimelines=\" + this.hasLocalAccessToTimelines + \")\");\n}\n\nprivate String[] listTimelineFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-timelines;\");\n\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"list-timelines\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\treturn ((jakarta.jms.TextMessage) message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")}), this.rule().condition(this.trigger("loadindicatorsfromdatahubmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void loadIndicatorsFromDatahub() {\n\tLogger.debug(\"Downloading indicators...\");\n\tBoolean hasLocalAccessToIndicators = null;\n    for(String filename : listIndicatorFiles()) {\n\t\tif (filename == null || filename.isBlank()) continue;\n\t\ttry {\n\t\t\tFile file = new File(filename);\n\t\t\tString id = file.getName().replace(\".indicator\", \"\");\n\t\t\tIndicatorNodeImpl node = new IndicatorNodeImpl(id, file.exists() ? file : null);\n\t\t\tindicators.put(id, node);\n\t\t\tif (hasLocalAccessToIndicators == null) hasLocalAccessToIndicators = file.exists();\n\t\t\telse hasLocalAccessToIndicators &= file.exists();\n\t\t} catch (Exception e) {\n\t\t\tLogger.debug(\"Could not load indicator \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n\t\t}\n\t}\n\tthis.hasLocalAccessToIndicators = hasLocalAccessToIndicators != null && hasLocalAccessToIndicators;\n\tLogger.debug(\"Loaded \" + indicators.size() + \" indicators (hasLocalAccessToTimelines=\" + this.hasLocalAccessToTimelines + \")\");\n}\n\nprivate String[] listIndicatorFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-indicators;\");\n\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"list-indicators\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\treturn ((jakarta.jms.TextMessage) message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")}), this.rule().condition(this.trigger("loadreelsfromdatahubmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void loadReelsFromDatahub() {\n\tLogger.debug(\"Downloading reels...\");\n\tBoolean hasLocalAccessToReels = null;\n\tfor(String filename : listReelFiles()) {\n\t\tif (filename == null || filename.isBlank()) continue;\n\t\ttry {\n\t    \tFile file = new File(filename);\n\t    \tString id = file.getName().replace(\".reel\", \"\");\n\t    \tString type = file.getParentFile().getName();\n\t    \tReelNodeImpl node = new ReelNodeImpl(id, type, file.exists() ? file : null);\n\t    \treels.put(id + \":\" + type, node);\n\t    \tif (hasLocalAccessToReels == null) hasLocalAccessToReels = file.exists();\n            else hasLocalAccessToReels &= file.exists();\n\t    } catch (Exception e) {\n\t    \tLogger.debug(\"Could not load reel \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n\t    }\n\t}\n\tthis.hasLocalAccessToReels = hasLocalAccessToReels != null && hasLocalAccessToReels;\n\tLogger.debug(\"Loaded \" + reels.size() + \" reels\");\n}\n\nprivate String[] listReelFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-reels;\");\n\t\tjakarta.jms.Message message = requestResponseFromDatahub(\"list-reels\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((jakarta.jms.TextMessage) message).getText());\n\t\treturn ((jakarta.jms.TextMessage)message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")})});
    }
}

