/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration;

import io.intino.Configuration;
import io.intino.datahub.model.Terminal;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.codegeneration.Commons;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.PomTemplate;
import io.intino.plugin.CompilerConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public class PomRenderer {
    private final CompilerConfiguration configuration;
    private final Map<String, String> versions;
    private final File root;
    private final String groupId;

    public PomRenderer(CompilerConfiguration configuration, Map<String, String> versions, File root, String groupId) {
        this.configuration = configuration;
        this.versions = versions;
        this.root = root;
        this.groupId = groupId;
    }

    public File render(Terminal terminal) throws IntinoException {
        ArrayList<Target> targets = this.targets(terminal);
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)this.groupId).add("artifact", (Object)this.terminalNameArtifact(terminal)).add("version", (Object)this.configuration.version());
        for (Configuration.Repository r : this.configuration.repositories()) {
            this.buildRepoFrame(builder, r);
        }
        if (this.configuration.releaseDistributionRepository() != null || this.configuration.snapshotDistributionRepository() != null) {
            if (this.isSnapshotVersion()) {
                this.buildDistroFrame(builder, this.configuration.snapshotDistributionRepository());
            } else {
                this.buildDistroFrame(builder, this.configuration.releaseDistributionRepository());
            }
        }
        if (targets.contains((Object)Target.Events)) {
            builder.add("terminal", (Object)this.terminalDependenciesFrame(this.groupId, this.configuration.version()));
        }
        if (targets.contains((Object)Target.Bpm)) {
            builder.add("bpm", (Object)this.versions.get("bpm"));
        }
        File pomFile = new File(this.root, "pom.xml");
        Commons.write(pomFile.toPath(), new PomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    public String coors(Terminal terminal) {
        return String.join((CharSequence)":", this.groupId, this.terminalNameArtifact(terminal), this.configuration.version());
    }

    private ArrayList<Target> targets(Terminal terminal) {
        ArrayList<Target> targets = new ArrayList<Target>();
        targets.add(Target.Events);
        if (terminal.bpm() != null) {
            targets.add(Target.Bpm);
        }
        return targets;
    }

    private String terminalNameArtifact(Terminal terminal) {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)terminal.name$()).toString());
    }

    private boolean isSnapshotVersion() {
        return this.configuration.version().contains("SNAPSHOT");
    }

    private FrameBuilder terminalDependenciesFrame(String group, String version) {
        return new FrameBuilder(new String[]{"terminal"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("terminalVersion", (Object)this.versions.get("terminal-jms")).add("ingestionVersion", (Object)this.versions.get("ingestion")).add("datalakeVersion", (Object)this.versions.get("datalake")).add("version", (Object)version);
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r) throws IntinoException {
        if (r == null) {
            throw new IntinoException("Repository not found");
        }
        builder.add("repository", (Object)this.createRepositoryFrame(r).toFrame());
    }

    private void buildDistroFrame(FrameBuilder builder, Configuration.Repository r) throws IntinoException {
        if (r == null) {
            throw new IntinoException("Repository not found");
        }
        builder.add("repository", (Object)this.createRepositoryFrame(r).add("distribution").toFrame());
    }

    private FrameBuilder createRepositoryFrame(Configuration.Repository repo) {
        return new FrameBuilder(new String[]{"repository", repo.getClass().getSimpleName()}).add("name", (Object)repo.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repo.url()).add("snapshot", (Object)(repo instanceof Configuration.Repository.Snapshot));
    }

    public static enum Target {
        Events,
        Bpm;

    }
}

