/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.terminal.builder.ArtifactoryConnector;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.util.Version;
import java.util.Comparator;
import java.util.List;

public class VersionBounds {
    static final String MINIMUM_CHRONOS_VERSION = "2.0.0";
    static final String MAX_CHRONOS_VERSION = "3.0.0";
    static final String MINIMUM_BPM_VERSION = "3.1.1";
    static final String MAX_BPM_VERSION = "4.0.0";
    static final String MINIMUM_TERMINAL_JMS_VERSION = "6.0.0";
    static final String MAX_TERMINAL_JMS_VERSION = "7.0.0";
    static final String MINIMUM_INGESTION_VERSION = "5.0.2";
    static final String MAX_INGESTION_VERSION = "6.0.0";
    static final String MINIMUM_MASTER_VERSION = "3.0.0";
    static final String MAX_MASTER_VERSION = "3.0.0";
    static final String MINIMUM_DATALAKE_VERSION = "7.0.2";
    static final String MAX_DATALAKE_VERSION = "8.0.0";
    static final String MINIMUM_EVENT_VERSION = "5.0.2";
    static final String MAX_EVENT_VERSION = "6.0.0";

    static String terminalJmsVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.terminalVersions(), "6.0.0", MAX_TERMINAL_JMS_VERSION);
    }

    static String masterVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.masterVersions(), "3.0.0", "3.0.0");
    }

    static String ingestionVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.ingestionVersions(), "5.0.2", "6.0.0");
    }

    static String eventVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.eventVersions(), "5.0.2", "6.0.0");
    }

    static String datalakeVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.datalakeVersions(), MINIMUM_DATALAKE_VERSION, MAX_DATALAKE_VERSION);
    }

    static String chronosVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.chronosVersions(), MINIMUM_CHRONOS_VERSION, "3.0.0");
    }

    static String bpmVersion() {
        return VersionBounds.suitableVersion(ArtifactoryConnector.bpmVersions(), MINIMUM_BPM_VERSION, MAX_BPM_VERSION);
    }

    private static String suitableVersion(List<Version> versions, String min, String max) {
        try {
            Version maxVersion = new Version(max);
            Version minVersion = new Version(min);
            return versions.stream().sorted(Comparator.reverseOrder()).filter(v -> v.compareTo(maxVersion) < 0).findFirst().orElse(minVersion).get();
        }
        catch (IntinoException e) {
            Logger.error((Throwable)e);
            return min;
        }
    }
}

