/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.serialization;

import io.intino.ness.master.serialization.MasterSerializer;
import io.intino.ness.master.serialization.SeparatorMasterSerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class MasterSerializers {
    private static final Map<String, Supplier<MasterSerializer>> Serializers = new ConcurrentHashMap<String, Supplier<MasterSerializer>>();

    public static MasterSerializer getDefault() {
        return Serializers.get("default").get();
    }

    public static MasterSerializer getOrDefault(String name) {
        if (name == null) {
            return null;
        }
        MasterSerializer serializer = MasterSerializers.get(name);
        return serializer != null ? serializer : MasterSerializers.getDefault();
    }

    public static MasterSerializer get(String name) {
        if (name == null) {
            return null;
        }
        return Serializers.getOrDefault(name.toLowerCase(), MasterSerializers::getNull).get();
    }

    public static void setSerializer(String name, Supplier<MasterSerializer> serializerSupplier) {
        if (serializerSupplier == null) {
            throw new NullPointerException("Serializer supplier cannot be null");
        }
        if (name.equalsIgnoreCase("default")) {
            throw new IllegalArgumentException("Cannot set the default serializer");
        }
        Serializers.put(name, serializerSupplier);
    }

    private static MasterSerializer getNull() {
        return null;
    }

    static {
        Serializers.put("tsv", SeparatorMasterSerializer.Tsv::new);
        Serializers.put("csv", SeparatorMasterSerializer.Csv::new);
        Serializers.put("default", SeparatorMasterSerializer.Tsv::new);
    }

    public static final class Standard {
        public static final String TSV = "tsv";
        public static final String CSV = "csv";

        public static String getDefault() {
            return TSV;
        }
    }
}

