/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.messages.listeners;

import io.intino.ness.master.model.Entity;
import java.time.Instant;

@FunctionalInterface
public interface EntityListener<T extends Entity> {
    public void notify(Event<T> var1);

    public static <E extends Entity> EntityListener<E> onCreate(EntityListener<E> listener) {
        return event -> {
            if (event.type() == Event.Type.Create) {
                listener.notify(event);
            }
        };
    }

    public static <E extends Entity> EntityListener<E> onUpdate(EntityListener<E> listener) {
        return event -> {
            if (event.type() == Event.Type.Update) {
                listener.notify(event);
            }
        };
    }

    public static <E extends Entity> EntityListener<E> onEnable(EntityListener<E> listener) {
        return event -> {
            if (event.type() == Event.Type.Enable) {
                listener.notify(event);
            }
        };
    }

    public static <E extends Entity> EntityListener<E> onDisable(EntityListener<E> listener) {
        return event -> {
            if (event.type() == Event.Type.Disable) {
                listener.notify(event);
            }
        };
    }

    public static <E extends Entity> EntityListener<E> onNone(EntityListener<E> listener) {
        return event -> {
            if (event.type() == Event.Type.None) {
                listener.notify(event);
            }
        };
    }

    public static interface Event<T extends Entity> {
        public String clientName();

        public Type type();

        public Entity.Id entityId();

        public T entity();

        public String value();

        public Instant ts();

        public String messageId();

        public static enum Type {
            Create,
            Update,
            Enable,
            Disable,
            None;

        }
    }
}

