/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.messages;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.ness.master.messages.MasterMessage;

public class MasterMessageSerializer {
    public static String serialize(MasterMessage message) {
        return message.toString();
    }

    public static MasterMessage deserialize(String str) {
        Message message = new Message(str);
        String messageClass = message.get("messageClass").asString();
        if (messageClass == null) {
            return new MasterMessage.Unknown(message);
        }
        return MasterMessageSerializer.instantiate(messageClass, message);
    }

    private static MasterMessage instantiate(String messageClass, Message message) {
        try {
            Class<?> clazz = Class.forName(messageClass);
            return (MasterMessage)clazz.getConstructor(Message.class).newInstance(message);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new MasterMessage.Unknown(message);
        }
    }
}

