/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation.validators;

import io.intino.ness.master.data.validation.Issue;
import io.intino.ness.master.data.validation.TripletSource;
import io.intino.ness.master.data.validation.TripletValidator;
import io.intino.ness.master.model.Triplet;
import java.util.Objects;
import java.util.stream.Stream;

public class TypeTripletValidator
implements TripletValidator {
    private final Issue.Level level;

    public TypeTripletValidator() {
        this(Issue.Level.Error);
    }

    public TypeTripletValidator(Issue.Level level) {
        this.level = Objects.requireNonNull(level);
    }

    @Override
    public Stream<Issue> validate(String tripleLine, TripletSource source) {
        Triplet triplet = new Triplet(tripleLine);
        return this.hasNoType(triplet.subject()) ? Stream.of(Issue.create(this.level, "Subject without type", "Triple (" + triplet.subject() + ") subject must have a type").source(source)) : Stream.empty();
    }

    private boolean hasNoType(String subject) {
        String type = Triplet.typeOf(subject);
        return type == null || type.equals("");
    }
}

