/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation;

import io.intino.ness.master.data.validation.Issue;
import io.intino.ness.master.data.validation.TripletSource;
import io.intino.ness.master.data.validation.TripletValidator;
import io.intino.ness.master.data.validation.ValidationLayers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class TripletValidationLayer {
    private final List<TripletValidator> validators = new ArrayList<TripletValidator>(2);

    public Stream<Issue> validate(String tripleLine, TripletSource source) {
        return this.validators.stream().flatMap(validator -> this.validate((TripletValidator)validator, tripleLine, source));
    }

    private Stream<Issue> validate(TripletValidator validator, String tripleLine, TripletSource source) {
        return validator.validate(tripleLine, source).filter(Objects::nonNull).peek(issue -> issue.scope(ValidationLayers.Scope.TRIPLES));
    }

    public TripletValidationLayer addValidator(TripletValidator validator) {
        if (validator == null) {
            return this;
        }
        this.validators.add(validator);
        return this;
    }
}

