/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation;

import io.intino.ness.master.data.validation.Issue;
import io.intino.ness.master.data.validation.TripletRecordStore;
import io.intino.ness.master.data.validation.TripletSource;
import io.intino.ness.master.model.Triplet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface RecordValidator {
    public static final String LIST_SEPARATOR = ";";
    public static final String MAP_KEY_VALUE_SEPARATOR = "=";
    public static final String STRUCT_FIELD_SEPARATOR = ",";

    public static RecordValidator none() {
        return (r, s) -> Stream.empty();
    }

    public Stream<Issue> validate(TripletRecord var1, TripletRecordStore var2);

    public static class TripletRecord {
        private final String id;
        private final Map<String, List<Value>> attributes = new LinkedHashMap<String, List<Value>>();
        private TripletSource source;

        public TripletRecord(String id) {
            this.id = id;
        }

        public void add(String predicate, Value value) {
            this.attributes.computeIfAbsent(predicate, k -> new ArrayList()).add(value);
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return Triplet.typeOf(this.id);
        }

        public Map<String, List<Value>> attributes() {
            return this.attributes;
        }

        public List<Value> get(String attribute) {
            return this.attributes.getOrDefault(attribute, Collections.emptyList());
        }

        public TripletSource source() {
            return this.source;
        }

        public TripletRecord source(TripletSource source) {
            this.source = source;
            return this;
        }

        public static class Value {
            private final String value;
            private TripletSource source;

            public Value(String value) {
                this.value = value;
            }

            public boolean isEmpty() {
                return this.value == null;
            }

            public String get() {
                return this.value;
            }

            public TripletSource source() {
                return this.source;
            }

            public Value source(TripletSource source) {
                this.source = source;
                return this;
            }

            public String toString() {
                return this.value;
            }
        }
    }
}

