/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data;

import io.intino.ness.master.data.DefaultTripletsDigester;
import io.intino.ness.master.data.EntityLoader;
import io.intino.ness.master.model.TripletRecord;
import io.intino.ness.master.serialization.MasterSerializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public interface MasterTripletsDigester {
    public static MasterTripletsDigester createDefault() {
        return new DefaultTripletsDigester();
    }

    public Result load(EntityLoader var1, MasterSerializer var2) throws Exception;

    public static class WritableResult
    implements Result {
        private final Result.Stats stats = new Result.Stats();
        private Map<String, TripletRecord> records = new HashMap<String, TripletRecord>();

        @Override
        public Result.Stats stats() {
            return this.stats;
        }

        @Override
        public Map<String, TripletRecord> records() {
            return this.records;
        }

        public WritableResult records(Map<String, TripletRecord> records) {
            this.records = records;
            return this;
        }
    }

    public static interface Result {
        public static WritableResult create() {
            return new WritableResult();
        }

        public Stats stats();

        public Map<String, TripletRecord> records();

        public static class Stats {
            public static final String TRIPLETS_READ = "Triplets read";
            public static final String FILES_READ = "Files read";
            public static final String LINES_READ = "Lines read";
            private final Map<String, Object> statsMap = new LinkedHashMap<String, Object>();

            public void put(String key, Object value) {
                this.statsMap.put(key, value);
            }

            public void increment(String key) {
                this.statsMap.compute(key, (k, v) -> v == null ? 1 : (Integer)v + 1);
            }

            public <T> T get(String key) {
                return (T)this.statsMap.get(key);
            }

            public <T> T getOrDefault(String key, T defValue) {
                return (T)this.statsMap.getOrDefault(key, defValue);
            }

            public String getString(String key, Object defValue) {
                return String.valueOf(this.statsMap.getOrDefault(key, defValue));
            }

            public Set<Map.Entry<String, Object>> entrySet() {
                return this.statsMap.entrySet();
            }

            public Map<String, Object> map() {
                return this.statsMap;
            }
        }
    }
}

