/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data;

import io.intino.ness.master.data.EntityLoader;
import io.intino.ness.master.data.MasterTripletsDigester;
import io.intino.ness.master.model.Triplet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileEntityLoader
implements EntityLoader {
    private final File root;
    private final Set<String> extensions;

    public FileEntityLoader(File root) {
        this(root, Set.of("triples", "triplets"));
    }

    public FileEntityLoader(File root, Set<String> extensions) {
        this.root = root;
        this.extensions = extensions;
    }

    @Override
    public Stream<Triplet> loadTriplets(MasterTripletsDigester.Result.Stats stats) throws IOException {
        return this.findTripletsFilesIn(this.root).flatMap(f -> this.readTripletsFromFile((File)f, stats));
    }

    protected Stream<Triplet> readTripletsFromFile(File file, MasterTripletsDigester.Result.Stats stats) {
        stats.increment("Files read");
        ArrayList<Triplet> triplets = new ArrayList<Triplet>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.process(line, triplets, stats);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return triplets.stream();
    }

    protected void process(String line, List<Triplet> triplets, MasterTripletsDigester.Result.Stats stats) {
        stats.increment("Lines read");
        if (line.isEmpty()) {
            return;
        }
        triplets.add(new Triplet(line));
        stats.increment("Triplets read");
    }

    protected static String extensionOf(File file) {
        String name = file.getName();
        int extensionStart = name.lastIndexOf(46);
        return extensionStart < 0 ? "" : name.substring(extensionStart + 1);
    }

    private Stream<File> findTripletsFilesIn(File root) throws IOException {
        try (Stream<Path> files = Files.walk(root.toPath(), new FileVisitOption[0]);){
            Stream<File> stream = files.map(Path::toFile).filter(f -> f.isFile() && this.extensions.contains(FileEntityLoader.extensionOf(f))).collect(Collectors.toList()).stream();
            return stream;
        }
    }
}

