/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Accessory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public class Serializer {
    private final Object object;
    private final String path;
    private final Accessory.Mapping mapping;

    public static Serializer serialize(Object object) {
        return new Serializer(object, "", new Accessory.Mapping());
    }

    private Serializer(Object object, String path, Accessory.Mapping mapping) {
        this.object = object;
        this.path = path;
        this.mapping = mapping;
    }

    public String toInl() {
        return this.object instanceof List ? this.toInl((List)this.object) : this.header() + this.body();
    }

    private String toInl(List list) {
        StringBuilder result = new StringBuilder();
        for (Object o : list) {
            result.append("\n").append(Serializer.serialize(o).toInl());
        }
        return result.substring(1);
    }

    private String header() {
        return "[" + this.type() + "]\n";
    }

    private String type() {
        return this.path + (this.path.isEmpty() ? "" : ".") + this.map(this.className());
    }

    private String map(String text) {
        return this.mapping.get(text);
    }

    private String body() {
        return this.serializeAttributes() + this.serializeComponents();
    }

    private String serializeAttributes() {
        StringBuilder result = new StringBuilder();
        for (Field field : Accessory.fieldsOf(this.object).asList()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !this.isAttribute(field) || this.valueOf(field) == null || this.isEmpty(field)) continue;
            result.append(this.serializeAttribute(field)).append("\n");
        }
        return result.toString();
    }

    private String serializeAttribute(Field field) {
        return this.map(field.getName()) + this.separatorFor(this.serializeAttributeValue(this.valueOf(field)));
    }

    private String serializeAttributeValue(Object value) {
        return value != null ? this.formatterOf(value).format(value) : "";
    }

    private String separatorFor(String value) {
        return value.startsWith("\n") ? ":" + value : ": " + value;
    }

    private Accessory.Formatter formatterOf(Object value) {
        return Accessory.formatters.get(value.getClass());
    }

    private String serializeComponents() {
        StringBuilder result = new StringBuilder();
        for (Field field : Accessory.fieldsOf(this.object).asList()) {
            if (Modifier.isTransient(field.getModifiers()) || this.isAttribute(field.getType())) continue;
            result.append(this.serializeComponent(field));
        }
        return result.toString();
    }

    private String serializeComponent(Field field) {
        Object object = this.valueOf(field);
        if (object == null) {
            return "";
        }
        return this.isList(field) ? this.serializeTable((List)object) : this.serializeItem(object);
    }

    private String serializeTable(List list) {
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append(this.serializeItem(item));
        }
        return result.toString();
    }

    private String serializeItem(Object value) {
        return "\n" + new Serializer(value, this.type(), this.mapping).toInl();
    }

    private boolean isAttribute(Field field) {
        return this.isAttribute(field.getType());
    }

    private boolean isAttribute(Class<?> aClass) {
        return aClass.getName().startsWith("java.lang") || aClass.getName().startsWith("java.util.Date") || aClass.getName().startsWith("java.time") || aClass.isPrimitive() || aClass.isArray();
    }

    private boolean isEmpty(Field field) {
        Object value = this.valueOf(field);
        return value.getClass().isArray() && ((Object[])value).length == 0;
    }

    private boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private String className() {
        return this.object.getClass().getSimpleName();
    }

    private Object valueOf(Field field) {
        try {
            field.setAccessible(true);
            return field.get(this.object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Serializer map(String from, String to) {
        this.mapping.put(from, to);
        return this;
    }
}

