/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Accessory;
import io.intino.ness.inl.Deserializer;
import io.intino.ness.inl.Formats;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Message {
    String type;
    Message owner;
    List<Attribute> attributes;
    List<Message> components;
    public static Message empty = new Message("");

    public Message(String type) {
        this.type = type;
        this.owner = null;
        this.attributes = new ArrayList<Attribute>();
        this.components = null;
    }

    Message(String type, Message owner) {
        this.type = type;
        this.owner = owner;
        this.attributes = new ArrayList<Attribute>();
        this.components = new ArrayList<Message>();
    }

    public String type() {
        return this.type;
    }

    public boolean is(String type) {
        return type.equalsIgnoreCase(this.type);
    }

    public <T> T as(Class<T> type) {
        return Deserializer.deserialize(this.toString()).next(type);
    }

    public void type(String type) {
        this.type = type;
    }

    public String ts() {
        return this.read("ts");
    }

    public void ts(String ts) {
        this.write("ts", ts);
    }

    public String read(String attribute) {
        return this.valueOf(attribute);
    }

    public Message write(String attribute, String value) {
        if (this.contains(attribute)) {
            this.get((String)attribute).value = value;
        } else if (value != null) {
            this.attributes.add(new Attribute(attribute, value));
        }
        return this;
    }

    public Data parse(final String attribute) {
        return new Data(){

            @Override
            public <T> T as(Class<T> type) {
                String value = Message.this.valueOf(attribute);
                return (T)(value != null ? Accessory.parsers.get(type).parse(value) : null);
            }
        };
    }

    Message write(Attribute attribute) {
        return this.write(attribute.name, attribute.value);
    }

    public Message write(String attribute, Boolean value) {
        return this.write(attribute, value.toString());
    }

    public Message write(String attribute, Integer value) {
        return this.write(attribute, value.toString());
    }

    public Message write(String attribute, Double value) {
        return this.write(attribute, value.toString());
    }

    public Message rename(String attribute, String newName) {
        this.get((String)attribute).name = newName;
        return this;
    }

    public Message remove(String attribute) {
        if (this.contains(attribute)) {
            this.attributes.remove(this.indexOf(attribute));
        }
        return this;
    }

    private String valueOf(String attribute) {
        return this.get((String)attribute).value;
    }

    public int indexOf(String attribute) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get((int)i).name.equalsIgnoreCase(attribute)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String attribute) {
        return this.indexOf(attribute) >= 0;
    }

    private Attribute get(String attribute) {
        int indexOf = this.indexOf(attribute);
        return indexOf >= 0 ? this.attributes.get(indexOf) : new Attribute();
    }

    public List<Message> components(String type) {
        ArrayList<Message> result = new ArrayList<Message>();
        if (this.components == null) {
            return result;
        }
        for (Message component : this.components) {
            if (!component.is(type)) continue;
            result.add(component);
        }
        return result;
    }

    public void add(Message component) {
        if (this.components == null) {
            this.components = new ArrayList<Message>();
        }
        this.components.add(component);
        component.owner = this;
    }

    public void add(List<Message> components) {
        if (components == null) {
            return;
        }
        for (Message component : components) {
            this.add(component);
        }
    }

    public void remove(Message component) {
        this.components.remove(component);
    }

    public void remove(List<Message> components) {
        this.components.removeAll(components);
    }

    public String toString() {
        String result = "[" + this.path() + "]";
        for (Attribute attribute : this.attributes) {
            result = result + "\n" + attribute.toString();
        }
        for (Message component : this.components()) {
            result = result + "\n\n" + component.toString();
        }
        return result;
    }

    public static Message load(String message) {
        return Message.load(message.getBytes());
    }

    public static Message load(byte[] bytes) {
        try {
            return Formats.Inl.of(new ByteArrayInputStream(bytes)).next();
        }
        catch (IOException e) {
            return empty;
        }
    }

    private List<Message> components() {
        return this.components == null ? new ArrayList() : this.components;
    }

    private String path() {
        return this.owner != null ? this.owner.path() + "." + this.type : this.type;
    }

    public int length() {
        return this.toString().length();
    }

    public List<String> attributes() {
        ArrayList<String> result = new ArrayList<String>();
        for (Attribute attribute : this.attributes) {
            result.add(attribute.name);
        }
        return result;
    }

    static class Attribute {
        String name;
        String value;

        Attribute() {
        }

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        Attribute parse(String line) {
            int i = line.indexOf(":");
            this.name = line.substring(0, i);
            this.value = i < line.length() - 1 ? this.unwrap(line.substring(i + 1)) : null;
            return this;
        }

        Attribute add(String line) {
            this.value = this.value == null ? line : this.value + "\n" + line;
            return this;
        }

        private String unwrap(String text) {
            return text.startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text;
        }

        public String toString() {
            return this.name + ": " + (this.isMultiline() ? Attribute.indent(this.value) : this.value);
        }

        private static String indent(String text) {
            return "\n\t" + text.replaceAll("\\n", "\n\t");
        }

        private boolean isMultiline() {
            return this.value.contains("\n");
        }
    }

    public static interface Data {
        public <T> T as(Class<T> var1);
    }
}

