/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Accessory;
import io.intino.ness.inl.Message;
import io.intino.ness.inl.MessageInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Formats {

    public static class Csv
    implements MessageInputStream {
        private String name;
        protected BufferedReader reader;
        protected String[] headers;

        public static MessageInputStream of(InputStream is) throws IOException {
            return new Csv(is);
        }

        protected Csv(InputStream is) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(is), 65536);
            this.headers = this.nextRow();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void name(String value) {
            this.name = value;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Message next() throws IOException {
            String[] data;
            do {
                if ((data = this.nextRow()) != null) continue;
                return null;
            } while (data.length == 0);
            Message message = new Message("");
            for (int i = 0; i < Math.min(data.length, this.headers.length); ++i) {
                message.write(this.headers[i].trim(), data[i].trim());
            }
            return message;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        protected String[] nextRow() throws IOException {
            String line = this.reader.readLine();
            return line != null ? line.split(";") : null;
        }
    }

    public static class Dat
    extends Csv {
        protected final String[] data;

        public static MessageInputStream of(InputStream is) throws IOException {
            return new Dat(is);
        }

        private Dat(InputStream is) throws IOException {
            super(is);
            this.data = this.parse(this.headers);
            this.headers = this.nextRow();
        }

        private String[] parse(String[] headers) {
            ArrayList<String> data = new ArrayList<String>();
            for (String header : headers) {
                data.addAll(this.parse(header.trim()));
            }
            return data.toArray(new String[data.size()]);
        }

        private List<String> parse(String header) {
            ArrayList<String> data = new ArrayList<String>();
            for (String str : header.split(" ")) {
                int index = str.indexOf(61);
                if (index < 0) continue;
                data.add(str.substring(0, index));
                data.add(str.substring(index + 1));
            }
            return data;
        }

        @Override
        public Message next() throws IOException {
            Message message = super.next();
            if (message == null) {
                return null;
            }
            if (!this.isOdd(this.data.length)) {
                return message;
            }
            for (int i = 0; i < this.data.length; i += 2) {
                message.write(this.data[i], this.data[i + 1]);
            }
            return message;
        }

        private boolean isOdd(int i) {
            return i / 2 * 2 == i;
        }
    }

    public static class Tsv
    extends Csv {
        public static MessageInputStream of(InputStream is) throws IOException {
            return new Tsv(is);
        }

        private Tsv(InputStream is) throws IOException {
            super(is);
        }

        @Override
        protected String[] nextRow() throws IOException {
            String line = this.reader.readLine();
            return line != null ? line.split("\\t") : null;
        }
    }

    public static class Inl
    implements MessageInputStream {
        private String name;
        private BufferedReader reader;
        private Message message;

        public static MessageInputStream of(InputStream is) throws IOException {
            return new Inl(is);
        }

        private Inl(InputStream is) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(is), 65536);
            this.message = this.createMessage(Inl.typeIn(this.nextLine()), null);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void name(String value) {
            this.name = value;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Message next() throws IOException {
            if (this.message == null) {
                return null;
            }
            Message.Attribute attribute = new Message.Attribute();
            Message scope = this.message;
            String line;
            while ((line = this.nextLine()) != null) {
                if (Accessory.isMultilineIn(line)) {
                    scope.write(attribute.add(line.substring(1)));
                    continue;
                }
                if (Accessory.isAttributeIn(line)) {
                    attribute = attribute.parse(line);
                    scope.write(attribute);
                    continue;
                }
                if (!Accessory.isMessageIn(line)) continue;
                Message owner = this.ownerIn(line);
                Message message = this.createMessage(Inl.typeIn(line), owner);
                if (owner == null) {
                    return this.swap(message);
                }
                scope = message;
            }
            return this.swap(null);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        private Message swap(Message message) {
            Message result = this.message;
            this.message = message;
            return result;
        }

        private String nextLine() throws IOException {
            return Accessory.normalize(this.reader.readLine());
        }

        private Message createMessage(String type, Message owner) {
            Message message = new Message(type, owner);
            if (owner != null) {
                owner.components.add(message);
            }
            return message;
        }

        private Message ownerIn(String line) {
            if (!line.contains(".")) {
                return null;
            }
            Message result = this.message;
            for (int i = 1; i < Inl.pathOf(line).length - 1; ++i) {
                assert (result != null);
                result = this.lastItemOf(result.components);
            }
            return result;
        }

        private Message lastItemOf(List<Message> messages) {
            return messages.isEmpty() ? null : messages.get(messages.size() - 1);
        }

        private static String typeIn(String line) {
            String[] path = Inl.pathOf(line);
            return path[path.length - 1];
        }

        private static String[] pathOf(String line) {
            String[] stringArray;
            if ((line = line.substring(1, line.length() - 1)).contains(".")) {
                stringArray = line.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = line;
            }
            return stringArray;
        }
    }
}

