/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Formats;
import io.intino.ness.inl.MessageInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;

public class FileMessageInputStream {
    private static Map<String, Format> formats = new HashMap<String, Format>();

    public static MessageInputStream of(File file) throws IOException {
        Format format = FileMessageInputStream.formatOf(file);
        if (format == Format.inl) {
            return FileMessageInputStream.name(MessageInputStream.Sort.of(Formats.Inl.of(FileMessageInputStream.streamOf(file))), file);
        }
        if (format == Format.inz) {
            return FileMessageInputStream.name(Formats.Inl.of(FileMessageInputStream.streamOf(file)), file);
        }
        if (format == Format.csv) {
            return FileMessageInputStream.name(Formats.Csv.of(FileMessageInputStream.streamOf(file)), file);
        }
        if (format == Format.tsv) {
            return FileMessageInputStream.name(Formats.Tsv.of(FileMessageInputStream.streamOf(file)), file);
        }
        if (format == Format.dat) {
            return FileMessageInputStream.name(Formats.Dat.of(FileMessageInputStream.streamOf(file)), file);
        }
        return new MessageInputStream.Empty();
    }

    private static MessageInputStream name(MessageInputStream inputStream, File file) {
        inputStream.name(file.getName());
        return inputStream;
    }

    public static MessageInputStream of(File ... files) throws IOException {
        MessageInputStream[] inputStreams = new MessageInputStream[files.length];
        for (int i = 0; i < files.length; ++i) {
            inputStreams[i] = FileMessageInputStream.of(files[i]);
        }
        return MessageInputStream.Sort.of(inputStreams);
    }

    private static InputStream streamOf(File file) throws IOException {
        return FileMessageInputStream.isZip(file) ? FileMessageInputStream.zipStreamOf(file) : new FileInputStream(file);
    }

    private static boolean isZip(File file) {
        return file.getName().endsWith(".zip");
    }

    private static InputStream zipStreamOf(File file) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(new FileInputStream(file));
        zipStream.getNextEntry();
        return zipStream;
    }

    private static Format formatOf(File file) {
        String name = file.getName().toLowerCase();
        for (String extension : formats.keySet()) {
            if (!name.endsWith(extension)) continue;
            return formats.get(extension);
        }
        return Format.unknown;
    }

    static {
        formats.put(".inl", Format.inl);
        formats.put(".zip", Format.inz);
        formats.put(".csv", Format.csv);
        formats.put(".tsv", Format.tsv);
        formats.put(".dat", Format.dat);
        formats.put(".xml", Format.xml);
    }

    public static enum Format {
        inl,
        inz,
        csv,
        tsv,
        dat,
        xml,
        unknown;

    }
}

