/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness;

import io.intino.ness.inl.Deserializer;
import io.intino.ness.inl.Formats;
import io.intino.ness.inl.Message;
import io.intino.ness.inl.MessageInputStream;
import io.intino.ness.inl.Serializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Inl {
    public static String serialize(Object object) {
        return Serializer.serialize(object).toInl();
    }

    public static Deserializer deserialize(InputStream is) {
        return Deserializer.deserialize(is);
    }

    public static Deserializer deserialize(String text) {
        return Inl.deserialize(new ByteArrayInputStream(text.getBytes()));
    }

    public static <T> List<T> deserializeAll(InputStream is, Class<T> aClass) {
        T object;
        ArrayList<T> list = new ArrayList<T>();
        Deserializer deserialize = Inl.deserialize(is);
        while ((object = deserialize.next(aClass)) != null) {
            list.add(object);
        }
        return list;
    }

    public static <T> List<T> deserializeAll(String text, Class<T> aClass) {
        return Inl.deserializeAll(new ByteArrayInputStream(text.getBytes()), aClass);
    }

    public static List<Message> load(String text) {
        ArrayList<Message> list = new ArrayList<Message>();
        try {
            Message message;
            MessageInputStream inputStream = Formats.Inl.of(new ByteArrayInputStream(text.getBytes()));
            while ((message = inputStream.next()) != null) {
                list.add(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }
}

