/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.ness.datalake.file.FileDatalake;
import io.intino.ness.ingestion.EventSessionManager;
import io.intino.ness.ingestion.FileStage;
import io.intino.ness.ingestion.Session;
import io.intino.ness.ingestion.SessionManager;
import io.intino.ness.ingestion.SetIndexer;
import io.intino.ness.ingestion.SetSessionManager;
import java.io.File;
import java.util.stream.Stream;

public class FileSessionManager
implements SessionManager {
    private final File sessionsFolder;
    private final FileStage stage;
    private final FileDatalake datalake;

    public FileSessionManager(FileDatalake datalake, File sessionsFolder) {
        this.datalake = datalake;
        this.sessionsFolder = sessionsFolder;
        this.stage = new FileStage(datalake.stageFolder(), sessionsFolder);
    }

    @Override
    public void push(Stream<Session> sessions) {
        this.stage.push(sessions);
    }

    @Override
    public void seal() {
        this.sealEvents();
        this.sealSets();
        this.makeSetIndexes();
        this.stage.clear();
    }

    private void makeSetIndexes() {
        new SetIndexer(this.datalake.setStoreFolder()).make();
    }

    private void sealSets() {
        SetSessionManager.seal(this.datalake.stageFolder(), this.datalake.setStoreFolder(), this.tempFolder());
    }

    private void sealEvents() {
        EventSessionManager.seal(this.datalake.stageFolder(), this.datalake.eventStoreFolder(), this.tempFolder());
    }

    private File tempFolder() {
        File temp = new File(this.sessionsFolder, "temp");
        temp.mkdir();
        return temp;
    }
}

