/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class FS {
    private File root;

    public FS(File root) {
        this.root = root;
    }

    public static Stream<File> foldersIn(File folder) {
        return Arrays.stream(new FS(folder).foldersIn(File::isDirectory, Sort.Normal));
    }

    public static Stream<File> foldersIn(File folder, Sort sort) {
        return Arrays.stream(new FS(folder).foldersIn(File::isDirectory, sort));
    }

    public static Stream<File> filesIn(File folder, FileFilter filter) {
        return Arrays.stream(new FS(folder).foldersIn(filter, Sort.Normal));
    }

    private File[] foldersIn(FileFilter filter, Sort sort) {
        File[] files = this.root.listFiles(filter);
        files = files == null ? new File[]{} : files;
        Arrays.sort(files, sort.comparator);
        return files;
    }

    public static void copyInto(File destination, InputStream inputStream) {
        try {
            Files.copy(inputStream, destination.toPath(), new CopyOption[0]);
            inputStream.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static Stream<File> allFilesIn(File directory, FileFilter filter) {
        return FS.allFilesIn(directory.toPath(), filter).stream();
    }

    private static List<File> allFilesIn(Path path, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0]) && filter.accept(entry.toFile())) {
                    files.addAll(FS.allFilesIn(entry, filter));
                    continue;
                }
                if (!filter.accept(entry.toFile())) continue;
                files.add(entry.toFile());
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return files;
    }

    public static enum Sort {
        Normal((x, y) -> x.getName().compareTo(y.getName())),
        Reversed((x, y) -> y.getName().compareTo(x.getName()));

        private final Comparator<File> comparator;

        private Sort(Comparator<File> comparator) {
            this.comparator = comparator;
        }
    }
}

