/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop.sessions;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.ingestion.Session;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class SessionWriter {
    private final FileSystem fs;
    private final Path path;

    public SessionWriter(FileSystem fs, Path path) {
        this.fs = fs;
        this.path = path;
    }

    public void write(Session session) {
        Text key = new Text();
        BytesWritable value = new BytesWritable();
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.fs.getConf(), (Path)new Path(this.fs.getUri().toString() + "/" + this.path), key.getClass(), value.getClass());){
            key.set(session.type().name() + "#" + session.name());
            byte[] bytes = IOUtils.toByteArray((InputStream)session.inputStream());
            value.set(bytes, 0, bytes.length);
            writer.append((Writable)key, (Writable)value);
            writer.sync();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

