/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop.sessions;

import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class SessionReader {
    private final FileSystem fs;
    private final Path path;

    public SessionReader(FileSystem fs, Path path) {
        this.fs = fs;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> read() {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            try (SequenceFile.Reader reader = null;){
                Text key = new Text();
                BytesWritable value = new BytesWritable();
                reader = new SequenceFile.Reader(this.fs.getConf(), new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path(this.fs.getUri().toString() + "/" + this.path)), SequenceFile.Reader.bufferSize((int)4096)});
                while (reader.next((Writable)key, (Writable)value)) {
                    map.put(key.toString(), value.getBytes());
                }
            }
            return map;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyMap();
        }
    }
}

