/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop;

import io.intino.alexandria.zet.ZOutputStream;
import io.intino.alexandria.zet.ZetStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class SetSequenceWriter {
    private final FileSystem fs;
    private final String path;

    SetSequenceWriter(FileSystem fs, String path) {
        this.fs = fs;
        this.path = path;
    }

    void write(ZetStream stream) throws IOException {
        Text key = new Text();
        BytesWritable value = new BytesWritable();
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.fs.getConf(), (Path)new Path(this.fs.getUri().toString() + "/" + this.path), key.getClass(), value.getClass());){
            key.set(this.path);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ZOutputStream zstream = new ZOutputStream((OutputStream)bytes);
            while (stream.hasNext()) {
                zstream.writeLong(stream.next());
            }
            value.set(bytes.toByteArray(), 0, bytes.size());
            writer.append((Writable)key, (Writable)value);
            writer.sync();
        }
    }
}

