/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop;

import io.intino.alexandria.inl.Message;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class MessageSequenceWriter {
    private final FileSystem hdfs;
    private final String path;

    public MessageSequenceWriter(FileSystem hdfs, String path) {
        this.hdfs = hdfs;
        this.path = path;
    }

    public void write(String sessionName, List<Message> messages) throws IOException {
        Text key = new Text();
        Text value = new Text();
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.hdfs, (Configuration)this.hdfs.getConf(), (Path)new Path(this.path), key.getClass(), value.getClass());){
            for (Message message : messages) {
                key.set(sessionName);
                value.set(message.toString());
                writer.append((Writable)key, (Writable)value);
            }
        }
    }
}

